/**ABDB**/CREATE TABLE `xqd62_weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT 0,
  `sid` int(11) NOT NULL DEFAULT 0,
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL DEFAULT 0,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `archived` tinyint(1) NOT NULL DEFAULT 0,
  `approved` tinyint(1) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 1,
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Establecer si el link aparece.',
  `xreference` varchar(50) NOT NULL COMMENT 'Una referencia para activar vínculos a datos externos conjuntos.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) NOT NULL COMMENT 'Control de acceso codificado de JSON.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_viewlevels`  VALUES 
('1', 'Publico', '0', '[1]'),
('2', 'Registrado', '1', '[6,2,8]'),
('3', 'Especial', '2', '[6,3,8]');
/**ABDB**/CREATE TABLE `xqd62_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `usertype` varchar(25) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  PRIMARY KEY (`id`),
  KEY `usertype` (`usertype`),
  KEY `idx_name` (`name`),
  KEY `idx_block` (`block`),
  KEY `username` (`username`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=620 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_users`  VALUES 
('619', 'Super User', 'jesus.a.r.b', 'jesus181078@hotmail.com', '594f90035423b809728079a39fee58a3:1uLIEkMC6NKhSUcxy1l2V5sv9Cvo0DD0', 'deprecated', '0', '1', '2013-03-02 12:03:27', '2013-03-03 10:52:12', '0', '', '0000-00-00 00:00:00', '0');
/**ABDB**/CREATE TABLE `xqd62_usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID Lista de referencia adyacente',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Anidadas conjunto lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Anidadas conjunto rgt.',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_usergroups`  VALUES 
('1', '0', '1', '20', 'Publico'),
('2', '1', '6', '17', 'Registrado'),
('3', '2', '7', '14', 'Autor'),
('4', '3', '8', '11', 'Editor'),
('5', '4', '9', '10', 'Publicador'),
('6', '1', '2', '5', 'Gestor'),
('7', '6', '3', '4', 'Administrador'),
('8', '1', '18', '19', 'Super Usuarios');
/**ABDB**/CREATE TABLE `xqd62_user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) NOT NULL,
  `profile_value` varchar(255) NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Tabla para almacenar el perfil de usuario';
/**ABDB**/CREATE TABLE `xqd62_user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `categoryid` int(11) DEFAULT 0,
  `name` varchar(100) DEFAULT '',
  `description` text NOT NULL,
  `element` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `folder` varchar(20) DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(10) DEFAULT '',
  `data` text NOT NULL,
  `detailsurl` text NOT NULL,
  `infourl` text NOT NULL,
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Actualizaciones disponibles';
/**ABDB**/CREATE TABLE `xqd62_update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Enlaces de los sitios de extensiones para actualizar';
/**ABDB**/INSERT INTO `xqd62_update_sites_extensions`  VALUES 
('1', '700'),
('2', '700'),
('3', '600'),
('3', '10012'),
('3', '10016'),
('3', '10020'),
('3', '10024'),
('3', '10027'),
('3', '10041'),
('3', '10044'),
('4', '10000'),
('4', '10054'),
('5', '10004'),
('6', '10020'),
('9', '10046'),
('10', '10047');
/**ABDB**/CREATE TABLE `xqd62_update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` text NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Actualizar Sitios';
/**ABDB**/INSERT INTO `xqd62_update_sites`  VALUES 
('1', 'Joomla Core', 'collection', 'http://update.joomla.org/core/list.xml', '1', '0'),
('2', 'Directorio de Extensiones Joomla', 'collection', 'http://update.joomla.org/jed/list.xml', '1', '0'),
('3', 'Accredited Joomla! Translations', 'collection', 'http://update.joomla.org/language/translationlist.xml', '1', '0'),
('4', '', 'collection', 'http://update.joomlart.com/service/tracking/list.xml', '1', '0'),
('5', 'Akeeba Backup Core Updates', 'extension', 'http://nocdn.akeebabackup.com/updates/abcore.xml', '1', '0'),
('6', 'J!German Language Updates', 'collection', 'http://update.jgerman.de/translationlist.xml', '1', '0'),
('9', 'Foxcontact update site', 'extension', 'http://www.fox.ra.it/phocadownload/foxcontact.xml', '1', '0'),
('10', 'JComments Update Site', 'extension', 'http://www.joomlatune.ru/updates/jcomments.xml', '1', '0');
/**ABDB**/CREATE TABLE `xqd62_update_categories` (
  `categoryid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT '',
  `description` text NOT NULL,
  `parent` int(11) DEFAULT 0,
  `updatesite` int(11) DEFAULT 0,
  PRIMARY KEY (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Actualizar Categorías';
/**ABDB**/CREATE TABLE `xqd62_template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_home` (`home`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_template_styles`  VALUES 
('2', 'bluestork', '1', '1', 'Bluestork - Defecto', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\"}'),
('3', 'atomic', '0', '0', 'Atomic - Defecto', '{}'),
('4', 'beez_20', '0', '0', 'Beez2 - Defecto', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"logo\":\"images\\/logo-js.png\",\"sitetitle\":\"Joomla! Spanish\",\"sitedescription\":\"Gestor de Contenido Open Source 2.5\",\"navposition\":\"left\",\"templatecolor\":\"personal\",\"html5\":\"0\"}'),
('5', 'hathor', '1', '0', 'Hathor - Default', '{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}'),
('6', 'beez5', '0', '0', 'Beez5 - Default', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"logo\":\"images\\/sampledata\\/fruitshop\\/fruits.gif\",\"sitetitle\":\"Joomla!\",\"sitedescription\":\"Open Source Content Management\",\"navposition\":\"left\",\"html5\":\"0\"}'),
('7', 'jm_corporate', '0', '1', 'jm_corporate - Defecto', '{}');
/**ABDB**/CREATE TABLE `xqd62_session` (
  `session_id` varchar(200) NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `guest` tinyint(4) unsigned DEFAULT 1,
  `time` varchar(14) DEFAULT '',
  `data` mediumtext DEFAULT NULL,
  `userid` int(11) DEFAULT 0,
  `username` varchar(150) DEFAULT '',
  `usertype` varchar(50) DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `whosonline` (`guest`,`usertype`),
  KEY `userid` (`userid`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_session`  VALUES 
('67asl18rqsmtdaibl74ma9kvc3', '1', '0', '1362307963', '__default|a:8:{s:15:\"session.counter\";i:10;s:19:\"session.timer.start\";i:1362307926;s:18:\"session.timer.last\";i:1362307961;s:17:\"session.timer.now\";i:1362307963;s:22:\"session.client.browser\";s:108:\"Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.22 (KHTML, like Gecko) Chrome/25.0.1364.97 Safari/537.22\";s:8:\"registry\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:11:\"application\";O:8:\"stdClass\":1:{s:4:\"lang\";s:0:\"\";}s:13:\"com_installer\";O:8:\"stdClass\":2:{s:7:\"message\";s:0:\"\";s:17:\"extension_message\";s:0:\"\";}}}s:4:\"user\";O:5:\"JUser\":25:{s:9:\"\0*\0isRoot\";b:1;s:2:\"id\";s:3:\"619\";s:4:\"name\";s:10:\"Super User\";s:8:\"username\";s:11:\"jesus.a.r.b\";s:5:\"email\";s:23:\"jesus181078@hotmail.com\";s:8:\"password\";s:65:\"594f90035423b809728079a39fee58a3:1uLIEkMC6NKhSUcxy1l2V5sv9Cvo0DD0\";s:14:\"password_clear\";s:0:\"\";s:8:\"usertype\";s:10:\"deprecated\";s:5:\"block\";s:1:\"0\";s:9:\"sendEmail\";s:1:\"1\";s:12:\"registerDate\";s:19:\"2013-03-02 12:03:27\";s:13:\"lastvisitDate\";s:19:\"2013-03-03 10:33:16\";s:10:\"activation\";s:1:\"0\";s:6:\"params\";s:0:\"\";s:6:\"groups\";a:1:{i:8;s:1:\"8\";}s:5:\"guest\";i:0;s:13:\"lastResetTime\";s:19:\"0000-00-00 00:00:00\";s:10:\"resetCount\";s:1:\"0\";s:10:\"\0*\0_params\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}}s:14:\"\0*\0_authGroups\";a:2:{i:0;i:1;i:1;i:8;}s:14:\"\0*\0_authLevels\";a:4:{i:0;i:1;i:1;i:1;i:2;i:2;i:3;i:3;}s:15:\"\0*\0_authActions\";N;s:12:\"\0*\0_errorMsg\";N;s:10:\"\0*\0_errors\";a:0:{}s:3:\"aid\";i:0;}s:13:\"session.token\";s:32:\"6febb1c7b436c716db5d83406385acbc\";}', '619', 'jesus.a.r.b', ''),
('8paam5psd8g46lfgeepvdn76p5', '0', '1', '1362307917', '__default|a:7:{s:15:\"session.counter\";i:4;s:19:\"session.timer.start\";i:1362307914;s:18:\"session.timer.last\";i:1362307916;s:17:\"session.timer.now\";i:1362307916;s:22:\"session.client.browser\";s:108:\"Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.22 (KHTML, like Gecko) Chrome/25.0.1364.97 Safari/537.22\";s:8:\"registry\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}}s:4:\"user\";O:5:\"JUser\":25:{s:9:\"\0*\0isRoot\";N;s:2:\"id\";i:0;s:4:\"name\";N;s:8:\"username\";N;s:5:\"email\";N;s:8:\"password\";N;s:14:\"password_clear\";s:0:\"\";s:8:\"usertype\";N;s:5:\"block\";N;s:9:\"sendEmail\";i:0;s:12:\"registerDate\";N;s:13:\"lastvisitDate\";N;s:10:\"activation\";N;s:6:\"params\";N;s:6:\"groups\";a:0:{}s:5:\"guest\";i:1;s:13:\"lastResetTime\";N;s:10:\"resetCount\";N;s:10:\"\0*\0_params\";O:9:\"JRegistry\":1:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}}s:14:\"\0*\0_authGroups\";N;s:14:\"\0*\0_authLevels\";a:2:{i:0;i:1;i:1;i:1;}s:15:\"\0*\0_authActions\";N;s:12:\"\0*\0_errorMsg\";N;s:10:\"\0*\0_errors\";a:0:{}s:3:\"aid\";i:0;}}', '0', '', '');
/**ABDB**/CREATE TABLE `xqd62_schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_schemas`  VALUES 
('700', '2.5.9'),
('10005', '2.4.2-2012-10-20'),
('10046', '1.9.0');
/**ABDB**/CREATE TABLE `xqd62_redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(255) NOT NULL,
  `new_url` varchar(255) NOT NULL,
  `referer` varchar(150) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_link_old` (`old_url`),
  KEY `idx_link_modifed` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) NOT NULL,
  `string` text NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT 0,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `link` varchar(200) NOT NULL DEFAULT '',
  `filename` varchar(200) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `numarticles` int(10) unsigned NOT NULL DEFAULT 1,
  `cache_time` int(10) unsigned NOT NULL DEFAULT 3600,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rtl` tinyint(4) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'Una referencia para los vínculos a datos externos conjuntos.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT 0,
  `menuid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_modules_menu`  VALUES 
('1', '0'),
('2', '0'),
('3', '0'),
('4', '0'),
('6', '0'),
('7', '0'),
('8', '0'),
('9', '0'),
('10', '0'),
('12', '0'),
('13', '0'),
('14', '0'),
('15', '0'),
('16', '0'),
('17', '0'),
('79', '0'),
('86', '0'),
('88', '0'),
('89', '0'),
('90', '0'),
('91', '0');
/**ABDB**/CREATE TABLE `xqd62_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `params` text NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_modules`  VALUES 
('1', 'Menú Principal', '', '', '1', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"startLevel\":\"0\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"\",\"moduleclass_sfx\":\"_menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'),
('2', 'Acceso', '', '', '1', 'login', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '', '1', '*'),
('3', 'Artículos populares', '', '', '3', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('4', 'Últimos artículos añadidos', '', '', '4', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('8', 'Barra de herramientas', '', '', '1', 'toolbar', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_toolbar', '3', '1', '', '1', '*'),
('9', 'Iconos rápidos', '', '', '1', 'icon', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_quickicon', '3', '1', '', '1', '*'),
('10', 'Usuarios conectados', '', '', '2', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_logged', '3', '1', '', '1', '*'),
('12', 'Menú Administrador', '', '', '1', 'menu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '3', '1', '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', '1', '*'),
('13', 'Submenú Administrador', '', '', '1', 'submenu', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_submenu', '3', '1', '', '1', '*'),
('14', 'Estado usuarios', '', '', '1', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_status', '3', '1', '', '1', '*'),
('15', 'Título', '', '', '1', 'title', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_title', '3', '1', '', '1', '*'),
('16', 'Formulario de acceso', '', '', '7', 'position-7', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '{\"greeting\":\"1\",\"name\":\"0\"}', '0', '*'),
('17', 'Ruta', '', '', '1', 'position-2', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_breadcrumbs', '1', '1', '{\"moduleclass_sfx\":\"\",\"showHome\":\"1\",\"homeText\":\"Inicio\",\"showComponent\":\"1\",\"separator\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'),
('18', 'Anuncio', '', '', '1', 'position-10', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_banners', '1', '0', '{\"target\":\"1\",\"count\":\"1\",\"cid\":\"3\",\"catid\":[\"\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"Cursos Online\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}', '0', '*'),
('79', 'Estatus Multilenguaje', '', '', '1', 'status', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('86', 'Versión de Joomla', '', '', '1', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_version', '3', '1', '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('87', 'Akeeba Backup Notification Module', '', '', '0', 'cpanel', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_akadmin', '1', '1', '', '1', '*'),
('88', 'Admin Tools Joomla! Upgrade Notification', '', '', '2', 'icon', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_atjupgrade', '1', '1', '', '1', '*'),
('89', 'Buscar', '', '', '2', 'search', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_search', '1', '0', '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"1\",\"button_pos\":\"right\",\"imagebutton\":\"\",\"button_text\":\"Buscar\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '0', '*'),
('90', 'JoomFish language selector', '', '', '0', 'position-6', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_jflanguageselection', '1', '1', '', '0', '*'),
('91', 'Cambiar de Idioma', '', '', '1', 'search', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_jflanguageselection', '1', '0', '{\"type\":\"rawimages\",\"show_active\":\"1\",\"inc_jf_css\":\"1\",\"moduleclass_sfx\":\"\",\"cache_href\":\"1\"}', '0', '*'),
('95', 'Simple Image Holder', '', '', '0', '', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', 'mod_sih', '1', '1', '', '0', '*');
/**ABDB**/CREATE TABLE `xqd62_messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id_to` int(10) unsigned NOT NULL DEFAULT 0,
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `priority` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_menu_types`  VALUES 
('1', 'mainmenu', 'Menú Principal', 'El menú principal del sitio');
/**ABDB**/CREATE TABLE `xqd62_languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lang_code` char(7) NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_native` varchar(50) NOT NULL,
  `sef` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `description` varchar(512) NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `sitename` varchar(1024) NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_image` (`image`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_languages`  VALUES 
('1', 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', '0', '0', '2'),
('3', 'es-ES', 'Español (Formal Internacional) (ES)', 'Español (Formal Internacional) (ES)', 'es', 'es', '', '', '', '', '0', '0', '1'),
('4', 'ca-ES', 'CatalanCatal-ca_ES', 'CatalanCatal-ca_ES', 'ca', 'ca', '', '', '', '', '0', '0', '0'),
('5', 'de-DE', 'GermanDE-CH-AT', 'GermanDE-CH-AT', 'de', 'de', '', '', '', '', '0', '0', '3'),
('6', 'fr-FR', 'Frenchfr-FR', 'Frenchfr-FR', 'fr', 'fr', '', '', '', '', '0', '0', '4'),
('7', 'it-IT', 'ItalianItaly', 'ItalianItaly', 'it', 'it', '', '', '', '', '0', '0', '5'),
('8', 'zh-TW', 'TraditionalChineseTaiwan', 'TraditionalChineseTaiwan', 'zh', 'zh', '', '', '', '', '0', '0', '6'),
('9', 'gl-ES', 'GalicianGalego', 'GalicianGalego', 'gl', 'gl', '', '', '', '', '0', '0', '0'),
('10', 'pt-BR', 'PortugusBrasil', 'PortugusBrasil', 'pt', 'pt', '', '', '', '', '0', '0', '6');
/**ABDB**/CREATE TABLE `xqd62_jf_translationmap` (
  `language` char(7) NOT NULL DEFAULT '',
  `reference_id` int(11) NOT NULL DEFAULT 0,
  `translation_id` int(11) NOT NULL DEFAULT 0,
  `reference_table` varchar(100) NOT NULL DEFAULT '',
  UNIQUE KEY `language` (`language`,`reference_id`,`reference_table`),
  UNIQUE KEY `language_2` (`language`,`translation_id`,`reference_table`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_jf_tableinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `joomlatablename` varchar(100) NOT NULL DEFAULT '',
  `tablepkID` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_jf_tableinfo`  VALUES 
('67', 'banner_clients', 'id'),
('68', 'banners', 'id'),
('69', 'categories', 'id'),
('70', 'contact_details', 'id'),
('71', 'content', 'id'),
('72', 'languages', 'lang_id'),
('73', 'menu', 'id'),
('74', 'modules', 'id'),
('75', 'newsfeeds', 'id'),
('76', 'users', 'id'),
('77', 'weblinks', 'id');
/**ABDB**/CREATE TABLE `xqd62_jf_languages_ext` (
  `lang_id` int(11) NOT NULL AUTO_INCREMENT,
  `image_ext` varchar(100) DEFAULT NULL,
  `fallback_code` varchar(20) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`lang_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_jf_languages_ext`  VALUES 
('1', 'media/mod_languages/images/en.gif', '', '', '2'),
('3', 'media/mod_languages/images/es.gif', '', '', '1'),
('4', 'media/com_joomfish/default/flags/ca.gif', '', '', '0'),
('5', 'media/com_joomfish/default/flags/de.gif', '', '', '3'),
('6', 'media/com_joomfish/default/flags/fr.gif', '', '', '4'),
('7', 'media/com_joomfish/default/flags/it.gif', '', '', '5'),
('8', 'media/com_joomfish/default/flags/zh.gif', '', '', '6'),
('9', 'media/com_joomfish/default/flags/gl.gif', '', '', '0'),
('10', 'media/com_joomfish/default/flags/pt.gif', '', '', '6');
/**ABDB**/CREATE TABLE `xqd62_jf_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT 0,
  `reference_id` int(11) NOT NULL DEFAULT 0,
  `reference_table` varchar(100) NOT NULL DEFAULT '',
  `reference_field` varchar(100) NOT NULL DEFAULT '',
  `value` mediumtext NOT NULL,
  `original_value` varchar(255) DEFAULT NULL,
  `original_text` mediumtext NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `combo` (`reference_id`,`reference_field`,`reference_table`),
  KEY `jfContent` (`language_id`,`reference_id`,`reference_table`),
  KEY `jfContentLanguage` (`reference_id`,`reference_field`,`reference_table`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_jcomments_votes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `commentid` int(11) unsigned NOT NULL DEFAULT 0,
  `userid` int(11) unsigned NOT NULL DEFAULT 0,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `value` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_comment` (`commentid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_jcomments_version` (
  `version` varchar(16) NOT NULL DEFAULT '',
  `previous` varchar(16) NOT NULL DEFAULT '',
  `installed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_jcomments_version`  VALUES 
('2.3.0', '', '2013-03-03 02:04:11', '0000-00-00 00:00:00');
/**ABDB**/CREATE TABLE `xqd62_jcomments_subscriptions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(11) unsigned NOT NULL DEFAULT 0,
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `lang` varchar(255) NOT NULL DEFAULT '',
  `userid` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `hash` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `source` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_object` (`object_id`,`object_group`),
  KEY `idx_lang` (`lang`),
  KEY `idx_source` (`source`),
  KEY `idx_hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_jcomments_settings` (
  `component` varchar(50) NOT NULL DEFAULT '',
  `lang` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  PRIMARY KEY (`component`,`lang`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_jcomments_settings`  VALUES 
('', '', 'author_email', '2'),
('', '', 'author_homepage', '1'),
('', '', 'author_name', '2'),
('', '', 'autolinkurls', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'autopublish', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'badwords', ''),
('', '', 'can_ban', 'Administrator,Super Users'),
('', '', 'can_comment', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'can_delete', 'Manager,Administrator,Super Users'),
('', '', 'can_delete_for_my_object', ''),
('', '', 'can_delete_own', 'Manager,Administrator,Super Users'),
('', '', 'can_edit', 'Manager,Administrator,Super Users'),
('', '', 'can_edit_for_my_object', ''),
('', '', 'can_edit_own', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'can_publish', 'Publisher,Manager,Administrator,Super Users'),
('', '', 'can_publish_for_my_object', ''),
('', '', 'can_reply', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'can_report', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'can_view_email', 'Manager,Administrator,Super Users'),
('', '', 'can_view_homepage', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'can_view_ip', 'Administrator,Super Users'),
('', '', 'can_vote', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'censor_replace_word', '[censored]'),
('', '', 'comments_order', 'DESC'),
('', '', 'comments_page_limit', '15'),
('', '', 'comments_pagination', 'both'),
('', '', 'comments_per_page', '10'),
('', '', 'comment_maxlength', '1000'),
('', '', 'comment_minlength', '0'),
('', '', 'comment_title', '0'),
('', '', 'delete_mode', '0'),
('', '', 'display_author', 'name'),
('', '', 'emailprotection', '1'),
('', '', 'enable_autocensor', '1'),
('', '', 'enable_bbcode_b', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_code', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_hide', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_i', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_img', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_list', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_quote', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_s', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_u', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_bbcode_url', 'Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_blacklist', '0'),
('', '', 'enable_captcha', '1'),
('', '', 'enable_categories', ''),
('', '', 'enable_comment_length_check', '1,Registered'),
('', '', 'enable_comment_maxlength_check', ''),
('', '', 'enable_custom_bbcode', '0'),
('', '', 'enable_geshi', '0'),
('', '', 'enable_gravatar', ''),
('', '', 'enable_mambots', '1'),
('', '', 'enable_nested_quotes', '1'),
('', '', 'enable_notification', '0'),
('', '', 'enable_quick_moderation', '0'),
('', '', 'enable_rss', '1'),
('', '', 'enable_smiles', '1'),
('', '', 'enable_subscribe', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users'),
('', '', 'enable_username_check', '1'),
('', '', 'enable_voting', '1'),
('', '', 'feed_limit', '100'),
('', '', 'floodprotection', '1,Registered,Author,4'),
('', '', 'flood_time', '30'),
('', '', 'forbidden_names', 'administrator,moderator'),
('', '', 'form_show', '1'),
('', '', 'link_maxlength', '30'),
('', '', 'merge_time', '0'),
('', '', 'message_locked', 'Comments are now closed for this entry'),
('', '', 'message_policy_post', ''),
('', '', 'message_policy_whocancomment', 'You have no rights to post comments'),
('', '', 'notification_email', ''),
('', '', 'notification_type', '1,2'),
('', '', 'report_reason_required', '1'),
('', '', 'show_commentlength', '1'),
('', '', 'show_policy', '1,Registered'),
('', '', 'smiles', ':D	laugh.gif\n:lol:	lol.gif\n:-)	smile.gif\n;-)	wink.gif\n8)	cool.gif\n:-|	normal.gif\n:-*	whistling.gif\n:oops:	redface.gif\n:sad:	sad.gif\n:cry:	cry.gif\n:o	surprised.gif\n:-?	confused.gif\n:-x	sick.gif\n:eek:	shocked.gif\n:zzz	sleeping.gif\n:P	tongue.gif\n:roll:	rolleyes.gif\n:sigh:	unsure.gif'),
('', '', 'smiles_path', '/components/com_jcomments/images/smiles/'),
('', '', 'template', 'default'),
('', '', 'template_view', 'list'),
('', '', 'tree_order', '0'),
('', '', 'username_maxlength', '20'),
('', '', 'word_maxlength', '15'),
('', 'es-ES', 'author_email', '1'),
('', 'es-ES', 'author_homepage', '0'),
('', 'es-ES', 'author_name', '2'),
('', 'es-ES', 'autolinkurls', '4'),
('', 'es-ES', 'autopublish', '4'),
('', 'es-ES', 'badwords', ''),
('', 'es-ES', 'can_ban', ''),
('', 'es-ES', 'can_comment', '1,4'),
('', 'es-ES', 'can_delete', ''),
('', 'es-ES', 'can_delete_for_my_object', ''),
('', 'es-ES', 'can_delete_own', ''),
('', 'es-ES', 'can_edit', ''),
('', 'es-ES', 'can_edit_for_my_object', ''),
('', 'es-ES', 'can_edit_own', '4'),
('', 'es-ES', 'can_publish', ''),
('', 'es-ES', 'can_publish_for_my_object', ''),
('', 'es-ES', 'can_reply', '1,4'),
('', 'es-ES', 'can_report', ''),
('', 'es-ES', 'can_view_email', ''),
('', 'es-ES', 'can_view_homepage', '4'),
('', 'es-ES', 'can_view_ip', ''),
('', 'es-ES', 'can_vote', '1,4'),
('', 'es-ES', 'captcha_engine', 'kcaptcha'),
('', 'es-ES', 'censor_replace_word', '[censored]'),
('', 'es-ES', 'comments_order', 'DESC'),
('', 'es-ES', 'comments_page_limit', '15'),
('', 'es-ES', 'comments_pagination', 'both'),
('', 'es-ES', 'comments_per_page', '10'),
('', 'es-ES', 'comment_maxlength', '1000'),
('', 'es-ES', 'comment_minlength', '0'),
('', 'es-ES', 'comment_title', '0'),
('', 'es-ES', 'delete_mode', '0'),
('', 'es-ES', 'display_author', 'username'),
('', 'es-ES', 'emailprotection', '1'),
('', 'es-ES', 'enable_autocensor', '1'),
('', 'es-ES', 'enable_bbcode_b', '1,4'),
('', 'es-ES', 'enable_bbcode_code', ''),
('', 'es-ES', 'enable_bbcode_hide', '4'),
('', 'es-ES', 'enable_bbcode_i', '1,4'),
('', 'es-ES', 'enable_bbcode_img', '1,4'),
('', 'es-ES', 'enable_bbcode_list', '1,4'),
('', 'es-ES', 'enable_bbcode_quote', '1,4'),
('', 'es-ES', 'enable_bbcode_s', '1,4'),
('', 'es-ES', 'enable_bbcode_u', '1,4'),
('', 'es-ES', 'enable_bbcode_url', '1,4'),
('', 'es-ES', 'enable_blacklist', '0'),
('', 'es-ES', 'enable_captcha', '1'),
('', 'es-ES', 'enable_categories', '8'),
('', 'es-ES', 'enable_comment_length_check', '1'),
('', 'es-ES', 'enable_comment_maxlength_check', ''),
('', 'es-ES', 'enable_custom_bbcode', '0'),
('', 'es-ES', 'enable_geshi', '0'),
('', 'es-ES', 'enable_gravatar', ''),
('', 'es-ES', 'enable_mambots', '1'),
('', 'es-ES', 'enable_nested_quotes', '1'),
('', 'es-ES', 'enable_notification', '1'),
('', 'es-ES', 'enable_quick_moderation', '0'),
('', 'es-ES', 'enable_reports', '0'),
('', 'es-ES', 'enable_rss', '1'),
('', 'es-ES', 'enable_smiles', '1'),
('', 'es-ES', 'enable_subscribe', '1,4'),
('', 'es-ES', 'enable_username_check', '1'),
('', 'es-ES', 'enable_voting', '1'),
('', 'es-ES', 'feed_limit', '100'),
('', 'es-ES', 'floodprotection', '1,4'),
('', 'es-ES', 'flood_time', '30'),
('', 'es-ES', 'forbidden_names', 'administrator,moderator'),
('', 'es-ES', 'form_position', '0'),
('', 'es-ES', 'form_show', '1'),
('', 'es-ES', 'link_maxlength', '30'),
('', 'es-ES', 'load_cached_comments', '0'),
('', 'es-ES', 'max_comments_per_object', '0'),
('', 'es-ES', 'merge_time', '0'),
('', 'es-ES', 'message_banned', ''),
('', 'es-ES', 'message_locked', 'Comments are now closed for this entry'),
('', 'es-ES', 'message_policy_post', ''),
('', 'es-ES', 'message_policy_whocancomment', 'You have no rights to post comments'),
('', 'es-ES', 'notification_email', 'jesus181078@hotmail.com'),
('', 'es-ES', 'notification_type', '1,2'),
('', 'es-ES', 'reports_before_unpublish', '0'),
('', 'es-ES', 'reports_per_comment', '0'),
('', 'es-ES', 'report_reason_required', '1'),
('', 'es-ES', 'show_commentlength', '1'),
('', 'es-ES', 'show_policy', '1'),
('', 'es-ES', 'smiles', ':D	laugh.gif\n:lol:	lol.gif\n:-)	smile.gif\n;-)	wink.gif\n8)	cool.gif\n:-|	normal.gif\n:-*	whistling.gif\n:oops:	redface.gif\n:sad:	sad.gif\n:cry:	cry.gif\n:o	surprised.gif\n:-?	confused.gif\n:-x	sick.gif\n:eek:	shocked.gif\n:zzz	sleeping.gif\n:P	tongue.gif\n:roll:	rolleyes.gif\n:sigh:	unsure.gif'),
('', 'es-ES', 'smiles_path', '/components/com_jcomments/images/smiles/'),
('', 'es-ES', 'template', 'default'),
('', 'es-ES', 'template_view', 'list'),
('', 'es-ES', 'tree_order', '0'),
('', 'es-ES', 'username_maxlength', '20'),
('', 'es-ES', 'word_maxlength', '15');
/**ABDB**/CREATE TABLE `xqd62_jcomments_reports` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `commentid` int(11) unsigned NOT NULL DEFAULT 0,
  `userid` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reason` tinytext NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_jcomments_objects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(11) unsigned NOT NULL DEFAULT 0,
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `lang` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `access` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `userid` int(11) unsigned NOT NULL DEFAULT 0,
  `expired` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_object` (`object_id`,`object_group`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_jcomments_custom_bbcodes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `simple_pattern` varchar(255) NOT NULL DEFAULT '',
  `simple_replacement_html` text NOT NULL,
  `simple_replacement_text` text NOT NULL,
  `pattern` varchar(255) NOT NULL DEFAULT '',
  `replacement_html` text NOT NULL,
  `replacement_text` text NOT NULL,
  `button_acl` text NOT NULL,
  `button_open_tag` varchar(16) NOT NULL DEFAULT '',
  `button_close_tag` varchar(16) NOT NULL DEFAULT '',
  `button_title` varchar(255) NOT NULL DEFAULT '',
  `button_prompt` varchar(255) NOT NULL DEFAULT '',
  `button_image` varchar(255) NOT NULL DEFAULT '',
  `button_css` varchar(255) NOT NULL DEFAULT '',
  `button_enabled` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_jcomments_custom_bbcodes`  VALUES 
('1', 'YouTube Video', '[youtube]http://www.youtube.com/watch?v={IDENTIFIER}[/youtube]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/{IDENTIFIER}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/{IDENTIFIER}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.youtube.com/watch?v={IDENTIFIER}', '\\[youtube\\]http\\:\\/\\/www\\.youtube\\.com\\/watch\\?v\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/youtube\\]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/${1}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/${1}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.youtube.com/watch?v=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '[youtube]', '[/youtube]', 'YouTube Video', '', '', 'bbcode-youtube', '1', '1', '1'),
('2', 'YouTube Video (short syntax)', '[youtube]{IDENTIFIER}[/youtube]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/{IDENTIFIER}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/{IDENTIFIER}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.youtube.com/watch?v={IDENTIFIER}', '\\[youtube\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/youtube\\]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/${1}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/${1}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.youtube.com/watch?v=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '', '', '', '', '', '', '0', '2', '1'),
('3', 'YouTube Video (full syntax)', '[youtube]http://www.youtube.com/watch?v={IDENTIFIER}{TEXT}[/youtube]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/{IDENTIFIER}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/{IDENTIFIER}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.youtube.com/watch?v={IDENTIFIER}', '\\[youtube\\]http\\:\\/\\/www\\.youtube\\.com\\/watch\\?v\\=([A-Za-z0-9-_]+)([\\w0-9-\\+\\=\\!\\?\\(\\)\\[\\]\\{\\}\\&\\%\\*\\#\\.,_ ]+)\\[\\/youtube\\]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/${1}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/${1}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.youtube.com/watch?v=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '[youtube]', '[/youtube]', 'YouTube Video', '', '', '', '0', '3', '1'),
('4', 'Google Video', '[google]http://video.google.com/videoplay?docid={IDENTIFIER}[/google]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[google\\]http\\:\\/\\/video\\.google\\.com\\/videoplay\\?docid\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/google\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '[google]', '[/google]', 'Google Video', '', '', 'bbcode-google', '1', '4', '1'),
('5', 'Google Video (short syntax)', '[google]{IDENTIFIER}[/google]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[google\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/google\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '', '', '', '', '', '', '0', '5', '1'),
('6', 'Google Video (alternate syntax)', '[gv]http://video.google.com/videoplay?docid={IDENTIFIER}[/gv]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[gv\\]http\\:\\/\\/video\\.google\\.com\\/videoplay\\?docid\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/gv\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '', '', '', '', '', '', '0', '6', '1'),
('7', 'Google Video (alternate syntax)', '[googlevideo]http://video.google.com/videoplay?docid={IDENTIFIER}[/googlevideo]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[googlevideo\\]http\\:\\/\\/video\\.google\\.com\\/videoplay\\?docid\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/googlevideo\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '', '', '', '', '', '', '0', '7', '1'),
('8', 'Facebook Video', '[fv]http://www.facebook.com/video/video.php?v={IDENTIFIER}[/fv]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.facebook.com/v/{IDENTIFIER}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.facebook.com/v/{IDENTIFIER}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.facebook.com/video/video.php?v={IDENTIFIER}', '\\[fv\\]http\\:\\/\\/www\\.facebook\\.com\\/video\\/video\\.php\\?v\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/fv\\]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.facebook.com/v/${1}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.facebook.com/v/${1}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.facebook.com/video/video.php?v=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '[fv]', '[/fv]', 'Facebook Video', '', '', 'bbcode-facebook', '1', '8', '1'),
('9', 'Facebook Video (short syntax)', '[fv]{IDENTIFIER}[/fv]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.facebook.com/v/{IDENTIFIER}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.facebook.com/v/{IDENTIFIER}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.facebook.com/video/video.php?v={IDENTIFIER}', '\\[fv\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/fv\\]', '<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.facebook.com/v/${1}\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.facebook.com/v/${1}\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>', 'http://www.facebook.com/video/video.php?v=${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '', '', '', '', '', '', '0', '9', '1'),
('10', 'Wiki', '[wiki]{SIMPLETEXT}[/wiki]', '<a href=\"http://www.wikipedia.org/wiki/{SIMPLETEXT}\" title=\"{SIMPLETEXT}\" target=\"_blank\">{SIMPLETEXT}</a>', '{SIMPLETEXT}', '\\[wiki\\]([A-Za-z0-9\\-\\+\\.,_ ]+)\\[\\/wiki\\]', '<a href=\"http://www.wikipedia.org/wiki/${1}\" title=\"${1}\" target=\"_blank\">${1}</a>', '${1}', '1,Registered,Author,4,Publisher,Manager,Administrator,Super Users', '[wiki]', '[/wiki]', 'Wikipedia', '', '', 'bbcode-wiki', '1', '10', '1');
/**ABDB**/CREATE TABLE `xqd62_jcomments_blacklist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `userid` int(11) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) unsigned NOT NULL DEFAULT 0,
  `expire` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reason` tinytext NOT NULL,
  `notes` tinytext NOT NULL,
  `checked_out` int(11) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_jcomments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(11) unsigned NOT NULL DEFAULT 0,
  `thread_id` int(11) unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `level` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `object_id` int(11) unsigned NOT NULL DEFAULT 0,
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `object_params` text NOT NULL,
  `lang` varchar(255) NOT NULL DEFAULT '',
  `userid` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `homepage` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `comment` text NOT NULL,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `isgood` smallint(5) NOT NULL DEFAULT 0,
  `ispoor` smallint(5) NOT NULL DEFAULT 0,
  `published` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `subscribe` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `source` varchar(255) NOT NULL DEFAULT '',
  `source_id` int(11) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(11) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_userid` (`userid`),
  KEY `idx_source` (`source`),
  KEY `idx_email` (`email`),
  KEY `idx_lang` (`lang`),
  KEY `idx_subscribe` (`subscribe`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_object` (`object_id`,`object_group`,`published`,`date`),
  KEY `idx_path` (`path`,`level`),
  KEY `idx_thread` (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_foxcontact_settings` (
  `name` varchar(32) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_foxcontact_settings`  VALUES 
('captchadrawer', 'use_gd'),
('dns', 'dns_check'),
('mimefilter', 'use_fileinfo');
/**ABDB**/CREATE TABLE `xqd62_foxcontact_sessions` (
  `id` varchar(32) NOT NULL,
  `cid` int(11) NOT NULL,
  `mid` int(11) NOT NULL,
  `keyword` varchar(32) NOT NULL,
  `birth` timestamp NOT NULL DEFAULT current_timestamp(),
  `data` text DEFAULT NULL,
  UNIQUE KEY `index` (`id`,`cid`,`mid`,`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_finder_types`  VALUES 
('1', 'Category', ''),
('2', 'Contact', ''),
('3', 'Article', ''),
('4', 'News Feed', ''),
('5', 'Web Link', '');
/**ABDB**/CREATE TABLE `xqd62_finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `term_weight` float unsigned NOT NULL,
  `context` tinyint(1) unsigned NOT NULL DEFAULT 2,
  `context_weight` float unsigned NOT NULL,
  `total_weight` float unsigned NOT NULL,
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `weight` float unsigned NOT NULL DEFAULT 1,
  `context` tinyint(1) unsigned NOT NULL DEFAULT 2,
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL,
  KEY `idx_word_lang` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_finder_terms_common`  VALUES 
('a', 'en'),
('about', 'en'),
('after', 'en'),
('ago', 'en'),
('all', 'en'),
('am', 'en'),
('an', 'en'),
('and', 'en'),
('ani', 'en'),
('any', 'en'),
('are', 'en'),
('aren\'t', 'en'),
('as', 'en'),
('at', 'en'),
('be', 'en'),
('but', 'en'),
('by', 'en'),
('for', 'en'),
('from', 'en'),
('get', 'en'),
('go', 'en'),
('how', 'en'),
('if', 'en'),
('in', 'en'),
('into', 'en'),
('is', 'en'),
('isn\'t', 'en'),
('it', 'en'),
('its', 'en'),
('me', 'en'),
('more', 'en'),
('most', 'en'),
('must', 'en'),
('my', 'en'),
('new', 'en'),
('no', 'en'),
('none', 'en'),
('not', 'en'),
('noth', 'en'),
('nothing', 'en'),
('of', 'en'),
('off', 'en'),
('often', 'en'),
('old', 'en'),
('on', 'en'),
('onc', 'en'),
('once', 'en'),
('onli', 'en'),
('only', 'en'),
('or', 'en'),
('other', 'en'),
('our', 'en'),
('ours', 'en'),
('out', 'en'),
('over', 'en'),
('page', 'en'),
('she', 'en'),
('should', 'en'),
('small', 'en'),
('so', 'en'),
('some', 'en'),
('than', 'en'),
('thank', 'en'),
('that', 'en'),
('the', 'en'),
('their', 'en'),
('theirs', 'en'),
('them', 'en'),
('then', 'en'),
('there', 'en'),
('these', 'en'),
('they', 'en'),
('this', 'en'),
('those', 'en'),
('thus', 'en'),
('time', 'en'),
('times', 'en'),
('to', 'en'),
('too', 'en'),
('true', 'en'),
('under', 'en'),
('until', 'en'),
('up', 'en'),
('upon', 'en'),
('use', 'en'),
('user', 'en'),
('users', 'en'),
('veri', 'en'),
('version', 'en'),
('very', 'en'),
('via', 'en'),
('want', 'en'),
('was', 'en'),
('way', 'en'),
('were', 'en'),
('what', 'en'),
('when', 'en'),
('where', 'en'),
('whi', 'en'),
('which', 'en'),
('who', 'en'),
('whom', 'en'),
('whose', 'en'),
('why', 'en'),
('wide', 'en'),
('will', 'en'),
('with', 'en'),
('within', 'en'),
('without', 'en'),
('would', 'en'),
('yes', 'en'),
('yet', 'en'),
('you', 'en'),
('your', 'en'),
('yours', 'en');
/**ABDB**/CREATE TABLE `xqd62_finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `weight` float unsigned NOT NULL DEFAULT 0,
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term` (`term`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_taxonomy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `access` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `state` (`state`),
  KEY `ordering` (`ordering`),
  KEY `access` (`access`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_finder_taxonomy`  VALUES 
('1', '0', 'ROOT', '0', '0', '0');
/**ABDB**/CREATE TABLE `xqd62_finder_links_termsf` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_termse` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_termsd` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_termsc` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_termsb` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_termsa` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms9` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms8` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms7` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms6` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms5` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms4` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms3` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms2` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms1` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links_terms0` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `state` int(5) DEFAULT 1,
  `access` int(5) DEFAULT 0,
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT 0,
  `sale_price` double unsigned NOT NULL DEFAULT 0,
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_finder_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT 0,
  `data` text NOT NULL,
  `params` mediumtext DEFAULT NULL,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT 1,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `protected` tinyint(3) NOT NULL DEFAULT 0,
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `system_data` text NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT 0,
  `state` int(11) DEFAULT 0,
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10056 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_extensions`  VALUES 
('1', 'com_mailto', 'component', 'com_mailto', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('2', 'com_wrapper', 'component', 'com_wrapper', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('3', 'com_admin', 'component', 'com_admin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('4', 'com_banners', 'component', 'com_banners', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('5', 'com_cache', 'component', 'com_cache', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('6', 'com_categories', 'component', 'com_categories', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('7', 'com_checkin', 'component', 'com_checkin', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"Unknown\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('8', 'com_contact', 'component', 'com_contact', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('9', 'com_cpanel', 'component', 'com_cpanel', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10', 'com_installer', 'component', 'com_installer', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('11', 'com_languages', 'component', 'com_languages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"es-ES\",\"site\":\"es-ES\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('12', 'com_login', 'component', 'com_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('13', 'com_media', 'component', 'com_media', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\",\"enable_flash\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('14', 'com_menus', 'component', 'com_menus', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('15', 'com_messages', 'component', 'com_messages', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('16', 'com_modules', 'component', 'com_modules', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('17', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('18', 'com_plugins', 'component', 'com_plugins', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('19', 'com_search', 'component', 'com_search', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('20', 'com_templates', 'component', 'com_templates', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('21', 'com_weblinks', 'component', 'com_weblinks', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('22', 'com_content', 'component', 'com_content', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_icons\":\"0\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('23', 'com_config', 'component', 'com_config', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"10\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"12\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('24', 'com_redirect', 'component', 'com_redirect', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('25', 'com_users', 'component', 'com_users', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"useractivation\":\"1\",\"frontend_userparams\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('27', 'com_finder', 'component', 'com_finder', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('28', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '1', '1', '0', '1', '{\"legacy\":false,\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('100', 'PHPMailer', 'library', 'phpmailer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PHPMailer\",\"type\":\"library\",\"creationDate\":\"2001\",\"author\":\"PHPMailer\",\"copyright\":\"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2011, Jim Jagielski. All Rights Reserved.\",\"authorEmail\":\"jimjag@gmail.com\",\"authorUrl\":\"https:\\/\\/code.google.com\\/a\\/apache-extras.org\\/p\\/phpmailer\\/\",\"version\":\"5.2\",\"description\":\"LIB_PHPMAILER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('101', 'SimplePie', 'library', 'simplepie', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('102', 'phputf8', 'library', 'phputf8', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"phputf8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('103', 'Joomla! Platform', 'library', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"Joomla! Platform\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"11.4\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('200', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters.\\n\\t\\tAll rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('201', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('202', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('203', 'mod_banners', 'module', 'mod_banners', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('204', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('205', 'mod_custom', 'module', 'mod_custom', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('206', 'mod_feed', 'module', 'mod_feed', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('207', 'mod_footer', 'module', 'mod_footer', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('208', 'mod_login', 'module', 'mod_login', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('209', 'mod_menu', 'module', 'mod_menu', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('210', 'mod_articles_news', 'module', 'mod_articles_news', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('211', 'mod_random_image', 'module', 'mod_random_image', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('212', 'mod_related_items', 'module', 'mod_related_items', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('213', 'mod_search', 'module', 'mod_search', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('214', 'mod_stats', 'module', 'mod_stats', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('215', 'mod_syndicate', 'module', 'mod_syndicate', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('216', 'mod_users_latest', 'module', 'mod_users_latest', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('217', 'mod_weblinks', 'module', 'mod_weblinks', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('218', 'mod_whosonline', 'module', 'mod_whosonline', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('219', 'mod_wrapper', 'module', 'mod_wrapper', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('220', 'mod_articles_category', 'module', 'mod_articles_category', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('221', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('222', 'mod_languages', 'module', 'mod_languages', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('223', 'mod_finder', 'module', 'mod_finder', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('300', 'mod_custom', 'module', 'mod_custom', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('301', 'mod_feed', 'module', 'mod_feed', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('302', 'mod_latest', 'module', 'mod_latest', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('303', 'mod_logged', 'module', 'mod_logged', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('304', 'mod_login', 'module', 'mod_login', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('305', 'mod_menu', 'module', 'mod_menu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('307', 'mod_popular', 'module', 'mod_popular', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('308', 'mod_quickicon', 'module', 'mod_quickicon', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('309', 'mod_status', 'module', 'mod_status', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('310', 'mod_submenu', 'module', 'mod_submenu', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('311', 'mod_title', 'module', 'mod_title', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('312', 'mod_toolbar', 'module', 'mod_toolbar', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('313', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('314', 'mod_version', 'module', 'mod_version', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('400', 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('401', 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('402', 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'),
('404', 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('405', 'plg_content_geshi', 'plugin', 'geshi', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'),
('406', 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"style\":\"xhtml\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('407', 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'),
('408', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"position\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '5', '0'),
('409', 'plg_content_vote', 'plugin', 'vote', 'content', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '6', '0'),
('410', 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"linenumbers\":\"0\",\"tabmode\":\"indent\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('411', 'plg_editors_none', 'plugin', 'none', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"\",\"version\":\"2.5.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'),
('412', 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2013\",\"author\":\"Moxiecode Systems AB\",\"copyright\":\"Moxiecode Systems AB\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"tinymce.moxiecode.com\\/\",\"version\":\"3.5.4.1\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\"}', '{\"mode\":\"2\",\"skin\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"es\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"true\",\"resize_horizontal\":\"false\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"visualblocks\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'),
('413', 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('414', 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'),
('415', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'),
('416', 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'),
('417', 'plg_search_categories', 'plugin', 'categories', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('418', 'plg_search_contacts', 'plugin', 'contacts', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('419', 'plg_search_content', 'plugin', 'content', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('420', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('421', 'plg_search_weblinks', 'plugin', 'weblinks', 'search', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('422', 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '7', '0'),
('423', 'plg_system_p3p', 'plugin', 'p3p', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', '0', '0000-00-00 00:00:00', '8', '0'),
('424', 'plg_system_cache', 'plugin', 'cache', 'system', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', '0', '0000-00-00 00:00:00', '16', '0'),
('425', 'plg_system_debug', 'plugin', 'debug', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '10', '0'),
('426', 'plg_system_log', 'plugin', 'log', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '11', '0'),
('427', 'plg_system_redirect', 'plugin', 'redirect', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '12', '0'),
('428', 'plg_system_remember', 'plugin', 'remember', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '14', '0'),
('429', 'plg_system_sef', 'plugin', 'sef', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '15', '0'),
('430', 'plg_system_logout', 'plugin', 'logout', 'system', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '9', '0'),
('431', 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', '0', '0', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('432', 'plg_user_joomla', 'plugin', 'joomla', 'user', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2009 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autoregister\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'),
('433', 'plg_user_profile', 'plugin', 'profile', 'user', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('434', 'plg_extension_joomla', 'plugin', 'joomla', 'extension', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('435', 'plg_content_joomla', 'plugin', 'joomla', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('436', 'plg_system_languagecode', 'plugin', 'languagecode', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '17', '0'),
('437', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('438', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('439', 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('440', 'plg_system_highlight', 'plugin', 'highlight', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '13', '0'),
('441', 'plg_content_finder', 'plugin', 'finder', 'content', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('442', 'plg_finder_categories', 'plugin', 'categories', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('443', 'plg_finder_contacts', 'plugin', 'contacts', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'),
('444', 'plg_finder_content', 'plugin', 'content', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'),
('445', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'),
('446', 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'),
('500', 'atomic', 'template', 'atomic', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"atomic\",\"type\":\"template\",\"creationDate\":\"10\\/10\\/09\",\"author\":\"Ron Severdia\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"contact@kontentdesign.com\",\"authorUrl\":\"http:\\/\\/www.kontentdesign.com\",\"version\":\"2.5.0\",\"description\":\"TPL_ATOMIC_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('502', 'bluestork', 'template', 'bluestork', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"bluestork\",\"type\":\"template\",\"creationDate\":\"07\\/02\\/09\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"TPL_BLUESTORK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\",\"textBig\":\"0\",\"highContrast\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('503', 'beez_20', 'template', 'beez_20', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez_20\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ2_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('504', 'hathor', 'template', 'hathor', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"hathor@tarrconsulting.com\",\"authorUrl\":\"http:\\/\\/www.tarrconsulting.com\",\"version\":\"2.5.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('505', 'beez5', 'template', 'beez5', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"beez5\",\"type\":\"template\",\"creationDate\":\"21 May 2010\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ5_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"html5\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('600', 'English (United Kingdom)', 'language', 'en-GB', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.5\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('601', 'English (United Kingdom)', 'language', 'en-GB', '', '1', '1', '1', '1', '{\"legacy\":false,\"name\":\"English (United Kingdom)\",\"type\":\"language\",\"creationDate\":\"2008-03-15\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.5\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('604', 'Español (Formal Internacional)', 'language', 'es-ES', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"Espa\\u00f1ol (Formal Internacional)\",\"type\":\"language\",\"creationDate\":\"2012-09-14\",\"author\":\"Proyecto Joomla! Spanish\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. Todos los derechos reservados.\",\"authorEmail\":\"joomlaspanish@joomlaspanish.org\",\"authorUrl\":\"www.joomlaspanish.org\",\"version\":\"2.5.8\",\"description\":\"es-ES idioma administrador para Joomla 2.5\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('605', 'Español (España)', 'language', 'es-ES', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Espa\\u00f1ol (Espa\\u00f1a)\",\"type\":\"language\",\"creationDate\":\"2012-09-14\",\"author\":\"Joomla! Spanish\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters & joomlaspanish.org. All rights reserved.\",\"authorEmail\":\"joomlaspanish@joomlaspanish.org\",\"authorUrl\":\"www.joomlaspanish.org\",\"version\":\"2.5.8\",\"description\":\"es-ES Idiomas parte frontend Joomla 2.5 por www.joomlaspanish.org\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('700', 'files_joomla', 'file', 'joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2013 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.9\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('800', 'PKG_JOOMLA', 'package', 'pkg_joomla', '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PKG_JOOMLA\",\"type\":\"package\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PKG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10000', 'JA T3 Framework', 'plugin', 'jat3', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"JA T3 Framework\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"www.JoomlArt.com\",\"copyright\":\"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.joomlart.com\",\"version\":\"1.6.0\",\"description\":\"T3 Framework - JoomlArt Template Framework for Joomla 1.7\",\"group\":\"\"}', '{}', '', '', '619', '2013-03-03 09:28:23', '1000', '0'),
('10001', 'jm_corporate', 'template', 'jm_corporate', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"jm_corporate\",\"type\":\"template\",\"creationDate\":\"January, 24 2011\",\"author\":\"JM-Experts.com\",\"copyright\":\"Copyright (C), JM-Experts!. All Rights Reserved.\",\"authorEmail\":\"info@jm-experts.com\",\"authorUrl\":\"http:\\/\\/www.jm-experts.com\",\"version\":\"1.5\",\"description\":\"JM Corporate Template By JM-Experts!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10002', 'Akeeba Backup Notification Module', 'module', 'mod_akadmin', '', '1', '1', '2', '0', '{\"legacy\":true,\"name\":\"Akeeba Backup Notification Module\",\"type\":\"module\",\"creationDate\":\"2012-01-29\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2009-2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.3.13\",\"description\":\"\\n\\t<h1>Akeeba Backup Notification Module<\\/h1>\\n\\t<p>This is a handy  module to display a Akeeba icon on your administrator\\n\\tback-end\'s Control Panel page. The icon displays a warning site if the last\\n\\tbackup is failed, or if you haven\'t backed up your site for a period of time\\n\\t(user-defined). Clicking it brings you to the Akeeba Backup &quot;Backup Now&quot;\\n\\tpage.<\\/p>\\n\\t\",\"group\":\"\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10003', 'Akeeba Backup Lazy Scheduling', 'plugin', 'aklazy', 'system', '0', '1', '1', '0', '{\"legacy\":true,\"name\":\"Akeeba Backup Lazy Scheduling\",\"type\":\"plugin\",\"creationDate\":\"2011-04-17\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010-2012 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.3\",\"description\":\"\\n\\t\\tAutomate your Akeeba Backup installation without using CRON, taking\\n\\t\\tadvantage of your site\'s visitor activity. Important: Read the\\n\\t\\tdocumentation before proceeding. THIS PLUGIN IS NO LONGER SUPPORTED.\\n\\t\\tDO NOT REQUEST SUPPORT IF IT DOESN\'T WORK. READ THE DOCUMENTATION FOR\\n\\t\\tA LIST OF KNOWN ISSUES.\\n\\t\",\"group\":\"\"}', '{\"daysfreq\":\"1\",\"backuptime\":\"00:00\",\"profile\":\"1\",\"@spacer\":\"\",\"test\":\"0\",\"resetpw\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '6', '0'),
('10004', 'akeeba', 'component', 'com_akeeba', '', '1', '1', '0', '0', '{\"legacy\":true,\"name\":\"Akeeba\",\"type\":\"component\",\"creationDate\":\"2012-01-29\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.3.13\",\"description\":\"Akeeba Backup Core (formerly JoomlaPack) - Full Joomla! site backup solution, Core Edition. Making backup as simple as ABC!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10005', 'admintools', 'component', 'com_admintools', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Admintools\",\"type\":\"component\",\"creationDate\":\"2013-01-01\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.4\",\"description\":\"Security and utilitarian tools for Joomla! site administrators\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10006', 'Admin Tools Joomla! Upgrade Notification', 'module', 'mod_atjupgrade', '', '1', '1', '2', '0', '{\"legacy\":false,\"name\":\"Admin Tools Joomla! Upgrade Notification\",\"type\":\"module\",\"creationDate\":\"2012-12-23\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"rev709797C\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10007', 'System - Admin Tools', 'plugin', 'admintools', 'system', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"System - Admin Tools\",\"type\":\"plugin\",\"creationDate\":\"2013-01-01\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2010 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.4\",\"description\":\"\\n\\t\\tHandles all the system-wide features provided by Admin Tools Core\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '5', '0'),
('10008', 'lib_fof', 'library', 'lib_fof', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"lib_fof\",\"type\":\"library\",\"creationDate\":\"2012-12-24\",\"author\":\"Nicholas K. Dionysopoulos \\/ AkeebaBackup.com\",\"copyright\":\"(C)2011-2013 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"1.3.1\",\"description\":\"Framework-on-Framework (FOF) \\u2013 A rapid component development framework extension for Joomla!\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10009', 'AkeebaStrapper', 'file', 'files_strapper', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"AkeebaStrapper\",\"type\":\"file\",\"creationDate\":\"July 2012\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"(C) 2012 Akeeba Ltd.\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"1.0.0\",\"description\":\"Namespaced jQuery, jQuery UI and Bootstrap for Akeeba products.\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10010', 'CatalanCatal-ca_ES', 'language', 'ca-ES', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Catalan (Catal\\u00e0 - ca_ES)\",\"type\":\"language\",\"creationDate\":\"2012-12-15\",\"author\":\"Catalan translation team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"el.libre@gmail.com\",\"authorUrl\":\"www.catmidia.cat\",\"version\":\"2.5.8.1\",\"description\":\"Catalan language pack for Joomla! 2.5 - Site - Paquet d`idioma catal\\u00e0 per Joomla 2.5 - Lloc Web (FrontEnd) Fet per www.catmidia.cat\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10011', 'CatalanCatal-ca_ES', 'language', 'ca-ES', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Catalan (Catal\\u00e0 - ca_ES)\",\"type\":\"language\",\"creationDate\":\"2012-12-15\",\"author\":\"Catalan Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"el.libre@gmail.com\",\"authorUrl\":\"www.catmidia.cat\",\"version\":\"2.5.8.1\",\"description\":\"Catalan language pack for Joomla! 2.5 - Administration - Paquet d`idioma catal\\u00e0 per Joomla 2.5 - Administraci\\u00f3 (BackEnd) Fet per www.catmidia.cat\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10012', 'ca-ES', 'package', 'pkg_ca-ES', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Catalan Language Pack\",\"type\":\"package\",\"creationDate\":\"2012-12-15\",\"author\":\"Catalan Translation Team\",\"copyright\":\"\",\"authorEmail\":\"el.libre@gmail.com\",\"authorUrl\":\"http:\\/\\/www.catmidia.cat\",\"version\":\"2.5.8.1\",\"description\":\"Joomla 2.5.8 catalan language package\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10013', 'Frenchfr-FR', 'language', 'fr-FR', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"9 nov 2012\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2012 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.8.1\",\"description\":\"fr-FR site language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10014', 'Frenchfr-FR', 'language', 'fr-FR', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"9 nov 2012\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2012 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.8.1\",\"description\":\"fr-FR administrator language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10015', 'TinyMCE langue FR', 'file', 'TinyMCE_fr-FR', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"TinyMCE langue FR\",\"type\":\"file\",\"creationDate\":\"9 nov 2012\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"(C) 2005-2012 French Translation Team\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"3.5.4.1\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installation du pack de langue FR de TinyMCE 3.5.4.1 pour Joomla 2.5 effectu\\u00e9e avec succ\\u00e8s<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tN\'oubliez pas de s\\u00e9lectionner la langue FR dans la \\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestion du plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n \\t\\tSi vous utilisez la d\\u00e9tection automatique, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants \\n \\t\\t\\u00e0 ceux install\\u00e9s pour Joomla!<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10016', 'fr-FR', 'package', 'pkg_fr-FR', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"French Language Pack\",\"type\":\"package\",\"creationDate\":\"9 nov 2012\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2012 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"2.5.8.1\",\"description\":\"\\n\\t\\t\\n\\t\\t<h3>Joomla! Full French (fr-FR) Language Package version 2.5.8v1<\\/h3>\\n\\t\\t<h3>Paquet de langue fran\\u00e7ais complet Joomla! fr-FR version 2.5.8v1<\\/h3>\\n\\t\\t<div>Installation inclue du pack de langue fr-FR de TinyMCE 3.5.1 pour Joomla 2.5.8<\\/div><br><br>\\n\\t\\t<div style=\\\"font-weight: normal; padding-bottom:15px;\\\">N\'oubliez pas de s\\u00e9lectionner la langue FR dans les <a href=\\\"index.php?option=com_plugins&amp;view=plugins&amp;filter_search=TinyMCE\\\"><strong>param\\u00e8tres du plug-in \'\\u00c9diteur - TinyMCE\'<\\/strong><\\/a> (param\\u00e8tre  \'Langue de l\'\\u00e9diteur\' = fr).<br><br>\\n \\t\\tSi vous utilisez la <strong>d\\u00e9tection automatique<\\/strong>, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants aux packs de langue install\\u00e9s pour Joomla!<\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10017', 'GermanDE-CH-AT', 'language', 'de-DE', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"German (DE-CH-AT)\",\"type\":\"language\",\"creationDate\":\"19.11.2012\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.8.2\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Frontend (Website)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.8\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Frontend (Website) translation for Joomla! 2.5.8\\n    \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10018', 'TinyMCE de-DE', 'file', 'file_tinymce_de-DE', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"TinyMCE de-DE\",\"type\":\"file\",\"creationDate\":\"19.11.2012\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.8.2\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Editor (TinyMCE)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.8\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Editor (TinyMCE) translation for Joomla! 2.5.8\\n    \",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10019', 'GermanDE-CH-AT', 'language', 'de-DE', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"German (DE-CH-AT)\",\"type\":\"language\",\"creationDate\":\"19.11.2012\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2012 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.8.2\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Backend (Administrator)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.8\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Backend (Administrator) translation for Joomla! 2.5.8\\n    \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10020', 'de-DE', 'package', 'pkg_de-DE', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"German Language Pack\",\"type\":\"package\",\"creationDate\":\"19.11.2012\",\"author\":\"J!German\",\"copyright\":\"\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.8.2\",\"description\":\"\\n    <div style=\\\"text-align: center;\\\">\\n      <h2>Deutsches \\u201eFull\\u201c-Sprachpaket f\\u00fcr Joomla! 2.5.8 von <a title=\\\"J!German\\\" href=\\\"http:\\/\\/www.jgerman.de\\\" target=\\\"_blank\\\">J!German<\\/a><\\/h2>\\n      <h3><span style=\\\"color: #008000;\\\">\\u00dcbersetzungsversion: 2.5.8v2<\\/span><\\/h3>\\n      <hr \\/>\\n      <table rules=\\\"all\\\" frame=\\\"border\\\" style=\\\"width: 90%; border-color: #000000; border-width: 1px; border-style: solid;\\\" align=\\\"center\\\" border=\\\"1\\\">\\n      <colgroup> <col width=\\\"30%\\\" \\/> <col width=\\\"60\\\" \\/> <\\/colgroup>\\n      <tbody>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Frontend (Website)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n          <td rowspan=\\\"2\\\">\\n            <ul>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Neuinstallation:<\\/span>\\n                <br \\/>\\n                Legen Sie die deutsche Sprache unter <a title=\\\"Language Manager\\\" href=\\\"index.php?option=com_languages\\\" target=\\\"_blank\\\">\\u201eExtensions\\u201c \\u2192 \\u201eLanguage Manager\\u201c<\\/a> als Standardsprache (\\u201eDefault\\u201c), sowohl f\\u00fcr die Website (\\u201eInstalled - Site\\u201c) als auch f\\u00fcr die Administration (\\u201eInstalled - Administrator\\u201c), fest.\\n              <\\/li>\\n              <br \\/>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Aktualisierung:<\\/span>\\n                <br \\/>\\n                Es sind keine weiteren Schritte erforderlich.\\n              <\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Backend (Administrator)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n        <tr>\\n          <td>\\n            <ul>\\n              <li>Editor (TinyMCE)-\\u00dcbersetzung<\\/li>\\n            <\\/ul>\\n          <\\/td>\\n          <td>\\n            <ul>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Neuinstallation:<\\/span>\\n                <br \\/>\\n                Aktivieren Sie in den <a title=\\\"TinyMCE in der Pluginverwaltung\\\" href=\\\"index.php?option=com_plugins&amp;view=plugins&amp;filter_search=TinyMCE\\\" target=\\\"_blank\\\">TinyMCE-Plugineinstellungen<\\/a> die automatische Sprachauswahl auf \\u201eJa\\u201c (\\u201eBasisoptionen\\u201c \\u2192 \\u201eAutom. Sprachauswahl\\u201c).\\n              <\\/li>\\n              <br \\/>\\n              <li>\\n                <span style=\\\"text-decoration: underline;\\\">Aktualisierung (nur wenn vor dieser Installation ein <strong>seperates<\\/strong> TinyMCE-Sprachpaket installiert war):<\\/span>\\n                <br \\/>\\n                Deinstallieren Sie das alte TinyMCE-Sprachpaket \\u00fcber \\u201eErweiterungen\\u201c \\u2192 \\u201eErweiterungen\\u201c \\u2192 \\u201eVerwalten\\u201c \\u2192 \\u201eTinyMCE de-DE\\u201c. Danach installieren Sie dieses Paket erneut.<br \\/>Damit sorgen Sie daf\\u00fcr, dass der alte Aktualisierungsserver f\\u00fcr das einzelne TinyMCE-Sprachpaket aus Joomla! gel\\u00f6scht wird und so bei einer Aktualisierungsanfrage nicht unn\\u00f6tig gepr\\u00fcft wird.\\n              <\\/li>\\n            <\\/ul>\\n          <\\/td>\\n        <\\/tr>\\n      <\\/tbody>\\n      <\\/table>\\n      <br \\/>\\n      <span style=\\\"text-decoration: underline;\\\">Hinweis:<\\/span> Dieses Paket unterst\\u00fctzt die Joomla! eigene <a title=\\\"Joomla!-Aktualisierungsfunktion\\\" href=\\\"index.php?option=com_installer&amp;view=update\\\" target=\\\"_blank\\\">Aktualisierungsfunktion<\\/a>!\\n    <\\/div>\\n    \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10021', 'ItalianItaly', 'language', 'it-IT', '', '0', '1', '0', '0', '{\"legacy\":true,\"name\":\"Italian (Italy)\",\"type\":\"language\",\"creationDate\":\"2012-11-07\",\"author\":\"Italian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters and Joomla.it. All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.5.8.1\",\"description\":\"Italian site language pack for Joomla! 2.5\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10022', 'ItalianItaly', 'language', 'it-IT', '', '1', '1', '0', '0', '{\"legacy\":true,\"name\":\"Italian (Italy)\",\"type\":\"language\",\"creationDate\":\"2012-11-07\",\"author\":\"Italian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters and Joomla.it. All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.5.8.1\",\"description\":\"Italian administration language pack for Joomla! 2.5\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10023', 'TinyMCE lingua IT', 'file', 'TinyMCE_it-IT', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"TinyMCE lingua IT\",\"type\":\"file\",\"creationDate\":\"20 giugno 2012\",\"author\":\"Italian translation team : joomla.it\",\"copyright\":\"(C) 2005-2012 Italian Translation Team\",\"authorEmail\":\"info@joomla.it\",\"authorUrl\":\"www.joomla.it\",\"version\":\"3.5.2\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installazione del pacchetto lingua per TinyMCE 3.5.2 per  Joomla 2.5 effettuato correttamente<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tNon dimenticare di selezionare la lingua IT nella\\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestione del plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10024', 'it-IT', 'package', 'pkg_it-IT', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Italian Language Pack\",\"type\":\"package\",\"creationDate\":\"07 novembre 2012\",\"author\":\"Italian translation team : joomla.it\",\"copyright\":\"Copyright (C) 2005 - 2012 joomla.it e Open Source Matters. Tutti i diritti riservati\",\"authorEmail\":\"info@joomla.it\",\"authorUrl\":\"www.joomla.it\",\"version\":\"2.5.8.1\",\"description\":\"2.5.8 Joomla Full Italian Language Package\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10025', 'TraditionalChineseTaiwan', 'language', 'zh-TW', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Traditional Chinese(Taiwan)\",\"type\":\"language\",\"creationDate\":\"2012-10-01\",\"author\":\"Traditional Chinese translation team : Joomla! Taiwan\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters & Joomla! Taiwan All rights reserved.\",\"authorEmail\":\"joomlaorg@joomla.org.tw\",\"authorUrl\":\"www.joomla.org.tw\",\"version\":\"2.5.7.2\",\"description\":\"zh-TW site language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10026', 'TraditionalChineseTaiwan', 'language', 'zh-TW', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Traditional Chinese(Taiwan)\",\"type\":\"language\",\"creationDate\":\"2012-10-01\",\"author\":\"Traditional Chinese translation team : Joomla! Taiwan\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters & Joomla! Taiwan All rights reserved.\",\"authorEmail\":\"joomlaorg@joomla.org.tw\",\"authorUrl\":\"www.joomla.org.tw\",\"version\":\"2.5.7.2\",\"description\":\"zh-TW administrator language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10027', 'zh-TW', 'package', 'pkg_zh-TW', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Traditional Chinese Language Pack\",\"type\":\"package\",\"creationDate\":\"2012-10-01\",\"author\":\"Traditional Chinese translation team\",\"copyright\":\"Copyright (C) 2005 - 2012 Copyright (C) 2005 - 2012 Open Source Matters & Taiwan Joomla! Community All rights reserved.\",\"authorEmail\":\"eddy@joomla.org.tw\",\"authorUrl\":\"www.joomla.org.tw\",\"version\":\"2.5.7.2\",\"description\":\"\\n      \\n      <h3>Joomla! 2.5.7 \\u7e41\\u9ad4\\u4e2d\\u6587(zh-TW)\\u5b8c\\u6574\\u8a9e\\u8a00\\u5305\\uff0c\\u7248\\u672c2<\\/h3>\\n      <h3>Joomla! 2.5.7 Traditional Chinese (zh-TW) Language Package version 2<\\/h3>\\n      \\n   \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10028', 'PLG_SYSTEM_JFDATABASE', 'plugin', 'jfdatabase', 'system', '0', '1', '1', '0', '{\"legacy\":true,\"name\":\"PLG_SYSTEM_JFDATABASE\",\"type\":\"plugin\",\"creationDate\":\"2013-02-03\",\"author\":\"Joom!Fish Project\",\"copyright\":\"Copyright (C) 2003 - 2013, Think Network GmbH, Konstanz. All rights reserved.\",\"authorEmail\":\"support@joomfish.net\",\"authorUrl\":\"http:\\/\\/www.joomfish.net\",\"version\":\"2.5.1\",\"description\":\"PLG_SYSTEM_JFDATABASE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '2', '0'),
('10029', 'JOOMFISH_BASIC_ROUTER', 'plugin', 'jfrouter', 'system', '0', '1', '1', '0', '{\"legacy\":true,\"name\":\"JOOMFISH_BASIC_ROUTER\",\"type\":\"plugin\",\"creationDate\":\"2013-02-03\",\"author\":\"Joom!Fish Project\",\"copyright\":\"2003 - 2013, Think Network GmbH, Konstanz\",\"authorEmail\":\"support@joomfish.net\",\"authorUrl\":\"http:\\/\\/www.joomfish.net\",\"version\":\"2.5.1\",\"description\":\"WHEN_ACTIVATED_THIS_PLUGIN_PROVIDES_LANGUAGE_DETERMINATION_AND_BASIC_ROUTING\",\"group\":\"\"}', '{\"determitLanguage\":\"1\",\"newVisitorAction\":\"browser\",\"use302redirect\":\"0\",\"enableCookie\":\"1\",\"sefordomain\":\"sefprefix\",\"sefprefixes\":\"lang-\",\"sefsubdomain\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('10030', 'JOOMFISH_OVERRIDES', 'plugin', 'jfoverrides', 'system', '0', '1', '1', '0', '{\"legacy\":true,\"name\":\"JOOMFISH_OVERRIDES\",\"type\":\"plugin\",\"creationDate\":\"2013-02-03\",\"author\":\"Joom!Fish Project\",\"copyright\":\"2003 - 2013, Think Network GmbH, Konstanz\",\"authorEmail\":\"support@joomfish.net\",\"authorUrl\":\"http:\\/\\/www.joomfish.net\",\"version\":\"2.5.1\",\"description\":\"WHEN_ACTIVATED_THIS_PLUGIN_PROVIDES_NECESSARY_JOOMLA_OVERRIDES\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '3', '0'),
('10031', 'PLG_SYSTEM_JFINLINEMAPPING', 'plugin', 'jfinlinemapping', 'system', '0', '1', '1', '0', '{\"legacy\":true,\"name\":\"PLG_SYSTEM_JFINLINEMAPPING\",\"type\":\"plugin\",\"creationDate\":\"2013-02-03\",\"author\":\"Joom!Fish Project\",\"copyright\":\"Copyright (C) 2003 - 2013, Think Network GmbH, Konstanz. All rights reserved.\",\"authorEmail\":\"support@joomfish.net\",\"authorUrl\":\"http:\\/\\/www.joomfish.net\",\"version\":\"2.5.1\",\"description\":\"PLG_SYSTEM_JFINLINEMAPPING_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '4', '0'),
('10032', 'MOD_JFLANGUAGESELECTION', 'module', 'mod_jflanguageselection', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"MOD_JFLANGUAGESELECTION\",\"type\":\"module\",\"creationDate\":\"2013-02-03\",\"author\":\"Joom!Fish Project\",\"copyright\":\"Copyright (C) 2003 - 2013, Think Network GmbH, Konstanz. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.joomfish.net\",\"version\":\"2.5.1\",\"description\":\"MOD_JFLANGUAGESELECTION_XML_DESCRIPTION\",\"group\":\"\"}', '{\"type\":\"rawimages\",\"show_active\":\"1\",\"inc_jf_css\":\"1\",\"moduleclass_sfx\":\"\",\"@spacer\":\"\",\"cache_href\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10033', 'Joom!Fish Library', 'library', 'lib_joomfish', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Joom!Fish Library\",\"type\":\"library\",\"creationDate\":\"2013-02-03\",\"author\":\"Joom!Fish Project\",\"copyright\":\"2003 - 2013, Think Network GmbH, Konstanz\",\"authorEmail\":\"support@joomfish.net\",\"authorUrl\":\"http:\\/\\/www.joomfish.net\",\"version\":\"2.5.1\",\"description\":\" \\n    Base Joomfish classes\\n    \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10034', 'com_joomfish', 'component', 'com_joomfish', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"COM_JOOMFISH\",\"type\":\"component\",\"creationDate\":\"2013-02-03\",\"author\":\"Joom!Fish Project\",\"copyright\":\"2003 - 2013, Think Network GmbH, Konstanz\",\"authorEmail\":\"support@joomfish.net\",\"authorUrl\":\"http:\\/\\/www.joomfish.net\",\"version\":\"2.5.1\",\"description\":\"COM_JOOMFISH_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10039', 'PortugusBrasil', 'language', 'pt-BR', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Portugu\\u00eas(Brasil)\",\"type\":\"language\",\"creationDate\":\"2012-11-08\",\"author\":\"Joomla Brasil\",\"copyright\":\"Copyright 2005 - 2012 Open Source Matters. Todos os Direitos Reservados. Copyright Translation 2005 - 2012 Joomla Brasil. Todos os Direitos Reservados.\",\"authorEmail\":\"traducao@joomla.com.br\",\"authorUrl\":\"www.joomla.com.br\",\"version\":\"2.5.8.1\",\"description\":\"\\n\\t\\t\\t\\tArquivos de Idioma em Portugu\\u00eas Brasileiro para o CMS Joomla! 2.5<br\\/>\\n\\t\\t\\t\\tCopyright 2005 - 2012 Open Source Matters. Todos os Direitos Reservados. Copyright Translation 2005 - 2012 Joomla Brasil. Todos os Direitos Reservados.<br\\/>\\n\\t\\t\\t\\tDe acordo com termo de licenciamento de <a href=\\\"http:\\/\\/www.opensourcematters.org\\\" target=\\\"_blank\\\">OpenSourceMatters<\\/a> e <a href=\\\"http:\\/\\/www.joomla.org\\\" target=\\\"_blank\\\">Joomla!<\\/a> todos os arquivos de idioma devem ser licenciados sob a <a href=\\\"http:\\/\\/www.gnu.org\\/licenses\\/gpl-2.0.html\\\" target=\\\"_blank\\\"> licen\\u00e7a GNU\\/GPL (v.2.0)<\\/a>. Esta tradu\\u00e7\\u00e3o est\\u00e1 licenciada sob esta licen\\u00e7a. Se voc\\u00ea encontrar algum erro de digita\\u00e7\\u00e3o, tradu\\u00e7\\u00f5es incorretas ou se deseja sugerir melhorias, entre em contato com o <a href=\\\"mailto:traducao@joomla.com.br\\\">coordenador<\\/a> da tradu\\u00e7\\u00e3o ou junte-se a n\\u00f3s no <a href=\\\"https:\\/\\/github.com\\/joomlabrasil\\\" target=\\\"_blank\\\">github Joomla! Brasil<\\/a> e contribua diretamente com o projeto.<br\\/><br\\/>\\n\\t\\t\\t\\t\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10040', 'PortugusBrasil', 'language', 'pt-BR', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Portugu\\u00eas(Brasil)\",\"type\":\"language\",\"creationDate\":\"2012-11-08\",\"author\":\"Joomla Brasil\",\"copyright\":\"Copyright 2005 - 2012 Open Source Matters. Todos os Direitos Reservados. Copyright Translation 2005 - 2012 Joomla Brasil. Todos os Direitos Reservados.\",\"authorEmail\":\"traducao@joomla.com.br\",\"authorUrl\":\"www.joomla.com.br\",\"version\":\"2.5.8.1\",\"description\":\"\\n\\t\\t\\t\\tArquivos de Idioma em Portugu\\u00eas Brasileiro para o CMS Joomla! 2.5<br\\/>\\n\\t\\t\\t\\tCopyright 2005 - 2012 Open Source Matters. Todos os Direitos Reservados. Copyright Translation 2005 - 2012 Joomla Brasil. Todos os Direitos Reservados.<br\\/>\\n\\t\\t\\t\\tDe acordo com termo de licenciamento de <a href=\\\"http:\\/\\/www.opensourcematters.org\\\" target=\\\"_blank\\\">OpenSourceMatters<\\/a> e <a href=\\\"http:\\/\\/www.joomla.org\\\" target=\\\"_blank\\\">Joomla!<\\/a> todos os arquivos de idioma devem ser licenciados sob a <a href=\\\"http:\\/\\/www.gnu.org\\/licenses\\/gpl-2.0.html\\\" target=\\\"_blank\\\"> licen\\u00e7a GNU\\/GPL (v.2.0)<\\/a>. Esta tradu\\u00e7\\u00e3o est\\u00e1 licenciada sob esta licen\\u00e7a. Se voc\\u00ea encontrar algum erro de digita\\u00e7\\u00e3o, tradu\\u00e7\\u00f5es incorretas ou se deseja sugerir melhorias, entre em contato com o <a href=\\\"mailto:traducao@joomla.com.br\\\">coordenador<\\/a> da tradu\\u00e7\\u00e3o ou junte-se a n\\u00f3s no <a href=\\\"https:\\/\\/github.com\\/joomlabrasil\\\" target=\\\"_blank\\\">github Joomla! Brasil<\\/a> e contribua diretamente com o projeto.<br\\/><br\\/>\\n\\t\\t\\t\\t\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10041', 'pt-BR', 'package', 'pkg_pt-BR', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Pacote de Idiomas em Portugu\\u00eas Brasileiro\",\"type\":\"package\",\"creationDate\":\"Novembro 2012\",\"author\":\"Joomla Brasil\",\"copyright\":\"\",\"authorEmail\":\"traducao@joomla.com.br\",\"authorUrl\":\"www.joomla.com.br\",\"version\":\"2.5.8.1\",\"description\":\"\\n\\t\\t\\t\\tArquivos de Idioma em Portugu\\u00eas Brasileiro para o CMS Joomla! 2.5<br\\/>\\n\\t\\t\\t\\tCopyright 2005 - 2012 Open Source Matters. Todos os Direitos Reservados. Copyright Translation 2005 - 2012 Joomla Brasil. Todos os Direitos Reservados.<br\\/>\\n\\t\\t\\t\\tDe acordo com termo de licenciamento de <a href=\\\"http:\\/\\/www.opensourcematters.org\\\" target=\\\"_blank\\\">OpenSourceMatters<\\/a> e <a href=\\\"http:\\/\\/www.joomla.org\\\" target=\\\"_blank\\\">Joomla!<\\/a> todos os arquivos de idioma devem ser licenciados sob a <a href=\\\"http:\\/\\/www.gnu.org\\/licenses\\/gpl-2.0.html\\\" target=\\\"_blank\\\"> licen\\u00e7a GNU\\/GPL (v.2.0)<\\/a>. Esta tradu\\u00e7\\u00e3o est\\u00e1 licenciada sob esta licen\\u00e7a. Se voc\\u00ea encontrar algum erro de digita\\u00e7\\u00e3o, tradu\\u00e7\\u00f5es incorretas ou se deseja sugerir melhorias, entre em contato com o <a href=\\\"mailto:traducao@joomla.com.br\\\">coordenador<\\/a> da tradu\\u00e7\\u00e3o ou junte-se a n\\u00f3s no <a href=\\\"https:\\/\\/github.com\\/joomlabrasil\\\" target=\\\"_blank\\\">github Joomla! Brasil<\\/a> e contribua diretamente com o projeto.<br\\/><br\\/>\\n\\t\\t\\t\\t\\n\\t\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10042', 'GalicianGalego', 'language', 'gl-ES', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Galician (Galego)\",\"type\":\"language\",\"creationDate\":\"2012-11-21\",\"author\":\"Proxecto Trasno\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"proxecto@trasno.net\",\"authorUrl\":\"http:\\/\\/www.trasno.net\",\"version\":\"2.5.7.4\",\"description\":\"gl-ES site language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10043', 'GalicianGalego', 'language', 'gl-ES', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"Galician (Galego)\",\"type\":\"language\",\"creationDate\":\"2012-11-21\",\"author\":\"Proxecto Trasno\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"proxecto@trasno.net\",\"authorUrl\":\"http:\\/\\/www.trasno.net\",\"version\":\"2.5.7.4\",\"description\":\"gl-ES administrator language\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10044', 'gl-ES', 'package', 'pkg_gl-ES', '', '0', '1', '1', '0', '{\"legacy\":false,\"name\":\"Galician Language Pack (Galego)\",\"type\":\"package\",\"creationDate\":\"2012-11-21\",\"author\":\"Proxecto Trasno: trasno.net\",\"copyright\":\"Copyright (C) 2005 - 2012 trasno.nete Open Source Matters. Todos os dereitos reservados\",\"authorEmail\":\"damufo@gmail.com\",\"authorUrl\":\"trasno.net\",\"version\":\"2.5.7.4\",\"description\":\"\\n      \\n      <h3>Paquete de idioma galego completo para Joomla! version 2.5.7v4<\\/h3>\\n      <h3>Joomla! 2.5.7 Full Galician (gl-ES) Language Package version 4<\\/h3>\\n      <br>\\n      \\n   \",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10045', 'Fox Contact', 'module', 'mod_foxcontact', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Fox Contact\",\"type\":\"module\",\"creationDate\":\"Unknown\",\"author\":\"Demis Palma\",\"copyright\":\"Demis Palma\",\"authorEmail\":\"demis@fox.ra.it\",\"authorUrl\":\"http:\\/\\/www.fox.ra.it\\/\",\"version\":\"2.0.19\",\"description\":\"MOD_FOXCONTACT_DESCRIPTION\",\"group\":\"\"}', '{\"form_width\":\"100\",\"form_unit\":\"%\",\"customhtml0display\":\"1\",\"customhtml0order\":\"-1000\",\"customhtml1display\":\"1\",\"customhtml1order\":\"1000\",\"labelsdisplay\":\"0\",\"labelswidth\":\"230\",\"labelsunit\":\"px\",\"sender0display\":\"2\",\"sender0order\":\"5\",\"sender1display\":\"2\",\"sender1order\":\"10\",\"sender1isemail\":\"1\",\"senderwidth\":\"85\",\"senderunit\":\"%\",\"text0display\":\"1\",\"text0order\":\"15\",\"text1display\":\"0\",\"text1order\":\"20\",\"text2display\":\"0\",\"text2order\":\"25\",\"text3display\":\"0\",\"text3order\":\"30\",\"text4display\":\"0\",\"text4order\":\"35\",\"text5display\":\"0\",\"text5order\":\"40\",\"text6display\":\"0\",\"text6order\":\"45\",\"text7display\":\"0\",\"text7order\":\"50\",\"text8display\":\"0\",\"text8order\":\"55\",\"text9display\":\"0\",\"text9order\":\"60\",\"textwidth\":\"85\",\"textunit\":\"%\",\"dropdown0display\":\"1\",\"dropdown0order\":\"65\",\"dropdown1display\":\"0\",\"dropdown1order\":\"70\",\"dropdown2display\":\"0\",\"dropdown2order\":\"75\",\"dropdownwidth\":\"85\",\"dropdownunit\":\"%\",\"textarea0display\":\"1\",\"textarea0order\":\"80\",\"textarea1display\":\"0\",\"textarea1order\":\"85\",\"textarea2display\":\"0\",\"textarea2order\":\"90\",\"textareawidth\":\"85\",\"textareaheight\":\"180\",\"textareaunit\":\"%\",\"checkbox0display\":\"1\",\"checkbox0order\":\"95\",\"checkbox1display\":\"0\",\"checkbox1order\":\"100\",\"checkbox2display\":\"0\",\"checkbox2order\":\"105\",\"checkbox3display\":\"0\",\"checkbox3order\":\"110\",\"checkbox4display\":\"0\",\"checkbox4order\":\"115\",\"uploaddisplay\":\"0\",\"uploadmethod\":\"1\",\"uploadmax_file_size\":\"10000\",\"upload_filter\":\"1\",\"upload_audio\":\"0\",\"upload_video\":\"0\",\"upload_images\":\"1\",\"upload_documents\":\"1\",\"upload_archives\":\"1\",\"submittype\":\"0\",\"submiticon\":\"\",\"resetbutton\":\"0\",\"resettype\":\"0\",\"reseticon\":\"\",\"email_sent_action\":\"0\",\"email_sent_textdisplay\":\"1\",\"copy_to_submitter\":\"1\",\"email_copy_summary\":\"0\",\"spam_check\":\"1\",\"spam_detected_textdisplay\":\"1\",\"stdcaptchadisplay\":\"0\",\"stdcaptchatype\":\"0\",\"stdcaptcha_length\":\"5\",\"stdcaptchawidth\":\"150\",\"stdcaptchaheight\":\"75\",\"stdcaptchafont\":\"\",\"stdcaptchafontmin\":\"14\",\"stdcaptchafontmax\":\"20\",\"stdcaptchaangle\":\"20\",\"stdcaptcha_backgroundcolor\":\"#ffffff\",\"stdcaptcha_textcolor\":\"#191919\",\"stdcaptcha_disturbcolor\":\"#c8c8c8\",\"stylesheet\":\"neon.css\",\"acymailing\":\"0\",\"acymailing_checkboxes\":\"hidden|hidden\",\"acymailing_auto_checked\":\"0\",\"jnews\":\"0\",\"jnews_checkboxes\":\"hidden|hidden\",\"jnews_auto_checked\":\"0\",\"othernewsletters\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10046', 'com_foxcontact', 'component', 'com_foxcontact', '', '1', '1', '0', '0', '{\"legacy\":false,\"name\":\"COM_FOXCONTACT\",\"type\":\"component\",\"creationDate\":\"Unknown\",\"author\":\"Demis Palma\",\"copyright\":\"Demis Palma\",\"authorEmail\":\"demis@fox.ra.it\",\"authorUrl\":\"http:\\/\\/www.fox.ra.it\\/\",\"version\":\"2.0.19\",\"description\":\"COM_FOXCONTACT_DESCRIPTION\",\"group\":\"\"}', '{\"adminemailfrom\":{\"select\":\"admin\"},\"adminemailreplyto\":{\"select\":\"submitter\"},\"submitteremailfrom\":{\"select\":\"admin\"},\"submitteremailreplyto\":{\"select\":\"admin\"}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10047', 'com_jcomments', 'component', 'com_jcomments', '', '1', '1', '0', '0', '{\"legacy\":true,\"name\":\"JComments\",\"type\":\"component\",\"creationDate\":\"20\\/02\\/2012\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2012 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"2.3.0\",\"description\":\"JComments lets your users comment on content items.\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10048', 'plg_content_jcomments', 'plugin', 'jcomments', 'content', '0', '1', '1', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '7', '0'),
('10049', 'plg_search_jcomments', 'plugin', 'jcomments', 'search', '0', '0', '1', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '1', '0'),
('10050', 'plg_system_jcomments', 'plugin', 'jcomments', 'system', '0', '0', '1', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '19', '0'),
('10051', 'plg_editors-xtd_jcommentson', 'plugin', 'jcommentson', 'editors-xtd', '0', '1', '1', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '5', '0'),
('10052', 'plg_editors-xtd_jcommentsoff', 'plugin', 'jcommentsoff', 'editors-xtd', '0', '1', '1', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '5', '0'),
('10053', 'plg_user_jcomments', 'plugin', 'jcomments', 'user', '0', '0', '1', '0', '', '', '', '', '0', '0000-00-00 00:00:00', '3', '0'),
('10054', 'com_jaextmanager', 'component', 'com_jaextmanager', '', '1', '1', '1', '0', '{\"legacy\":false,\"name\":\"com_jaextmanager\",\"type\":\"component\",\"creationDate\":\"23 February 2013\",\"author\":\"JoomlArt\",\"copyright\":\"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.joomlart.com\",\"version\":\"2.5.5\",\"description\":\"JA Extension Manager Component\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'),
('10055', 'Simple Image Holder', 'module', 'mod_sih', '', '0', '1', '0', '0', '{\"legacy\":false,\"name\":\"Simple Image Holder\",\"type\":\"module\",\"creationDate\":\"17\\/8\\/2011\",\"author\":\"Omar Muhammad\",\"copyright\":\"Copyright \\u00a9 2007 - 2011 Omar\'s Site. All rights reserved.\",\"authorEmail\":\"admin@omar84.com\",\"authorUrl\":\"http:\\/\\/omar84.com\",\"version\":\"1.7.1\",\"description\":\"OMAR_DESC\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"file\":\"\",\"width\":\"\",\"height\":\"\",\"align\":\"center\",\"txt1\":\"\",\"txt2\":\"\",\"alt_txt\":\"\",\"link\":\"\",\"page\":\"\",\"opacity\":\"\",\"opacity2\":\"\",\"img_id\":\"\",\"name\":\"\",\"quality\":\"high\",\"loop\":\"Yes\",\"wmode\":\"window\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0');/**ABDB**/
/**ABDB**/CREATE TABLE `xqd62_dbcache` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `groupname` varchar(32) NOT NULL DEFAULT '',
  `expire` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `value` mediumblob NOT NULL,
  PRIMARY KEY (`id`,`groupname`),
  KEY `expire` (`expire`,`groupname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_content_rating` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `rating_sum` int(10) unsigned NOT NULL DEFAULT 0,
  `rating_count` int(10) unsigned NOT NULL DEFAULT 0,
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_content_frontpage`  VALUES 
('1', '1'),
('2', '0');
/**ABDB**/CREATE TABLE `xqd62_contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `imagepos` varchar(20) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Establecer si el artículo aparece.',
  `xreference` varchar(50) NOT NULL COMMENT 'Una referencia para los vínculos a datos externos conjuntos.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT 0,
  `impmade` int(11) NOT NULL DEFAULT 0,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_associations` (
  `id` varchar(50) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Anidadas al conjunto padre.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Anidadas conjunto lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Anidadas conjunto rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'Nivel de la caché en el árbol anidado.',
  `name` varchar(50) NOT NULL COMMENT 'Nombre único para el activo.\n',
  `title` varchar(100) NOT NULL COMMENT 'Título descriptivo para el activo.',
  `rules` varchar(5120) NOT NULL COMMENT 'Control de acceso codificado de JSON.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_assets`  VALUES 
('1', '0', '1', '87', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('8', '1', '17', '26', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
('9', '1', '27', '28', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '29', '30', '1', 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
('11', '1', '31', '32', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('12', '1', '33', '34', '1', 'com_login', 'com_login', '{}'),
('13', '1', '35', '36', '1', 'com_mailto', 'com_mailto', '{}'),
('14', '1', '37', '38', '1', 'com_massmail', 'com_massmail', '{}'),
('15', '1', '39', '40', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '41', '42', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('17', '1', '43', '44', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '45', '46', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('19', '1', '47', '50', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('20', '1', '51', '52', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('21', '1', '53', '54', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'),
('22', '1', '55', '56', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('23', '1', '57', '58', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('24', '1', '59', '62', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('25', '1', '63', '66', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
('26', '1', '67', '68', '1', 'com_wrapper', 'com_wrapper', '{}'),
('27', '8', '18', '19', '2', 'com_content.category.2', 'Sin categoría', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Sin categoría', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Sin categoría', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('30', '19', '48', '49', '2', 'com_newsfeeds.category.5', 'Sin categoría', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('31', '25', '64', '65', '2', 'com_weblinks.category.6', 'Sin categoría', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('32', '24', '60', '61', '1', 'com_users.notes.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('33', '1', '69', '70', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('34', '1', '71', '72', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'),
('35', '1', '73', '74', '1', 'com_akeeba', 'akeeba', '{}'),
('36', '1', '75', '76', '1', 'com_admintools', 'admintools', '{}'),
('37', '1', '77', '78', '1', 'com_joomfish', 'com_joomfish', '{}'),
('39', '8', '20', '25', '2', 'com_content.category.8', 'Samaná', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('41', '39', '21', '22', '3', 'com_content.article.1', 'Pueblo de Samaná', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('42', '39', '23', '24', '3', 'com_content.article.2', 'Pueblo de Samaná (2)', ''),
('43', '1', '83', '84', '1', 'com_foxcontact', 'com_foxcontact', '{}'),
('44', '1', '85', '86', '1', 'com_jcomments', 'jcomments', '{}');
/**ABDB**/CREATE TABLE `xqd62_ak_storage` (
  `tag` varchar(255) NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_ak_stats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `comment` longtext DEFAULT NULL,
  `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',
  `origin` varchar(30) NOT NULL DEFAULT 'backend',
  `type` varchar(30) NOT NULL DEFAULT 'full',
  `profile_id` bigint(20) NOT NULL DEFAULT 1,
  `archivename` longtext DEFAULT NULL,
  `absolute_path` longtext DEFAULT NULL,
  `multipart` int(11) NOT NULL DEFAULT 0,
  `tag` varchar(255) DEFAULT NULL,
  `filesexist` tinyint(3) NOT NULL DEFAULT 1,
  `remote_filename` varchar(1000) DEFAULT NULL,
  `total_size` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_ak_stats`  VALUES 
('1', 'Backup taken on Domingo, 03 Marzo 2013 00:36', '', '2013-03-03 00:36:47', '2013-03-03 00:39:08', 'complete', 'lazy', 'full', '1', 'site-samanard.es-20130303-003647.jpa', '/var/www/vhosts/samanard.es/httpdocs/administrator/components/com_akeeba/backup/site-samanard.es-20130303-003647.jpa', '0', 'lazy', '1', NULL, '14048406');
/**ABDB**/CREATE TABLE `xqd62_ak_profiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `configuration` longtext DEFAULT NULL,
  `filters` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_ak_profiles`  VALUES 
('1', 'Default Backup Profile', '[global]\n[akeeba]\nquota.remote=\"0\"\nquota.maxage.enable=\"0\"\nquota.obsolete_quota=\"50\"\nquota.enable_size_quota=\"0\"\nquota.size_quota=\"15728640\"\nquota.enable_count_quota=\"1\"\nquota.count_quota=\"3\"\nadvanced.dump_engine=\"native\"\nadvanced.scan_engine=\"smart\"\nadvanced.archiver_engine=\"jpa\"\nadvanced.proc_engine=\"none\"\nadvanced.embedded_installer=\"abi\"\nbasic.output_directory=\"/var/www/vhosts/samanard.es/httpdocs/administrator/components/com_akeeba/backup\"\nbasic.log_level=\"4\"\nbasic.archive_name=\"site-[HOST]-[DATE]-[TIME]\"\nbasic.backup_type=\"full\"\nbasic.useiframe=\"0\"\ncore.usedbstorage=\"0\"\ntuning.min_exec_time=\"2000\"\ntuning.max_exec_time=\"14\"\ntuning.run_time_bias=\"75\"\ntuning.nobreak.beforelargefile=\"0\"\ntuning.nobreak.afterlargefile=\"0\"\ntuning.nobreak.proactive=\"0\"\ntuning.nobreak.domains=\"0\"\ntuning.nobreak.finalization=\"0\"\ntuning.settimelimit=\"0\"\n[engine]\narchiver.common.dereference_symlinks=\"0\"\narchiver.common.part_size=\"0\"\narchiver.common.chunk_size=\"1048576\"\narchiver.common.big_file_threshold=\"1048576\"\narchiver.zip.cd_glue_chunk_size=\"1048576\"\ndump.common.mysql_compatibility=\"0\"\ndump.common.extended_inserts=\"1\"\ndump.common.packet_size=\"131072\"\ndump.common.splitsize=\"524288\"\ndump.common.batchsize=\"1000\"\ndump.native.advanced_entitites=\"0\"\ndump.native.nodependencies=\"0\"\ndump.native.nobtree=\"1\"\nscan.smart.large_dir_threshold=\"100\"\nscan.smart.scan_method=\"opendir\"\n[core]\nfilters.dateconditional.enabled=\"0\"\nfilters.dateconditional.start=\"1981-02-20 12:15 GMT+2\"\n', '');
/**ABDB**/CREATE TABLE `xqd62_ak_acl` (
  `user_id` bigint(20) unsigned NOT NULL,
  `permissions` mediumtext DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_wafexceptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option` varchar(255) DEFAULT NULL,
  `view` varchar(255) DEFAULT NULL,
  `query` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_storage` (
  `key` varchar(255) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_admintools_storage`  VALUES 
('cparams', '{\"latestjversion\":\"{\\\"installed\\\":{\\\"version\\\":\\\"\\\",\\\"package\\\":\\\"\\\"},\\\"current\\\":{\\\"version\\\":\\\"\\\",\\\"package\\\":\\\"\\\"},\\\"sts\\\":{\\\"version\\\":\\\"\\\",\\\"package\\\":\\\"\\\"},\\\"lts\\\":{\\\"version\\\":\\\"\\\",\\\"package\\\":\\\"\\\"}}\",\"lastjupdatecheck\":1362236132}');
/**ABDB**/CREATE TABLE `xqd62_admintools_scans` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `comment` longtext DEFAULT NULL,
  `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',
  `origin` varchar(30) NOT NULL DEFAULT 'backend',
  `type` varchar(30) NOT NULL DEFAULT 'full',
  `profile_id` bigint(20) NOT NULL DEFAULT 1,
  `archivename` longtext DEFAULT NULL,
  `absolute_path` longtext DEFAULT NULL,
  `multipart` int(11) NOT NULL DEFAULT 0,
  `tag` varchar(255) DEFAULT NULL,
  `filesexist` tinyint(3) NOT NULL DEFAULT 1,
  `remote_filename` varchar(1000) DEFAULT NULL,
  `total_size` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_scanalerts` (
  `admintools_scanalert_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(2048) NOT NULL,
  `scan_id` bigint(20) NOT NULL DEFAULT 0,
  `diff` mediumtext DEFAULT NULL,
  `threat_score` int(11) NOT NULL DEFAULT 0,
  `acknowledged` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`admintools_scanalert_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_redirects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `source` varchar(255) DEFAULT NULL,
  `dest` varchar(255) DEFAULT NULL,
  `ordering` bigint(20) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_profiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `configuration` longtext DEFAULT NULL,
  `filters` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `xqd62_admintools_profiles`  VALUES 
('1', 'Default PHP Change Scanner Profile', '', '');
/**ABDB**/CREATE TABLE `xqd62_admintools_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `logdate` datetime NOT NULL,
  `ip` varchar(40) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `reason` varchar(255) DEFAULT 'other',
  `extradata` mediumtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_ipblock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_ipautoban` (
  `ip` varchar(255) NOT NULL,
  `reason` varchar(255) DEFAULT 'other',
  `until` datetime DEFAULT NULL,
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_filescache` (
  `admintools_filescache_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(2048) NOT NULL,
  `filedate` int(11) NOT NULL DEFAULT 0,
  `filesize` int(11) NOT NULL DEFAULT 0,
  `data` blob DEFAULT NULL,
  `checksum` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`admintools_filescache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_customperms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `perms` varchar(4) DEFAULT '0644',
  UNIQUE KEY `id` (`id`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_badwords` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(255) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_adminiplist` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `xqd62_admintools_acl` (
  `user_id` bigint(20) unsigned NOT NULL,
  `permissions` mediumtext DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `#__weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT 0,
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `hits` int(11) NOT NULL DEFAULT 0,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if link is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `images` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '1', '[6,2,8]'),
('3', 'Special', '2', '[6,3,8]'),
('5', 'Guest', '0', '[9]'),
('6', 'Super Users', '0', '[8]');
/**ABDB**/CREATE TABLE `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__utf8_conversion`  VALUES 
('5');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` mediumtext NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) NOT NULL DEFAULT '' COMMENT 'Name of used authentication plugin',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_block` (`block`),
  KEY `email` (`email`),
  KEY `idx_name` (`name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=5165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('600', 'Super User', 'jesusarb', 'jesus181078@hotmail.com', '$2y$10$9SU1AMl25wLDgdnN0m7fAuAJOmtkeObSkdVQqP5T5QDVgvj8IDeq2', '0', '1', '2016-07-04 14:33:11', '2018-10-16 17:42:56', '0', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4243', 'Jesus Reynoso', 'jesus.a.r.b', 'reynosobourdier@hotmail.com', '$2y$10$y3aZlc8qu6O7trwQ7qlfKudb7PhmrP1i12.qj5KYZucra7COmUH/G', '0', '1', '2018-10-16 17:49:38', '2023-11-13 20:59:33', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4244', 'Susana Darvall', 'susanan76313', 'SusanaDarvall@price.baburn.com', '$2y$10$et.Ob8BDiFEfKLDmbsMcKunql0uFHAGj5LJTibAwf8JhEbgIHWQfi', '1', '0', '2018-10-17 05:18:47', '0000-00-00 00:00:00', '1d41dbf0bf67c40e338b1431d38e0b49', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4245', 'Jamison Everson', 'jamison75o48', 'JamisonEverson60@price.wirelax.com', '$2y$10$ZXWy7nVE9N92n/G9FgqfXurJzEVnXtnrvfCEmGpjWQaSv9HibIURG', '0', '0', '2018-10-17 05:27:55', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4246', 'AstaffeOiXW', 'AstaffeOi', 'stephenbib@mail.ru', '$2y$10$kwob2OFgwQH3SLXF7LL/TedIKlFMpOlc8NS4N/p4vN6BFQZe/1xUi', '1', '0', '2018-10-18 13:18:58', '0000-00-00 00:00:00', '6f741b0e891afeea08ab130cba4a2afc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4247', 'CecilwapGK', 'Cecilwap', 'yourmail@gmail.com', '$2y$10$PPMh9h/v8UT1p.zB03OJGOE5ziOHp9Yq/ChRcfWUBc.g8SvzZvSoO', '1', '0', '2018-10-20 06:59:17', '0000-00-00 00:00:00', 'e484a1d2a5f547d0ab4c902e2c9bb596', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4248', 'SuzanneexaleUQ', 'Suzanneexale', 'pyotrorekhov1999356fua@rambler.ru', '$2y$10$Ziv2wK/UNwDG93.HbnJOsOwSCa.pRj0h1463ar5R7U3mRex9PeTMe', '0', '0', '2018-10-20 20:43:19', '2018-10-20 20:46:44', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4249', 'RobertDibIR', 'RobertDib', 'skyecox13@gmail.com', '$2y$10$IWzeAUkppv9W5ORL9LMyRum3kgeiV8sAn4RNQwB5LyhYMgjYaBZUu', '0', '0', '2018-10-21 00:05:07', '2018-10-21 00:15:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4250', 'BerniceSlentUR', 'BerniceSlent', 'zen291@taidar.ru', '$2y$10$ba8o3ziiQLIDOnGc/P711.larHXX5.rvY6wVahxzuf9iq1hOgCz5G', '0', '0', '2018-10-21 07:11:33', '2018-10-21 08:24:14', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4251', 'JimEvornSM', 'JimEvorn', 'thomas.legirso@gmail.com', '$2y$10$D8R/cpykodXXxhFpMkL7.O4Lzw3bcBjoVp0gqx2lIUJyLJzZojEju', '0', '0', '2018-10-22 06:53:14', '2018-10-25 13:17:21', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4252', 'MariacloksZI', 'Mariacloks', 'stepanshashkov1993559ra5w@rambler.ru', '$2y$10$YDXPPP4Z.EWBR.ma6fQD5.7y/ubs8c26Q0BF7DfepzjX6v0lTSiI2', '1', '0', '2018-10-23 15:07:56', '0000-00-00 00:00:00', 'd030ec254304458cc584cd96e25d5617', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4253', 'SkaclelayVU', 'Skaclelay', 'daurscre21@dtdns.us', '$2y$10$w.4guqE3m/2gRZ2iKiWOmOLmV7SmbricqIKbu4TrUKU1vVJVmBsDO', '0', '0', '2018-10-23 17:47:30', '2018-12-18 17:03:47', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4254', 'MildredWoundIB', 'MildredWound', 'ivkurher@mail.ru', '$2y$10$OXMcaSX45o3Y32hMs.OEr.FCAEbPwmwUCcAL.QMhI.AxEnBi6u7vm', '0', '0', '2018-10-23 20:28:05', '2018-10-31 04:17:08', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4255', 'MelodyAwameJH', 'MelodyAwame', 'zen292@taidar.ru', '$2y$10$pavmSzZRrgWsb3Bffc6H/Ohyx/jf4c4dESQ2zDPDYqtTU4jDdtGOq', '0', '0', '2018-10-26 13:04:42', '2018-10-26 14:16:31', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4256', 'JoeyFalTW', 'Joeyrads', 'dorkina.nyusha@mail.ru', '$2y$10$xYDw0s.kWhDf4b0BgEzqaum15Va1pglCm.7ypWWAfYwZHUkwpQD9C', '1', '0', '2018-10-26 22:31:57', '0000-00-00 00:00:00', '1d2fd3156a8dc442c928b3988e45c316', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4257', 'JamesHeaskHW', 'Jamesornab', 'eawqv7r4@gmail.com', '$2y$10$nC593EQwYCgP6tE8DAyMQe0USy3V0G25Hq3slHY3vjCYYsqi6Bzzq', '1', '0', '2018-10-26 22:49:08', '0000-00-00 00:00:00', '621fcd66e5cd041f1922ab155740cddf', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4258', 'Mine-BossDrarJZ', 'Mine-BossSl', 'tashes-m@mail.ru', '$2y$10$LOvgJoNgWrZeD.YUF51eR.7RpjWBibYJQsPqUNpQlB0KXbUamY9um', '0', '0', '2018-10-26 22:52:13', '2018-10-26 23:00:29', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4259', 'InnostiannobZR', 'Innostianwina', 'gorvicz.ilona@mail.ru', '$2y$10$VgGRN7AjIef/5vu.1H43huOPYKXOa7OyyFhjt.hMDmXdVQ1Xh0rNG', '1', '0', '2018-10-26 22:58:33', '0000-00-00 00:00:00', 'e12a8934a93a823565af47076b5415db', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4260', 'MerdarioneiTI', 'Merdarionpt', 'liya.slenokurova.1977@mail.ru', '$2y$10$KS8EU033lVOprvFsLEvVBerl64AmhIsMH1eJ8UyHwl9Gxp6cyaRfq', '1', '0', '2018-10-26 23:02:18', '0000-00-00 00:00:00', 'ba04fb412f399a6805168751f21fbf82', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4261', 'JamesHeaskHW', 'JamesMub', 'foaxx5t4@gmail.com', '$2y$10$ZDUEHf4qKZlpqG5iNovW/ey3KJ0f6HImaWqFhO74jbfQejoJ1Ovze', '1', '0', '2018-10-26 23:03:23', '0000-00-00 00:00:00', 'c88d790beba1d9713c66956e73aa2153', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4262', 'GlennBiareMB', 'Glenninedy', 'zyymm1u8@gmail.com', '$2y$10$qGL9AHhXEZPPql27ahz9W.xA0YinHTsv6s4mYIDvn6hA0HaCw0GeC', '1', '0', '2018-10-26 23:03:24', '0000-00-00 00:00:00', '125f56ea876cdacd1ca8976ad30c7886', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4263', 'GordonPalCG', 'Gordonmubre', 'knhlq5z6@gmail.com', '$2y$10$HQaCVDDHG5HQzuRYXAEDDuAH6GqERyQk9vGS57TcKZ5ATOZPLIOQC', '1', '0', '2018-10-27 00:44:25', '0000-00-00 00:00:00', '62ba3e1e44b82da71bfc1927b09e174e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4264', 'StevenTarNE', 'StevenShief', 'kbfmb1d0@gmail.com', '$2y$10$krMOYNtDhdVKzdAHW3Gf4.zTXDFzw5v.SoFloYpkWS/Fd5xNe74ka', '1', '0', '2018-10-27 00:44:25', '0000-00-00 00:00:00', '47d85076a47f57482b225c8a67dc794f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4265', 'GordonPalCG', 'Gordonamivy', 'hitbo4j0@gmail.com', '$2y$10$9f59hRXwhRWQonCs6aDrVuiLWnzrHgcfspiqqGzTRcyrLW/xaeygS', '1', '0', '2018-10-27 02:18:12', '0000-00-00 00:00:00', '116ab74ff703004b39442d9532389a77', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4266', 'StevenTarNE', 'Stevenvoick', 'pmtxh0o3@gmail.com', '$2y$10$eY2u5xbkMUiq/PU8TZTJa.3wuYPfAeAIi9tZV/W/P9Daib.UZYGIa', '1', '0', '2018-10-27 02:18:16', '0000-00-00 00:00:00', '496ee26e95ff727e16b75711a1a238a9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4267', 'GordonPalCG', 'GordonKnili', 'xcyyz9z0@gmail.com', '$2y$10$h0bGfFemMCN11c2P6w9QteDZIVQePKWyxunuIJV/UVtc39bs5BoPK', '1', '0', '2018-10-27 02:18:43', '0000-00-00 00:00:00', '17fdedbb7be730d5a0e9094761bb78a8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4268', 'StevenTarNE', 'Stevenwew', 'bcgjq0n9@gmail.com', '$2y$10$29I7fVhbLp58sOn2IhjWdOcFl.qgOzsOflN1lVqEtQWp3sdVhg1XO', '1', '0', '2018-10-27 02:18:43', '0000-00-00 00:00:00', '94791943b9844a877d23ab181838d168', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4269', 'StevenTarNE', 'StevenTig', 'vbqus9j4@gmail.com', '$2y$10$upUh7YB.fiZY9YUCFUaUBu5s1FH4wfSeEzXhBZh/WgTDHZ6o7BIbC', '1', '0', '2018-10-27 03:12:33', '0000-00-00 00:00:00', '249c1baee2a576261440766b8fef3b06', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4270', 'GordonPalCG', 'Gordonabsok', 'ovsfr8r7@gmail.com', '$2y$10$ipEOgrbDMLUOPxwxkvIuiOWukIjqMJ.to8ObCLMTNSH9qr5dUhATK', '1', '0', '2018-10-27 03:12:34', '0000-00-00 00:00:00', '831b6d7602e4ac84cf6cc1b41b7a876f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4271', 'GordonPalCG', 'GordonSow', 'azadt5t0@gmail.com', '$2y$10$cIvfco6TMkTbK4w6W4ephOSCF5rk51k99iBwwMdN76JESTBd/E5yq', '1', '0', '2018-10-27 03:33:59', '0000-00-00 00:00:00', 'cb8d5855fa18681c3674f593712c01ff', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4272', 'StevenTarNE', 'StevenWeamn', 'kqjdf8x4@gmail.com', '$2y$10$.dK.k7jvRBBXuC1yzY0ERueQpG.g77ycOwu/1tyHbIqP6Mc0U1/xq', '1', '0', '2018-10-27 03:33:59', '0000-00-00 00:00:00', '73879e8925243f53d6b335fde4057385', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4273', 'GordonPalCG', 'GordonPunty', 'cjxpq5z5@gmail.com', '$2y$10$AjvbkCuSw/OGsQHVrhOoIecPxN1PHP9F77.UWnHpdW30Fqq5x3XV6', '1', '0', '2018-10-27 04:14:43', '0000-00-00 00:00:00', 'cbacb668976e0c47dbb0564e4f65b37c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4274', 'AnogKlNI', 'AnogWax', 'gordenkova.92@mail.ru', '$2y$10$jxdsQpQFr..94I0K4dQ0UOwdFRhUfbhp8wLNwWokuDVRjS44UuJeu', '1', '0', '2018-10-27 05:40:32', '0000-00-00 00:00:00', 'e39c110133e760372e441581f3255e24', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4275', 'GordonPalCG', 'Gordonpielt', 'gvtoz9o3@gmail.com', '$2y$10$6gF9utxeA1pTMM2byqANiuX2hB.sf6cjTie385Agx2GFx6YDYGnMy', '1', '0', '2018-10-27 06:00:20', '0000-00-00 00:00:00', 'a0ecf38634bd6ecb3c0b1d0136490435', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4276', 'StevenTarNE', 'StevenKaf', 'dlzqg9v4@gmail.com', '$2y$10$T7euNqpyVZWWpbsYj9D48uUA1Y4zKJvuNvjtbRIev8K5Tm99k.x0y', '1', '0', '2018-10-27 06:00:21', '0000-00-00 00:00:00', '45edfa9b59b5c3eccb791d9d6138b43a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4277', 'GlennBiareMB', 'Glennememy', 'ymnum9r5@gmail.com', '$2y$10$SZf/590u8sjyJprf8qhj8O0AMS3PRTiCG1Hc1JiB14tf90Bd4OSz6', '1', '0', '2018-10-27 07:46:43', '0000-00-00 00:00:00', '92bb7c0ed9f8b076c6a585451ae3f891', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4278', 'JamesHeaskHW', 'Jamesurilk', 'bebyu4i3@gmail.com', '$2y$10$Hahc3ZaPjlvChxzW1U1tgO9w1FE5l2ezVgFlafzeoQ3bzh811zPwG', '1', '0', '2018-10-27 07:46:54', '0000-00-00 00:00:00', 'dd253f71721f2c79f890a4f4b552120e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4279', 'GordonPalCG', 'Gordonbew', 'pbqkx3h5@gmail.com', '$2y$10$xyieLWxoe.LTaZxV5YRQaOQS0jQQWawwGndaH9HlaCy9iY5uMPniq', '1', '0', '2018-10-27 08:54:42', '0000-00-00 00:00:00', '892d119f47bc07f934df55de191dd399', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4280', 'StevenTarNE', 'StevenJoxia', 'ipivf1o5@gmail.com', '$2y$10$HXwZuJX2Q2cRSSP3K51QZe0GiithSFSnoRhge/z/mT7ZVOAcFoXH6', '1', '0', '2018-10-27 08:54:42', '0000-00-00 00:00:00', 'a442805408f7385cde04d52dd48bc787', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4281', 'StevenTarNE', 'StevenNus', 'ydpbv5s8@gmail.com', '$2y$10$CgsO7sXkM719VyhvTSh0a.dHmkNjgRm2ceMWvMSmlC/GH1zVCa3uG', '1', '0', '2018-10-27 09:05:50', '0000-00-00 00:00:00', 'cc88304482711b9e9b768235b991ed87', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4282', 'GordonPalCG', 'GordonMet', 'bakcm1j7@gmail.com', '$2y$10$Sb3tqJvQaciEiH.V/PwH2OHKckLEMoRYz/Cir/ClpdwnXlTwfxFIm', '1', '0', '2018-10-27 09:05:51', '0000-00-00 00:00:00', '639758cb947ee61559439d1213567fbc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4283', 'GordonPalCG', 'GordonNom', 'nndcn8c4@gmail.com', '$2y$10$rGOm3BlWZXJnVyV7cd9O2u6sfZhVst6L5M6JDNCoMk4dHGsZol8TK', '1', '0', '2018-10-27 09:21:04', '0000-00-00 00:00:00', '684ce92135710850f3c604047a8eae10', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4284', 'StevenTarNE', 'StevenKal', 'lloik1e2@gmail.com', '$2y$10$8/VnndT.ZuZU8nASkmYfQelQ7ZUocZpxi2BUOJgl5DmHoYe1CsFCW', '1', '0', '2018-10-27 09:21:05', '0000-00-00 00:00:00', '832207a13c677c67968e4319645e9c58', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4285', 'GlennBiareMB', 'GlennHoada', 'affiz7v3@gmail.com', '$2y$10$G8HxlraV.Oj4/iJRsITZK.IuaPI6kG.eveOFPvL0qmOY0UA6IBf7u', '1', '0', '2018-10-27 11:22:40', '0000-00-00 00:00:00', '0df784a5ab8fe779342bb46ed3835572', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4286', 'UrkrasseaBP', 'UrkrassHoum', 'kolovanova_2019@mail.ru', '$2y$10$kDNjNpVR80tZZVbaw77..ugWTUxVrSJBv1xLHeBBWaG2oUZJIp1pm', '1', '0', '2018-10-27 11:55:59', '0000-00-00 00:00:00', 'e688cb912f1e0db8f5873d712ea37982', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4287', 'StevenTarNE', 'Stevengehef', 'fvitm7f0@gmail.com', '$2y$10$6y9sbvl6y.qpfoEfHdPRBuKlr53jF4.rHAT1UfRYRyzrvZSaaa4xG', '1', '0', '2018-10-27 12:05:48', '0000-00-00 00:00:00', '82337aef224c1a95e06a93d82c026e5c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4288', 'GordonPalCG', 'Gordongap', 'ezvtd2u5@gmail.com', '$2y$10$JoLv5yEBwZGyXnTjsigqAOzvby/52YSCH06F.Q9vCSYNS3E77HIzO', '1', '0', '2018-10-27 12:05:49', '0000-00-00 00:00:00', '78b1ca063cc8abaa3cad4b720ebd39c6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4289', 'StevenTarNE', 'StevenInolf', 'mpzto7e7@gmail.com', '$2y$10$oiNFqBWGJwiW7O5XQoLVrOrm4hUmAYyPOSmwN9tttaYiesxGk6Mym', '1', '0', '2018-10-27 14:42:40', '0000-00-00 00:00:00', '91c5a781f0ffa2ff91f56166f646cc08', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4290', 'GordonPalCG', 'GordonApoge', 'soady8q5@gmail.com', '$2y$10$62ZsEIoX7HiRYZOS8F3K2.G0NdO6LwX.pQ40SFf8pIZasvk6VZFfK', '1', '0', '2018-10-27 14:42:42', '0000-00-00 00:00:00', '38e1e743c7956b93af9bee1df5e196ac', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4291', 'GordonPalCG', 'GordonAlefe', 'drmhp4k6@gmail.com', '$2y$10$gXjvuDxGGI1f6qls3.iMrexk4aOPzqQ8/s6xxoO8955Z4odd0z6Qi', '1', '0', '2018-10-27 16:58:09', '0000-00-00 00:00:00', 'b093aecaa321c866253cf928a348dddc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4292', 'StevenTarNE', 'StevenGlist', 'tuatl9z3@gmail.com', '$2y$10$gEHVLSvihk3Nb7Ojw4qSpebZnqPHB8rHU/JMZdQVumoWYEQGCcnua', '1', '0', '2018-10-27 16:58:10', '0000-00-00 00:00:00', 'e9a71295e91ebe1fe08c5bf31ab6872b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4293', 'GlennBiareMB', 'GlennSpeew', 'uwynz3v5@gmail.com', '$2y$10$sXF4km3oR2uKZQBC2mKT/OWA/9lZfcD9LfJI.co5x.g9SX4qHooKi', '1', '0', '2018-10-27 17:34:15', '0000-00-00 00:00:00', 'f90ff4e35dcf13f89f9ee07e579b120b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4294', 'DolokgabUC', 'DolokCax', 'tancereva.taisiya@mail.ru', '$2y$10$3LXpHX1Z3IAPgObYCaX.6eIC7eVpYvxOU.8uKXDVz/HhAU30WCWDq', '1', '0', '2018-10-27 17:51:28', '0000-00-00 00:00:00', 'd8ab1b9cc6910e3d4908b405acea41ac', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4295', 'JamesHeaskHW', 'JamesDuh', 'exnzf4t9@gmail.com', '$2y$10$y8c94WXvBSl8CrOQ6oAO2e/3/o3/PxPJwuKG31ZnZEvPduGlMwstS', '1', '0', '2018-10-27 20:12:46', '0000-00-00 00:00:00', 'd4816d80620fc8c6820bca6cf2a887dc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4296', 'GlennBiareMB', 'Glennfem', 'umchu4p4@gmail.com', '$2y$10$xEzOR09W54dZdbamyltEzu9Uch.zVgz5wlx2i4oGpQOgMZzUBBjea', '1', '0', '2018-10-27 20:12:46', '0000-00-00 00:00:00', 'fa7099ec15d62111f3cd93eab21a090b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4297', 'GordonPalCG', 'Gordonraili', 'efloh1j5@gmail.com', '$2y$10$nqdud9U0QQepqWTVhEd.bOPqE0Agwop2upjxJ68LwCNNTCn2RAh1C', '1', '0', '2018-10-27 20:15:07', '0000-00-00 00:00:00', '641dccb674ee2b95af5cd7313c86c3c7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4298', 'StevenTarNE', 'StevenReike', 'pugff4g4@gmail.com', '$2y$10$AfT4TsJqal3jbCP7UqIlfu2FINTOT1WQIqcfh/vCTdGPMGChixadS', '1', '0', '2018-10-27 20:15:07', '0000-00-00 00:00:00', '76cbce1a18559439c80116645665b70c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4299', 'CharlesrawTB', 'Charlesbouri', 'qzssi1o9j@gmail.com', '$2y$10$YnaZmF0WGeniDLPpBAcq1OBiFIqTQ0CzGT6ZODLiJCzwYfEpTVWCy', '1', '0', '2018-10-27 20:23:50', '0000-00-00 00:00:00', '42897c1ef5688c8a2042f38175139105', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4300', 'andraprurbSC', 'andraJeW', 'andraht@gmx.com', '$2y$10$YonNLUMo4wrLYIPpH2g8iuIYkb/qpKW8B0lQCeHkmmrdN5o.weoXi', '1', '0', '2018-10-27 20:29:34', '0000-00-00 00:00:00', '11bc3cc0a76a895b57ed88526606604c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4301', 'DouglasspaseVR', 'Douglasspoca', 'zxcbjk9992@gmail.com', '$2y$10$4uNtYftyh2Quj.BnzMvgl.FEVRk.zVd2ARTvBVME.dHpEUzyAv/Jm', '1', '0', '2018-10-27 20:58:09', '0000-00-00 00:00:00', 'a0e42280f114ce28239e6dfe5525b714', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4302', 'GlennBiareMB', 'GlennSaste', 'sttum4n0@gmail.com', '$2y$10$mpR41EdbZLpy7uRnv3YxUOtDj.2J3uNDXNrEUkieEkLHzF.g4SRPa', '1', '0', '2018-10-27 23:15:33', '0000-00-00 00:00:00', '672664acc32d87dfb117a52d30b38372', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4303', 'JamesHeaskHW', 'Jamesgon', 'atufi8g8@gmail.com', '$2y$10$V1jpMYj15paNhfGhqObvP.Tv46UzrA4n3VfKa0aS0QQ/36XDM8Y8K', '1', '0', '2018-10-27 23:15:39', '0000-00-00 00:00:00', 'eb6fc969d12d780f201b71e57aaa6fd2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4304', 'GordonPalCG', 'GordonFealf', 'mzzov0g3@gmail.com', '$2y$10$S7ryywzByRHKUb8vKI/B0ub3LydU54ygonPIJmlJdWtx/OjH8hytC', '1', '0', '2018-10-27 23:30:52', '0000-00-00 00:00:00', 'c6560494735a0c67c0586827a5f98dc2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4305', 'GordonPalCG', 'Gordonerync', 'ndjzs7g2@gmail.com', '$2y$10$qDSOAEbM45We5lAGmhofh.iHpy.IzpmmuLk144fhZjLnVamPI20ZO', '1', '0', '2018-10-27 23:49:49', '0000-00-00 00:00:00', 'e3fcf2bd2c734e29320a6dd5b96bb53b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4306', 'StevenTarNE', 'Stevenbleby', 'pqerf6j8@gmail.com', '$2y$10$1l9I7gYJPVX.YNkaJrWpU.9qH2WrRiieGClbIYJ07A7qGv6mqi3kG', '1', '0', '2018-10-27 23:49:50', '0000-00-00 00:00:00', 'b66d8dbc60f8ad9d4cbadad63deefd4c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4307', 'CharlesrawTB', 'CharlesQuown', 'whioy0c2e@gmail.com', '$2y$10$Wrruq8a04rMLoKvuLYhf1.VnBJ0r.Bw/cc.UnfqXoNqXfOWnbaNWC', '1', '0', '2018-10-28 00:27:00', '0000-00-00 00:00:00', 'dc11de02f6210027f6f111fb5edb6be6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4308', 'GordonPalCG', 'Gordonspofe', 'wduwt1n8@gmail.com', '$2y$10$KZ19kEVxS3dHkX.tVQyoYunzjjsOJUCIsEWMhkZOFv5JUpGLo9/jy', '1', '0', '2018-10-28 00:58:48', '0000-00-00 00:00:00', '117ea45c36b8a92ca61dcd6afd0ea127', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4309', 'GordonPalCG', 'GordonJer', 'oqmqv4c1@gmail.com', '$2y$10$.drwy9oVS3o77zPuV6YILO7eFcAyL6k0q2wpPFiyDB/WC.a1MYb/e', '1', '0', '2018-10-28 01:04:37', '0000-00-00 00:00:00', '5249060c694ca2240c5fbb4c0498286b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4310', 'GlennBiareMB', 'GlennGex', 'odmhn5i1@gmail.com', '$2y$10$JvpH/KrOFzXr197LSKD78uH5Gi8H0SBKn0R83jJvRo075vIVKMuIW', '1', '0', '2018-10-28 01:12:21', '0000-00-00 00:00:00', '68b2c3e44eecfc3ce5ba71c5deef70b8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4311', 'JamesHeaskHW', 'Jamescus', 'srowp1k2@gmail.com', '$2y$10$oNaJ8gXrBtlS0TNr3WKip.qtP8dm0Kj9utaFUKS2IT3/qJjJ.XAEe', '1', '0', '2018-10-28 01:12:26', '0000-00-00 00:00:00', '4c895897c3be89039833cba7a06a3962', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4312', 'JamesHeaskHW', 'JamesSwimb', 'lurjd7p5@gmail.com', '$2y$10$7hgMKBKo2G6J73.I/qGp9eqCX1Xnqv7GW.PkWtBocVG94Vl62fdGC', '1', '0', '2018-10-28 01:30:29', '0000-00-00 00:00:00', 'e5cd7383aae0ae417753668eefe4153d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4313', 'GlennBiareMB', 'GlennImigo', 'rdjvy0q3@gmail.com', '$2y$10$wBDqSHGYKjLvGypXJpT/S.LMEfc.ETYO1JxAFsEsJQP4JqnmfTAQi', '1', '0', '2018-10-28 01:30:35', '0000-00-00 00:00:00', 'a6bcb3f0f88d0c9e425179ce7f08db7b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4314', 'GordonPalCG', 'GordonWep', 'xweyw2u0@gmail.com', '$2y$10$l1qspaW976txl.k7lKqmA.fGGHC7J43CdtVxWRK9cF6rsPFmKmSC6', '1', '0', '2018-10-28 01:43:34', '0000-00-00 00:00:00', '1ced8257e288eb72118a3eed1b7400a6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4315', 'StevenTarNE', 'StevenBon', 'bjmoh8b2@gmail.com', '$2y$10$9gicaY0bKnZ3Ne/zNk/kMOEbDzvv8Mz1cBPidLeFS3aJQrhdTxMNK', '1', '0', '2018-10-28 01:45:30', '0000-00-00 00:00:00', '48996e2d3503227eee3da18d102a8d1f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4316', 'GordonPalCG', 'Gordonemare', 'svwfv5r6@gmail.com', '$2y$10$b.eL7TJ889yvMqR.4AdmCudurTEiH4VbIoL/30YTG6uiF.xvD2bci', '1', '0', '2018-10-28 01:45:31', '0000-00-00 00:00:00', 'f1ddb44f8ec04bac115d9d922a5486ad', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4317', 'StevenTarNE', 'Stevenzer', 'foodk2w5@gmail.com', '$2y$10$c3WZuvUk/GJ7PfGCMQD27.rjYgDeP1aByQX0WlE8LHD/Q6crNzqYK', '1', '0', '2018-10-28 01:58:08', '0000-00-00 00:00:00', '21badc23a56e52c209fa5533fbea5956', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4318', 'GordonPalCG', 'Gordonsah', 'hnspa4c4@gmail.com', '$2y$10$CO5xNxjusJJiYAFlcuygeeydRCTDnjkYp0fWxMgfq98RNTwknwMNq', '1', '0', '2018-10-28 01:58:11', '0000-00-00 00:00:00', '2bc5bd84ee1de736a52d8ba46f5179ec', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4319', 'GordonPalCG', 'GordonEmors', 'xnfrc4o6@gmail.com', '$2y$10$8Z7o3Lq/x0LO5FuoNPnXQ.PyP.5JWSz.0P2dcbgJogoklQiXW2xBK', '1', '0', '2018-10-28 02:34:35', '0000-00-00 00:00:00', '104711f74c9456dad8fd91ac4c056559', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4320', 'GordonPalCG', 'Gordonhup', 'utqbs2h7@gmail.com', '$2y$10$F.OtrjecbYx/7BPsWIUfo.7RlD12n.QRhd0qyTx6Kw/z9s5NVdOFm', '1', '0', '2018-10-28 04:34:51', '0000-00-00 00:00:00', '6517f4cf6bad3944c74e402daefc9a1a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4321', 'StevenTarNE', 'StevenInofe', 'nfgaw9r5@gmail.com', '$2y$10$xF3fhRI0ZRV4wqZamT.09eLLhWhwUUH7TgsR7kCWEeHiwLYBmVTmy', '1', '0', '2018-10-28 04:42:11', '0000-00-00 00:00:00', '0e0d3c8adc27dd3a3c9dd0827fb2f7e6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4322', 'GordonPalCG', 'Gordonerymn', 'jdeam2b8@gmail.com', '$2y$10$0v.0Nb6iiPS0HRBTgZegB.7B0PWC2Cpmz5oYLNnx1WVSPgT1qHU2q', '1', '0', '2018-10-28 04:42:14', '0000-00-00 00:00:00', '849bfac12b9f4cb7559f89d4a94b77a5', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4323', 'JamesHeaskHW', 'Jamesbah', 'bnmtc5b7@gmail.com', '$2y$10$Bma6HHtY.H0Z1bbm.JkMRuTCg2eUACDQZvwLQawHHXEC0PJZpHZBK', '1', '0', '2018-10-28 05:07:43', '0000-00-00 00:00:00', 'd6b3a76d31d01b3f03df73e7b5baa919', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4324', 'GlennBiareMB', 'GlennSaf', 'frexr1v6@gmail.com', '$2y$10$Mg1EFuEGxw26amPXxDTAf.oSX2psFxF6JQ7WvNTgqgXKGKIj/qxRm', '1', '0', '2018-10-28 05:07:43', '0000-00-00 00:00:00', '00d679a20404b451374c07902aea9d8d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4325', 'CharlesrawTB', 'Charlesignop', 'ceymo2i4f@gmail.com', '$2y$10$GeLH.EbgKw1fvwFQZfre2elmLvB7KLdIh7QawkHFnW26HdcjUyaLC', '1', '0', '2018-10-28 06:06:35', '0000-00-00 00:00:00', '276561178fe73bd1f9b9355234d6ec7d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4326', 'StevenTarNE', 'StevenTox', 'sibsi1o9@gmail.com', '$2y$10$5zxprVlFbNkqijavUn68rOy3qoexxIkM57fr2Z99l2AfFIxqjEVVS', '1', '0', '2018-10-28 06:19:22', '0000-00-00 00:00:00', '9e6a0f9f32b59f45ff1c78d1e9c6d66f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4327', 'GlennBiareMB', 'GlennTom', 'ycjlu1w2@gmail.com', '$2y$10$vOg73BNintqVfThrqyCoqegMnG1MVJtHT95cANrXBjv6Kilv32ft2', '1', '0', '2018-10-28 06:47:46', '0000-00-00 00:00:00', '3b0691cd5f756e86a7b72806d5fd7784', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4328', 'JamesHeaskHW', 'JamesHog', 'bnffs1e0@gmail.com', '$2y$10$vk5TZWD1TDwEjyVzIf3RIeA5YZKNU2ErlGGVv1VM2b1GJrOHTE.mW', '1', '0', '2018-10-28 06:47:48', '0000-00-00 00:00:00', 'c0fe89b46761317a69407a86ffdc21d1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4329', 'GlennBiareMB', 'GlennThync', 'zuivg1y9@gmail.com', '$2y$10$O5Tn1yjaPXp98cKcCuZp.uf2rLCPIBodA5VxD.rGjdX7lA6uGyEPa', '1', '0', '2018-10-28 07:41:17', '0000-00-00 00:00:00', 'd216e06c985ceff8ad996bb71c759ea8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4330', 'JamesHeaskHW', 'Jamesrar', 'giyii1k2@gmail.com', '$2y$10$bHmGWa7JpQiVa9ck6fZOAOBToavTdtDbypVtSeopMLfCkbVBv9pbe', '1', '0', '2018-10-28 07:41:22', '0000-00-00 00:00:00', 'e9ad5126e24d26e5a1d27c976db98313', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4331', 'GordonPalCG', 'Gordondus', 'sqkol5n0@gmail.com', '$2y$10$HsN8mJy2GDF59rX2ShMmkeL65tt/8R6Nx9Q61DkYQ7X9SWjYGenMS', '1', '0', '2018-10-28 07:52:50', '0000-00-00 00:00:00', '42cbace666b35e5ea787a6a23fe1d7f8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4332', 'StevenTarNE', 'Stevenagomy', 'tcqzc6e0@gmail.com', '$2y$10$v19agJIkLvC1o3Pj865VweYR0J8j.na5fv4D4ZhZTNrOIFhaavqNS', '1', '0', '2018-10-28 07:52:51', '0000-00-00 00:00:00', '946a33540b4ea72d2a1cdd255f074c27', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4333', 'StevenTarNE', 'StevenVitle', 'nocml7h1@gmail.com', '$2y$10$kKIGhuTPOB30FauLTOkNIuVJkvsSROChgnDRmKkez8IhXwSkpoz2e', '1', '0', '2018-10-28 07:58:43', '0000-00-00 00:00:00', '8e7799bc9cf4cd237dad3962fed66386', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4334', 'CharlesrawTB', 'CharlesCat', 'tykgt0a8h@gmail.com', '$2y$10$halCU3sXK78eoKTAR0qXy.W1ASlyrUyZskWi5hj5RrY2UZn22AS2m', '1', '0', '2018-10-28 08:21:09', '0000-00-00 00:00:00', '7ed6870ac18f16a10c810df87db8c68d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4335', 'GlennBiareMB', 'Glennjeors', 'snxlj7a4@gmail.com', '$2y$10$zwz4PwV456L0WzThaSSry.HjVWFz8sTjH3nB7LzN3M/J4Hu63D2SC', '1', '0', '2018-10-28 09:23:34', '0000-00-00 00:00:00', 'c0fde3abc2263501bd6c68f11d0df420', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4336', 'JamesHeaskHW', 'JamesAmacy', 'zyxcf6a3@gmail.com', '$2y$10$p66cVh68IRQyO.RM2Y7lk.rouKmDNOeFVW4yRUZN5vfKJ7V7MnTo2', '1', '0', '2018-10-28 09:23:37', '0000-00-00 00:00:00', '22e705174de05b3c0e30d38d747c0a3f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4337', 'GlennBiareMB', 'Glenndub', 'vpsuc1q7@gmail.com', '$2y$10$pL5/RhUO1zBPa1Ky/n9/7uTFFQn04TuVqt8zGDW3JI3bGlrMzRAde', '1', '0', '2018-10-28 09:24:20', '0000-00-00 00:00:00', '98c491f7073ed8e6eed1ef8dddd07044', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4338', 'JamesHeaskHW', 'JamesVak', 'sedsx2m9@gmail.com', '$2y$10$d.9cFbH5RfkhiEOqywGFx.XS4O30.RpkqtX3NoV7PMG32WtoYH/oO', '1', '0', '2018-10-28 09:24:20', '0000-00-00 00:00:00', '61193d33bf840f1f53a79bbba71aa158', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4339', 'StevenTarNE', 'Stevenfluth', 'vipxl5e5@gmail.com', '$2y$10$qfsHY3/zPkdtSg/7B4EeuefIkaBrl68AyjI3QAEMiKyLE0UTEJAx2', '1', '0', '2018-10-28 10:11:52', '0000-00-00 00:00:00', 'f997a776b9c142092c1731a7ff34aa9a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4340', 'GordonPalCG', 'Gordoncop', 'lrqal7g3@gmail.com', '$2y$10$S49acADImHpq.GS65ZMtc.4TeUyJ4RIIFovC2XrFR/ZYCte1gN36m', '1', '0', '2018-10-28 10:11:52', '0000-00-00 00:00:00', '6ca1ef3ce714f2d9a9e3e499ed8c179d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4341', 'GlennBiareMB', 'Glenngok', 'xvwqw7q1@gmail.com', '$2y$10$0d83JHrlY76ewwKQ/VKWrucA56dcBSptlU5SqXwRaT4.4aVACG3ai', '1', '0', '2018-10-28 10:12:33', '0000-00-00 00:00:00', '2c80583738197d1867e85a60311a5976', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4342', 'JamesHeaskHW', 'Jamesidelo', 'wnzjs4x0@gmail.com', '$2y$10$j/CkOvft9pYEUiaDW9BrMOK2l1Fg6GpRzYabSrwqHtiP3WmGMuTfm', '1', '0', '2018-10-28 10:12:33', '0000-00-00 00:00:00', '81304490d761130827312722edfe347c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4343', 'GordonPalCG', 'Gordonadoxy', 'kdikp7s1@gmail.com', '$2y$10$DEYcYxPg/PIMdCTIJMKhzeMmmodF06e.rJy1bUkIDIOa7QMFSnzxW', '1', '0', '2018-10-28 11:22:54', '0000-00-00 00:00:00', '98391e7f559ea56128deb60f0a854a71', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4344', 'StevenTarNE', 'StevenTip', 'chvbo1l1@gmail.com', '$2y$10$Ho.G1DVtMyaD89/R/KDBLuWyV4hXwAYy.f9X8Av6ef02tpZZfQKry', '1', '0', '2018-10-28 11:22:56', '0000-00-00 00:00:00', '1c04f68733658d067630202bc8d43097', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4345', 'GordonPalCG', 'GordonBem', 'oekdg1y3@gmail.com', '$2y$10$x9p6gPYRaOtY8mkMt5oTk.U9NG./OJZ/CCNcZtjffgk1bDaCBHL5m', '1', '0', '2018-10-28 11:46:15', '0000-00-00 00:00:00', '8efeeaf199c1b9a31daa60e94bc814cd', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4346', 'StevenTarNE', 'Stevenenriz', 'rzotv8f0@gmail.com', '$2y$10$XtF7rvYytnfAxwAAeeAJO.1l35/VGHC/nRxETabUUi5gHf4T1bCUe', '1', '0', '2018-10-28 11:46:16', '0000-00-00 00:00:00', 'c1a7dfe6995ab3aea11627093df2d5ed', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4347', 'GlennBiareMB', 'Glenntit', 'fwllc2b5@gmail.com', '$2y$10$YjGU4.Eb0x4spu.k7SK.Dek8uQkX0XE5ka0eUHT/rNQJONldVViA2', '1', '0', '2018-10-28 12:08:09', '0000-00-00 00:00:00', 'ecfcfc3a24878a98715c545a52011bb4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4348', 'JamesHeaskHW', 'Jamessem', 'utpfy4u9@gmail.com', '$2y$10$rJeCV4gfCJmET86hbR6gBOYLLGnx1vTLf4rVe8lyc5ZGMXMCyaUVy', '1', '0', '2018-10-28 12:08:10', '0000-00-00 00:00:00', 'e29d41726e3ccee369b44d6638d8f645', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4349', 'GlennBiareMB', 'GlennFum', 'uluaa7v1@gmail.com', '$2y$10$ouVFH2TgXTW.q5ZUsDNGxOxOoUPZrw24apm4VLg/HLTXWdpL5ALYK', '1', '0', '2018-10-28 12:46:07', '0000-00-00 00:00:00', 'aabcfdd794ee03dd0d28324c8bb14ed4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4350', 'GlennBiareMB', 'GlennCom', 'tbdxf0e5@gmail.com', '$2y$10$7sxrj/Qi3zLtscwn.3LC0e3Vj/NEA1e7WOCqWNnFpMaluaROuCxee', '1', '0', '2018-10-28 12:46:13', '0000-00-00 00:00:00', 'b51c45ba60984a6e0c365e4f87324a4b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4351', 'StevenTarNE', 'StevenGep', 'ekflb5z2@gmail.com', '$2y$10$XQn.9mTMMRY.sLrJcnJw1u6fRo/a3wQrcGFAF7szZS5osWengv.ha', '1', '0', '2018-10-28 14:11:58', '0000-00-00 00:00:00', '46445f5eea3d99c448a954d22bcbca31', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4352', 'GordonPalCG', 'GordonMairm', 'vwzcr3k0@gmail.com', '$2y$10$NNP/7XfVLphsgl6mC4nSqOjpzDzvROAQZpFT9p5lJY84BeuAX2QIy', '1', '0', '2018-10-28 14:11:59', '0000-00-00 00:00:00', 'e432fde861d4fa8f9cf19b0d935f9b68', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4353', 'GordonPalCG', 'Gordonisove', 'helkh5y2@gmail.com', '$2y$10$9R1lHmF3DjyjmYwNbAtMpud841bxndtRmleDvmMEHkAn6y30juNpa', '1', '0', '2018-10-28 15:16:57', '0000-00-00 00:00:00', '686dacc8a4e0477e25b2d2244d58a040', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4354', 'StevenTarNE', 'Stevenevots', 'gsmom3q2@gmail.com', '$2y$10$FjKaDxNFARSKCFNKsBlRkOrkZcBvxBCjdxg/.jrweYM7FwNVN0KYG', '1', '0', '2018-10-28 15:17:00', '0000-00-00 00:00:00', '1c8dc5210170be354785cb5d8985887b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4355', 'JamesHeaskHW', 'JamesGap', 'ghlly4s9@gmail.com', '$2y$10$Eo39HIGToCxX1noXXjTxL.yP5g.p9WoIqGRInlKRFqO5bh79uVHie', '1', '0', '2018-10-28 15:32:09', '0000-00-00 00:00:00', '55785e34493b8dc4587a66fea01b4c0c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4356', 'GlennBiareMB', 'Glennopild', 'dgvwr0w7@gmail.com', '$2y$10$anHFYFdVb8skkcravwZKVOF4AT1ap4wOJ15eBzVkyLaAHpjX1ozW.', '1', '0', '2018-10-28 15:32:10', '0000-00-00 00:00:00', '93be6abb04440f89cc83e8e8c6218ec5', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4357', 'CharlesrawTB', 'Charlesbog', 'izrza3g7g@gmail.com', '$2y$10$/TRimkmulin9wZy3Ja6p2uoZVbNgPdOKNQ7u1Oni3I1UrKlcg3RDS', '1', '0', '2018-10-28 17:40:03', '0000-00-00 00:00:00', '7a6fd0e0eacc2107895e737b2f949133', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4358', 'JamesHeaskHW', 'JamesJuh', 'fribx0g8@gmail.com', '$2y$10$jxMsdQDuN31aVjG9BmILcuLtZ3.Yix6c6aIArGNfi540q4mMDot0K', '1', '0', '2018-10-28 18:11:28', '0000-00-00 00:00:00', 'dbe8f6d3c76366ca619468e3931184e3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4359', 'GlennBiareMB', 'GlennEldew', 'sofsa2w9@gmail.com', '$2y$10$9.02.AFeIhTay3cRNn8sOO/maRF1Xt91Bs3yqPhByztF0PfSfJfwa', '1', '0', '2018-10-28 18:11:29', '0000-00-00 00:00:00', 'dc092193d74cb31faed33caf4ea39734', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4360', 'GlennBiareMB', 'Glennalcon', 'fhajt2h2@gmail.com', '$2y$10$eUU9KUP1lKZt7WkmBqNWie5d0jWLgtGNI8RHi.Jm4iwuzfFBNapX.', '1', '0', '2018-10-28 20:10:50', '0000-00-00 00:00:00', '02dfb2c5e190de7de33e0da8470e3508', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4361', 'JamesHeaskHW', 'Jamesmathe', 'tfiyc1b1@gmail.com', '$2y$10$pEW55e8XVt/.8RU428jkGOc4zoMQVTVh0G207YEou1BU8aHLPhHmq', '1', '0', '2018-10-28 20:10:51', '0000-00-00 00:00:00', 'a02a92b3bf432343dd236d0f87076201', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4362', 'JamesHeaskHW', 'Jamesadolo', 'qoomn3h0@gmail.com', '$2y$10$LbHwRaZ3PIJj9A3ooYvlleJXtOja7ipNlUBgITml/O9aj8IM6fZ1O', '1', '0', '2018-10-28 20:21:17', '0000-00-00 00:00:00', 'cb6b3311a5038a4f9cfd5e254aa560e9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4363', 'GlennBiareMB', 'GlennNok', 'vmqvf1b3@gmail.com', '$2y$10$H.tUcxcBjlnS0l17q8QxmOn2PFzcNzJ3.m0qudCPn/IR3QCeEqPIO', '1', '0', '2018-10-28 20:21:17', '0000-00-00 00:00:00', 'ee150473cefdd6445dec29931cdb7a81', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4364', 'GlennBiareMB', 'GlennHek', 'egrck8m2@gmail.com', '$2y$10$ZoQWJ7dtfl08V4F03gX86unlg2v/4wKloNzoU7wROpWWA.cMD1xGm', '1', '0', '2018-10-28 22:21:48', '0000-00-00 00:00:00', 'fc1644d81761d1fc94a7f88e65db703c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4365', 'StevenTarNE', 'StevenDrolo', 'ecmcz0b4@gmail.com', '$2y$10$ur9ViSYjXBDd0TPcpEcPyOI5P2gPNRgJqKfb8ehwxjIQ74HsBQ/Zi', '1', '0', '2018-10-28 22:56:56', '0000-00-00 00:00:00', '4cdd3d4f3c6946c20853352e62db8386', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4366', 'GordonPalCG', 'GordonKek', 'zqjfe8l9@gmail.com', '$2y$10$GW.8iuW8ezi6Ww6y16B1K.puYr7XPwkG0B8c7YA6QvbMC3HXnTX6.', '1', '0', '2018-10-28 22:56:58', '0000-00-00 00:00:00', '3da9393799d4641db4ee26486911f119', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4367', 'StevenTarNE', 'Stevensof', 'qqfry7w8@gmail.com', '$2y$10$Qrb5fAqy77yNNbWFOr9speQpflFYckzix/SnS0K3zHTD0arlITeh2', '1', '0', '2018-10-29 00:40:29', '0000-00-00 00:00:00', '3a0b9f331eae13612b86c354e2d9c78f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4368', 'LancecousyDP', 'Lancecousy', 'volyariel@gmail.com', '$2y$10$UHR6qxLCUnnlbTK8ZsOUlex0zT8UhwyWCZU3YlRrLT8xJGnR5Tr6O', '0', '0', '2018-10-29 03:16:24', '2018-11-11 02:19:17', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4369', 'StevenTarNE', 'StevenPek', 'dtidj0w1@gmail.com', '$2y$10$FiDmvnsd4fznbcRyNUicceEKnelQps1tL4kXkTtiXwHhSRwmKvFSm', '1', '0', '2018-10-29 03:38:10', '0000-00-00 00:00:00', '2ea1611097ebf7cf2f4934cd40a6621b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4370', 'JamesHeaskHW', 'Jamescadal', 'bujvv6r4@gmail.com', '$2y$10$rY6gpIQMJyLH4GYp80pg2ODyFh2WxSHRn4uDsyuWVA2JLraw3j5le', '1', '0', '2018-10-29 03:46:14', '0000-00-00 00:00:00', 'be7ebdcf3df3d765c656fe564e9cf271', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4371', 'GlennBiareMB', 'Glennnom', 'dqsww6e9@gmail.com', '$2y$10$ClilEGiPj9qYTfOFYAd6S.GlI2Thp.ATINOWi5MuEtSDb/.wKNyZq', '1', '0', '2018-10-29 03:46:17', '0000-00-00 00:00:00', '324e10b6d5cd457007567f4780fdf094', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4372', 'JamesHeaskHW', 'Jamesgailk', 'rjzxf0i7@gmail.com', '$2y$10$ej5rde73McowNJZMcHcM5ux6vq4R3s0Ou1QwZrx7VneA9KO0wbQ6u', '1', '0', '2018-10-29 05:27:01', '0000-00-00 00:00:00', '10a650a1a7df30b41ef8483de5e45283', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4373', 'GlennBiareMB', 'Glennoptib', 'ythrs0m0@gmail.com', '$2y$10$v.FTs9fQF1D6fgbjHQI4bO4zOWBfy7wGXp5hwjsxwR6OeokE6507q', '1', '0', '2018-10-29 05:27:01', '0000-00-00 00:00:00', 'ed238633876571a45b3fd0640b423ae4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4374', 'GlennBiareMB', 'Glennveisy', 'sttum5v0@gmail.com', '$2y$10$jl2TrSNoNTjs4UkddFZH4upQ29baiAuK4Xb4KNHFQwmz1gyiXvzMm', '1', '0', '2018-10-29 06:20:37', '0000-00-00 00:00:00', '1050c99c0688b44b2022bb259c0df3b2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4375', 'TorrenticproHA', 'Torrenticpro', 'lena.bunilina@bk.ru', '$2y$10$tyzO37kiwQmjVECsZTgg6u/9NJlHAq7ExhIIwUJy63cpLPOTVwokW', '0', '0', '2018-10-29 06:37:59', '2018-10-29 06:39:23', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4376', 'GordonPalCG', 'GordonDyero', 'kbonr1k4@gmail.com', '$2y$10$KlFuZlyPCXI71fTStI7Xi.Q/ogcQYihGj3uGAxRX3MJ7RUyaTnpFC', '1', '0', '2018-10-29 07:09:43', '0000-00-00 00:00:00', 'e42f7c2eab9e5806f1b6db0f61cc2736', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4377', 'StevenTarNE', 'StevenVot', 'xusog5j8@gmail.com', '$2y$10$93bT/.zTp0PPRzx9n9l7puOrOpNM/ibyIyKJJyfnamfSkNWZ79Bvq', '1', '0', '2018-10-29 07:09:43', '0000-00-00 00:00:00', '487cd7659709446c57ea9dfb2b50e734', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4378', 'CharlesrawTB', 'CharlesNitly', 'paxpw6j7k@gmail.com', '$2y$10$qSn8nHi1AlFjF87c2WahZuDAqulDvPevRnO5Q61DYtNPaN35xlfhK', '1', '0', '2018-10-29 08:02:21', '0000-00-00 00:00:00', 'cd68714b1f8c93433706fc2b03f9e6df', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4379', 'CharlesrawTB', 'Charlesjes', 'mspli9i6g@gmail.com', '$2y$10$FZEnHZ5U9kIyW/t/uVsDiuJ7uFII/vn9GP9h1eSieUoEEFNIPW69q', '1', '0', '2018-10-29 09:29:54', '0000-00-00 00:00:00', '8905befeb46f7a5a51686e8ebb8306f0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4380', 'JamesHeaskHW', 'JamesMoubs', 'wlpxt8y3@gmail.com', '$2y$10$ND8xMXLQfWemsxGjrnvfEuw4ChClr9bcW4TElMCXvTPrHwStbegrG', '1', '0', '2018-10-29 09:57:11', '0000-00-00 00:00:00', 'be082e35e7115b7e90107eee3f264dff', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4381', 'GlennBiareMB', 'GlennPiero', 'hkcdv3r5@gmail.com', '$2y$10$sN/kqofIBx8OUlHTmmJDNuhQJXbJ/DtXtE9L4vLJQlpdMqrwEPYqW', '1', '0', '2018-10-29 09:57:13', '0000-00-00 00:00:00', '7bb77ccbde5ca40145ddf8c0f2311b60', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4382', 'GlennBiareMB', 'GlennDuh', 'akzsj9q4@gmail.com', '$2y$10$.XyF0l5060Hu.KPlEAURK.dY6XUgEGigmpNST5D0u5J4uyrEGr2u6', '1', '0', '2018-10-29 10:42:14', '0000-00-00 00:00:00', '5ce6a890a07fdf225bb93a284e012e41', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4383', 'JamesHeaskHW', 'Jamespiera', 'kqexd1d6@gmail.com', '$2y$10$KePKBQjXca68i5NtV.681ubDSsdp.JtN6TBrcwdoWXQLn3CaysjgS', '1', '0', '2018-10-29 10:42:15', '0000-00-00 00:00:00', '9891b259a8f981034a4a27214cc174cb', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4384', 'DiegoktIT', 'DiegoEi', 'Li-i-luDmitrii1992@mail.ru', '$2y$10$PxRklIbbf6gQXhN040SrjODAbwJLMDDGlwfaZJX0aQRmC4FhnmFVe', '0', '0', '2018-10-29 11:42:44', '2018-10-29 11:43:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4385', 'VladislavhaicyFZ', 'VladislavBuigh', 'vladislav469ka@mail.ru', '$2y$10$hJ2gWMXo8vOFiT26q1RRneWwNOVYDowue4DXHVXQGxrfvH3j/MZgu', '0', '0', '2018-10-29 12:09:02', '2018-10-29 12:19:28', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4386', 'PavelZirmGD', 'Pavelmirm', 'MotylinTaras1994@mail.ru', '$2y$10$IX1GCqPGSHGMCGdnQf9Nh.m8VgQZWNr32De5bEvEo9TDFGZfAQY02', '0', '0', '2018-10-29 13:17:17', '2018-10-29 13:18:09', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4387', 'StevenTarNE', 'StevenNit', 'pozre9c3@gmail.com', '$2y$10$L7UpSBujnILSgVmTQnnDPehE/hdvRfLQQeVkXIw4TkzgogFE5JPaW', '1', '0', '2018-10-29 13:35:26', '0000-00-00 00:00:00', '5020fa7ac52766ab8f6964e6cb9f5950', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4388', 'StevenTarNE', 'StevenDiele', 'uwosf8b4@gmail.com', '$2y$10$nzjhbw7axJpCjK6tqR1s9.B9GsA/io5r8zyqK4eqjWT.5Ak7fNLVq', '1', '0', '2018-10-29 13:37:39', '0000-00-00 00:00:00', 'a38dddb82a28c5dda3f8d7544c1eb9e3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4389', 'JrryMonAI', 'JrryEruth', 'chrisooo@gmx.com', '$2y$10$TdtdquPmN5qVTIrFPzGXe.l6AzDXc3F/8n3dNBF6ycIRco/t1vHd2', '1', '0', '2018-10-29 15:23:33', '0000-00-00 00:00:00', 'd26df21635678a428197e55d2ad2e9f1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4390', 'KeganPiZY', 'Keganliab', 'ksmntr@outlook.com', '$2y$10$cBL.IkBWz6sNXz7eMj6sSuo76vnF/0H3Lb9C9Dd5G0s0yNhXVG3VW', '0', '0', '2018-10-29 17:00:01', '2018-10-29 17:00:31', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4391', 'StevenTarNE', 'Stevensef', 'ogole6w0@gmail.com', '$2y$10$FgukBU2K/fN2eE2hO9kyZuCaxq8Svey8QIanuboMD2BCuTFJp6n3e', '1', '0', '2018-10-29 19:15:16', '0000-00-00 00:00:00', '948bc08a2a50aca86612d657e20885a9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4392', 'CharlesrawTB', 'CharlesAbivy', 'ljeuo9r6r@gmail.com', '$2y$10$y5WHp3G6rOk3sBbxSE6D2OUzV5Zg7slmjiaNaQlIi9KoYza8Y/4xi', '1', '0', '2018-10-29 19:47:25', '0000-00-00 00:00:00', '1a22dea0b6aecc0b1067932c4e0d42e0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4393', 'GordonPalCG', 'Gordonbrolo', 'vbxqr8m4@gmail.com', '$2y$10$5RdKOY6mOOGnEyHTG2cQ.eO1NHojtJp6luoMnaFMDBaG68vWha0WC', '1', '0', '2018-10-29 19:55:41', '0000-00-00 00:00:00', '45c40212fc0f64a865392650e8b17237', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4394', 'Pill-Price-AVA', 'Pill-Price-A', 'john@acheterbonmarche.fun', '$2y$10$JIl85uxuYwf7mOUAU7oGDOOQQOVXQPJQdCGeDJ7KVOipAwwJs1ynS', '0', '0', '2018-10-29 22:31:40', '2018-10-30 14:47:04', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4395', 'StevenTarNE', 'StevenHah', 'uoxya4w1@gmail.com', '$2y$10$uDNHWXszRi5H6NFzPZptYuDRNl0hy3jqh.EFH188nVuxehsZT4MD6', '1', '0', '2018-10-29 23:54:40', '0000-00-00 00:00:00', 'c578c756c3f0b8c9ee290cec678b115b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4396', 'CharlesrawTB', 'Charlesjag', 'syjob7v6t@gmail.com', '$2y$10$JTKSnZmU2p/O3J5fNyFOHuHf3E/AAqYY1fwvr7FUXYz1Ld9MpbFwW', '1', '0', '2018-10-30 01:15:02', '0000-00-00 00:00:00', '5a9c41614ac055078fef77678ee6a737', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4397', 'GordonPalCG', 'Gordonfox', 'bivwm8e6@gmail.com', '$2y$10$Z60PvJiboEPdZybmOptv8uSg3CAH5Xyj9Nqo2vfsmk.ju0rN9QOpy', '1', '0', '2018-10-30 03:26:28', '0000-00-00 00:00:00', 'fd36815d0667ce1af1e267dc6b6b685c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4398', 'JamesHeaskHW', 'JamesPutty', 'naeay5l3@gmail.com', '$2y$10$nbVQn.wFGdY4KdKavpX8I.1pc30JhDHkvcpNd5gtfPbQrbRBXOI.u', '1', '0', '2018-10-30 03:50:55', '0000-00-00 00:00:00', '3b32a86c89ca5ee8f9a4cc643ed3dc89', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4399', 'GlennBiareMB', 'GlennWeaTt', 'gzmth9y8@gmail.com', '$2y$10$ZH2VNugbpmQ84WRQGt0lI.AD9ttAuKequ3AQPJYSkLNWcomH/ZpXq', '1', '0', '2018-10-30 03:50:59', '0000-00-00 00:00:00', '913e4960030e251d3579a07be872f9fc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4400', 'StevenTarNE', 'StevenAbubs', 'lijpf4m6@gmail.com', '$2y$10$e4xm2eOJbbPQvNp85eMUtOHirigh9KERApmZPSL.6fO9YGMkufy2O', '1', '0', '2018-10-30 03:56:22', '0000-00-00 00:00:00', 'f36774ea3d910de2ac8548b4b641b933', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4401', 'GlennBiareMB', 'Glenncak', 'psdqc8x7@gmail.com', '$2y$10$Ds8InnjwY8jq0WJ6phMvdutYYmn67jRAsw4OkIQ2c6x7ZUsIjHa7m', '1', '0', '2018-10-30 04:04:44', '0000-00-00 00:00:00', '27a1af8668d00417bad2cac89a66f591', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4402', 'JamesHeaskHW', 'Jamesphisk', 'ymnbu4u9@gmail.com', '$2y$10$1MXOiQjHyEMDIq6vU5xOM.Z83.fL/YmxcOfZzcF4R8tdOWRmAL1FG', '1', '0', '2018-10-30 04:04:48', '0000-00-00 00:00:00', '41fd855e4fd28599cf0a28995ff961a5', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4403', 'OlliecowZK', 'Olliecow', 'zen293@taidar.ru', '$2y$10$esWfslsMopKivny5waNjxuB74iIGW4LhBVjsbVqo9y8AFNSivW5NW', '0', '0', '2018-10-30 04:27:42', '2018-10-30 05:42:54', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4404', 'GlennBiareMB', 'GlennTaubs', 'sfque2b1@gmail.com', '$2y$10$vyA18QH8WGPAfhXG.czTr.wwCcrClP65Jq7uX02pprKWgtGvKFpCS', '1', '0', '2018-10-30 04:40:39', '0000-00-00 00:00:00', '72f32cc759aa3723572aaf1c0cd3fd26', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4405', 'JamesHeaskHW', 'JamesWap', 'uiyfm4m3@gmail.com', '$2y$10$yzK3rt6SN.1r9O050EDaH.BMUWUftdGjWhEtaT0uM0GGy2kRWkiVm', '1', '0', '2018-10-30 04:40:40', '0000-00-00 00:00:00', 'f9cbd495872ea979937f9a2daee5415c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4406', 'JamesHeaskHW', 'JamesTouck', 'bmtal2q3@gmail.com', '$2y$10$Hq7AC0/b.1.K49b2m2SXieypIY7FzwvS8gznSaJqxViRD6qb0tga2', '1', '0', '2018-10-30 05:32:41', '0000-00-00 00:00:00', '7c2fe02e7a395ab864225e0c81cbe5ed', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4407', 'CobrynKtAT', 'Cobrynmus', 'LenyaRazdaivodin90@mail.ru', '$2y$10$pRDykiAWhKrYNJIZkXdIEOW71foWD.fha18NwwtA/dU2nVzt6fODa', '0', '0', '2018-10-30 06:10:17', '2018-10-30 06:14:06', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4408', 'KafaAlogTM', 'KafaKa', 'VitkinTimur93@mail.ru', '$2y$10$kqkCGlY3V.qr3uLtSOE4xOzs48QsLrPxjU/9GSZKttftLqguS3mc2', '0', '0', '2018-10-30 06:29:26', '2018-10-30 06:34:31', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4409', 'JamesHeaskHW', 'Jamesriz', 'xjuvn1d0@gmail.com', '$2y$10$jmJK.8BHYyxsQlG2db.QjeP.G3ug5F/x2Om5Oo1bVhN2jo2gt26Fu', '1', '0', '2018-10-30 07:17:17', '0000-00-00 00:00:00', 'fc2da930bfc3f2fefc146a5007038578', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4410', 'salliemr1', 'salliemr1', 'leticiaiw4@kenta6910.riku18.alphax.site', '$2y$10$1x/l5AAGXgAX05BRQCJ0AOLr2n1kd9J7ZykPsDhI27Kf9X2sq6jFm', '0', '0', '2018-10-30 07:30:42', '2018-10-30 07:42:34', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4411', 'JamesHeaskHW', 'Jamesprawl', 'imnyo4j6@gmail.com', '$2y$10$xL094mltqwuQcB5ny7TmoOK80KsmJyehf7Ji1HNS0yUni0cMLExJK', '1', '0', '2018-10-30 07:31:34', '0000-00-00 00:00:00', 'ba5a10a2288205890406d7e7594ec53d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4412', 'StevenTarNE', 'Stevenmal', 'zties5n2@gmail.com', '$2y$10$qwzX99E1o0Lv.AISepo4HuUnhUn1AgjMxfH9HJi6DmB4QkC2HIoki', '1', '0', '2018-10-30 08:31:29', '0000-00-00 00:00:00', 'edf52e016d8a02d5c4f7256e815ed952', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4413', 'GordonPalCG', 'GordonSurgy', 'vlwmp3f1@gmail.com', '$2y$10$2cMoi7huLbsaYoltZ6/D2erhZ0WXOutPxKmp8LMg57qIOLyJvr702', '1', '0', '2018-10-30 08:31:30', '0000-00-00 00:00:00', '2b470b8d427e07120cd9688da172b1dc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4414', 'GordonPalCG', 'GordonDip', 'mnbaw1u2@gmail.com', '$2y$10$XFGGt719dg/IyxEWqE.aoeD3.JoYd/atFOvFY6Z2c0wgFc3AROnvq', '1', '0', '2018-10-30 08:36:00', '0000-00-00 00:00:00', '1f895237d4fe51cbb86fcc501c4e791f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4415', 'StevenTarNE', 'StevenVef', 'nhejk8s5@gmail.com', '$2y$10$SidhoJN7tjY.DsnWM7rHKOSy.DSV1wOVc7f8r67GJIFN3Hj/PiUeu', '1', '0', '2018-10-30 08:36:01', '0000-00-00 00:00:00', 'acc29bf7103712885dae44323ad14bf2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4416', 'GlennBiareMB', 'Glennstulk', 'ygkcs2d4@gmail.com', '$2y$10$OKRcRA.Ffj20YHia3NnWWeL0vtCVrFOtew8Dn.P3uAftwiBrvH.4O', '1', '0', '2018-10-30 09:09:13', '0000-00-00 00:00:00', 'a4e61f969a079793bc99a6f34775ba3e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4417', 'JamesHeaskHW', 'JamesJat', 'mhaux0x3@gmail.com', '$2y$10$DX4nZqJhUWvIDFkHvTheMeDA0g6OenofNrJlcPiJE7o44PlzusqWK', '1', '0', '2018-10-30 09:09:15', '0000-00-00 00:00:00', '37b418c67179a463bb37d626d476154c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4418', 'ndgprevaQQ', 'ndgEmele', 'atadfsjsgtyd0@gmail.com', '$2y$10$8IcsjNhn.c9kXMDLY1Kcg.mRT/nY0F70blC0r3ycrV6pOq0uYCiJO', '1', '0', '2018-10-30 09:09:36', '0000-00-00 00:00:00', '0cac64a38a89df165d96529cac5a1897', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4419', 'GlennBiareMB', 'Glennbow', 'gaxnr8g2@gmail.com', '$2y$10$qHrl8CoGFfYPWFHXMevF4ump87.IA.H4erdu95u8YF6VBoGPM4S7W', '1', '0', '2018-10-30 10:59:31', '0000-00-00 00:00:00', '67efca2a866b62d433ff71e903c1fbe4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4420', 'JamesHeaskHW', 'Jamesber', 'uumne8n2@gmail.com', '$2y$10$A7yDlwBtG5pQf4tVK96egeKBpwJHJEhR6aV6F/B2RzV4ZQBgIgMHi', '1', '0', '2018-10-30 10:59:47', '0000-00-00 00:00:00', '189d78b69e27acbd6079bcdfdeba93d0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4421', 'GlennBiareMB', 'Glennhep', 'nauad8v2@gmail.com', '$2y$10$EhpLtFRRdRLDVBr56eEiCeL7CW.BhFtd2XtRsdpUGIFGZNrdA372G', '1', '0', '2018-10-30 10:59:52', '0000-00-00 00:00:00', 'e82f7dd8158f35fd4a189ca62c34cb70', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4422', 'GordonPalCG', 'GordonInfic', 'dokhj1z4@gmail.com', '$2y$10$d5si/5et.BKC.VWyr3KQ/epgyQzlyam9tNxsyglq2p2TRZ2RhDy8a', '1', '0', '2018-10-30 11:00:42', '0000-00-00 00:00:00', '67a6aeae02d515f3abab171a10019d27', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4423', 'MarcusemutsDW', 'MarcusRaimb', 'vasyapla.t.76@gmail.com', '$2y$10$/8VHP/9j3.QWDc4eKuwwlO7ma8DRKXifLUaKzGQnGCRyVMWmMUnVC', '0', '0', '2018-10-30 11:05:26', '2018-10-31 10:32:31', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4424', 'CharlesrawTB', 'Charlesroorm', 'xioax8l1s@gmail.com', '$2y$10$0Gmw8STlNvSRjtfsuh1/ne86p7ATqFkIlYnWiLg.KP.O2gFp.IR.m', '1', '0', '2018-10-30 11:09:23', '0000-00-00 00:00:00', '881ffca3e4e6859536ee4d020ec88e3e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4425', 'CharlesrawTB', 'Charlesgeorm', 'wznvk0b2m@gmail.com', '$2y$10$wOISydaF5m0ZQ4/RE35oluTcWFN8riqXW5A0PcSYKBB3Al2TxiPkK', '1', '0', '2018-10-30 11:17:23', '0000-00-00 00:00:00', 'd0352cda3da4c3cb230782e57b4b17e3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4426', 'CharlesrawTB', 'CharlesUnuro', 'gxndv7o0b@gmail.com', '$2y$10$W43U1FWEY7d6zflZ/.yHDuBoHUdmDBqMVggb1Hbit8jbpuaVLvDwW', '1', '0', '2018-10-30 11:20:49', '0000-00-00 00:00:00', '2297aa15b76a0e52f708f695c5cbfcad', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4427', 'TamkoschAlokUO', 'Tamkoschma', 'AleksandrMokunov633@mail.ru', '$2y$10$97MiPB2WcSxQop/OwjwTQePgp62BH70hQ1RxsrPPDpCD6nCSf85l6', '0', '0', '2018-10-30 11:40:04', '2018-10-30 11:40:51', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4428', 'JamesHeaskHW', 'JamesHix', 'yrriu5c2@gmail.com', '$2y$10$kUSdXEB2vY2WaRLJTf/Kx.CTzMyDdasBisUVQU52Qj7mj2Lpmzj1W', '1', '0', '2018-10-30 11:50:08', '0000-00-00 00:00:00', 'd8e0b942db78b41b0d4808cced63c725', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4429', 'GlennBiareMB', 'Glennmok', 'eudtr6a2@gmail.com', '$2y$10$JsBBD3UGxwQ/TOBn1kAf2OemX5X.341cweTl8Z4isVunmGiaHRzMm', '1', '0', '2018-10-30 11:50:10', '0000-00-00 00:00:00', 'd2d1ec914b206074d765ad55884079c2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4430', 'GlennBiareMB', 'GlennMic', 'wsqry6m8@gmail.com', '$2y$10$tC/jIB5j6n0tPHL6XnBvAefFaG3mxRhknOEhMNK63RgOH6EvfA032', '1', '0', '2018-10-30 13:09:05', '0000-00-00 00:00:00', '3f3974f012ac83c72e3b7eac611f89e1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4431', 'BredertantGM', 'Bredertant', 'tiopes568@dtdns.us', '$2y$10$PSiLhmsNmpl4UvN9uamq3O/LIJCT3I7QMmDhIX6g8XgyQcw5mj4XG', '0', '0', '2018-10-31 08:14:32', '2018-10-31 08:22:08', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4432', 'alatoSildRH', 'alatoSild', 'trsayi87@dtdns.us', '$2y$10$80Jf5Tv81euS5B/ZrnIQwuBGxCEpZqFvqQUUNNW4M2Y9031rl136K', '0', '0', '2018-10-31 20:32:34', '2018-10-31 20:33:11', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4433', 'RaymondupdapYQ', 'Raymondupdap', 'amberhernandezv@gmail.com', '$2y$10$74z5bLeLdO6Qzs.k4Bu6aOw68nR/uEsL8Ul4XYum/qvqlzd60Qadm', '1', '0', '2018-11-01 15:27:45', '0000-00-00 00:00:00', '2d0068ad46a01a9b7e4fd2318268faf2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4434', 'KristansydayKC', 'Kristansyday', 'alekseygrigorev1998269c4nm@rambler.ru', '$2y$10$kv2R/5sGH1Llt1gpAqquFe4kKbjpzV8uhrJZ.d9FvQkhpJAqZn9pK', '0', '0', '2018-11-03 00:50:12', '2018-11-03 00:51:49', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4435', 'VanessanefCZ', 'Vanessanef', 'zen294@taidar.ru', '$2y$10$qVdBb6.33T9XX7bgDVd6Bub3qFoM8CxAD0rkxMn5ygwE/NHoFl2HO', '0', '0', '2018-11-03 20:18:33', '2018-11-04 13:50:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4436', 'TenishaLatHH', 'TenishaLat', 'artyomlytkin1999604nu3a@rambler.ru', '$2y$10$dS4a3rwR6PrKcirNpfqYvOyTbUxmseMPfRg1lV90ljm8OKUW0rtBm', '1', '0', '2018-11-04 08:16:50', '0000-00-00 00:00:00', 'eb9553f588e76e77b42c212ea873b9ff', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4437', 'Timothy Pippin', 'timothyp62', 'timothypippin@hotmail.com', '$2y$10$LzflZYjfl0ZXoRg/Ea.I8.COYvEQLkwiNiV4K1.BLBYPoR.MTPK36', '0', '0', '2018-11-04 08:25:19', '2018-11-04 09:01:38', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4438', 'MichaelCafSF', 'MichaelCaf', 'vkskyt@dertul.xyz', '$2y$10$uiYsOISDciz1SlQpNujzXe8.OxL3uvT4gM5A7qKmG1V.sRlIyY/YG', '0', '0', '2018-11-06 04:33:21', '2018-11-21 12:59:47', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4439', 'AjasoninagoFN', 'Ajasoninago', 'slupskradcaprawnyy@mojxpocztar.poczta.lolekemail.net', '$2y$10$O4LV8onH3VictkHKkjX6POlRAxLiyUIRvj5gs0HwOZwJ3XnPKc70q', '0', '0', '2018-11-06 04:41:17', '2018-11-16 02:05:49', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4440', 'AracelivadlyWR', 'Aracelivadly', 'zen295@taidar.ru', '$2y$10$QDSyVQc.j7xmunQvF/1LsOttJhvI8gXwx1WBQqQY7kKCAB3mo1nGS', '0', '0', '2018-11-06 05:43:30', '2018-11-06 06:16:24', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4441', 'AjuniorDopTK', 'AjuniorDop', 'uslugiremontoweslupskkk@mojxpocztar.poczta.lolekemail.net', '$2y$10$Ohl/fa/OSG.fdKWadl.j4OyQQGoEgaUPHSc4Z8mxICwITKK2SyZJS', '0', '0', '2018-11-06 14:59:02', '2018-11-17 21:53:28', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4442', 'ConnieVoichGP', 'ConnieVoich', 'rachelwells530@gmail.com', '$2y$10$l0NckI73Fwvuf.pU87l25egcpvJ0/5cugEybI1cEz4ZBVq9plcrCy', '0', '0', '2018-11-08 13:59:36', '2018-11-08 14:12:29', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4443', 'RolandNogSX', 'RolandNog', 'elliebruce15@gmail.com', '$2y$10$PQWtzLULKaw/zQtNTrybmO3QBggVw/y1OwUOIVVzVG24Se2uZxDaK', '0', '0', '2018-11-08 13:59:38', '2018-11-08 14:12:09', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4444', 'AngelasorRH', 'Angelasor', 'zen296@taidar.ru', '$2y$10$C7ekQHCjwtTZ4KMaWzw4ZOEvIB/R2eAX4Ujk6m9k7o75NUx3TzIIW', '1', '0', '2018-11-09 22:47:09', '0000-00-00 00:00:00', '20158bdfb3a6492d7fcc09c63f196015', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4445', 'MarinaSaxZI', 'MarinaSax', 'afrikannikolaev88.88@mail.ru', '$2y$10$EC90w1rZCr5qtKhsz5TSlOBqRNUtBC8VTGo8hQrSqXwiq/6Hee4gC', '1', '0', '2018-11-11 23:38:33', '0000-00-00 00:00:00', '7f8347d0a6ce06498e753e69f444bac1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4446', 'RemontVFDSPBYM', 'RemontVFDSPB', 'pilfelis@yandex.com', '$2y$10$REtK4zVSFGMm.wCtcLUe5OCv3D8NVw8ZX8DOzKwK7sdS.pLnbDUgC', '1', '0', '2018-11-13 01:53:34', '0000-00-00 00:00:00', 'aa21552eb97527223d227967117f651c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4447', 'StacyCicCO', 'StacyCic', 'zen297@taidar.ru', '$2y$10$8YecWCOV/sFuxemzLNb5P./alk2FUriyRTLq9z2uf7Jgxd.3Z3K3e', '1', '0', '2018-11-13 13:53:45', '0000-00-00 00:00:00', '4fb08575ba5523706f7642ab46e6692e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4448', 'EllencekYA', 'Ellencek', 'zen298@taidar.ru', '$2y$10$gEuQpi4JAgSdLaDxdYarLegPsXTYNjWT2D7Qy9i1SgrNMLpwTZQie', '0', '0', '2018-11-17 22:45:30', '2018-11-17 23:43:07', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4449', 'AnthonyKizYK', 'AnthonyKiz', 'ruslanrodionov1999841ypkh@rambler.ru', '$2y$10$f7.jxE5pyq/bRvOODXtCYeDbiEuYkmcPaYWm3r55tsQXQSCaA2sXe', '0', '0', '2018-11-18 10:16:32', '2018-11-18 10:21:35', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4450', 'RemontvfdsspbLP', 'Remontvfdsspb', 'ewanvert@yandex.com', '$2y$10$oodzyDOGtOqSWu.th/WRAOWPVWoOiom/VDFmTbmlPyj9Np7b6W2gK', '1', '0', '2018-11-18 17:41:39', '0000-00-00 00:00:00', 'fe0ab91b15c172e86ff8649115bb3589', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4451', 'electronics - prom-electric.ru', 'electronics - prom-electric.ru', 'fenbort@yandex.com', '$2y$10$5mxaPaxZa38np3krZJsaeOwACeuoecY/Uh0R1rgmcOH7NleqA8kjG', '1', '0', '2018-11-18 20:12:44', '0000-00-00 00:00:00', 'a6fd930f329b40fe7a5e95113ea0a7a1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4452', 'prom-electric.ru', 'prom-electric.ru', 'sergfloter@yandex.com', '$2y$10$y1YGRVPDbfcfObDQUzfJx.i7jKBwvNupZavpXRsB.w..OZJapIYZ.', '1', '0', '2018-11-18 21:23:51', '0000-00-00 00:00:00', '90e848cf022b3605cefb86dd21ddec78', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4453', 'AstridmouseLA', 'Astridmouse', 'vitaliyturov19953167cwc@rambler.ru', '$2y$10$cK9MEbXyC6Qj/j9ZZfVyv.zj63J8qhusEwCyThScLSEquJgepzne.', '1', '0', '2018-11-19 23:44:43', '0000-00-00 00:00:00', 'bfe61d16fbb93410401cb6c08d2d285b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4454', 'Sherrie Andrus', 'sherrieandrus14', '87296molen@gaterremeds1975.eu', '$2y$10$kfhewkrVi6rhkrhWQhYJm.mWF5acP9jKs4NIYdDS0HYgTmysfB3Q.', '0', '0', '2018-11-20 09:52:33', '2018-11-20 11:32:33', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4455', 'Veta Barbee', 'vetabarbee62920', '80361rygg@centnetploggbu.xyz', '$2y$10$z4sBOxgJRouix460WikYIO1Ers0kuCX6uu5ysPwG9gsNh9AIHIzGW', '0', '0', '2018-11-20 11:22:15', '2018-11-20 12:11:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4456', 'Shavonne Whitford', 'shavonnewhitfor', '18348chabaud@enercranyr.xyz', '$2y$10$XX/cB.I.Ld0ICiJEwFjbnObk3qA8YZKGRw4F7bX/TQkpmnRnEOezK', '0', '0', '2018-11-20 11:23:00', '2018-11-20 12:17:34', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4457', 'Oliva Bourgeois', 'olivabourgeois3', '7621apker@gaterremeds1975.eu', '$2y$10$lHk9RMx91QXgukU9W0HS7euA8lBtnRstHjuPWDCoZvC5f4geJtKvy', '0', '0', '2018-11-20 12:04:57', '2018-11-20 14:23:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4458', 'Lenora Knowlton', 'lenoraknowlton', '76719arre@acnebrufolirime43.eu', '$2y$10$06MT60BDPSVvvpNNUz3.LefJK6bPLsOtAG5b3nKgDmX/EJAtV4QMW', '0', '0', '2018-11-20 12:50:04', '2018-11-20 14:32:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4459', 'Ashlee Marshall', 'ashleemarshall', '23104sayne@gaterremeds1975.eu', '$2y$10$TWOdikPPD3LfvQtgSrxDTuotX7V8Fjy5WbU/4xBFkmm.bKipN/0OO', '0', '0', '2018-11-20 14:39:54', '2018-11-20 15:12:48', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4460', 'Abdul Lemons', 'abdullemons7485', '83417bleser@concetomou.xyz', '$2y$10$xHfD.Tbs3UASyuhRcldZwOLgiP/D16cpvYTsihUECHCKabHQWeYuu', '0', '0', '2018-11-20 15:02:59', '2018-11-20 21:15:41', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4461', 'Luigi Hollingsworth', 'luigihollingswo', '30135sentz@acnebrufolirime43.eu', '$2y$10$Cv0JD5.zuhpXUEl93SNYJe.3OgmKr5EWIP1LXDa3NTECRI75RxLCW', '0', '0', '2018-11-20 15:22:46', '2018-11-20 15:53:27', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4462', 'Zac Riddell', 'zacriddell60164', '8639trebesch@gaterremeds1975.eu', '$2y$10$Hq4rchVxsb6TTdwefs7tlOlPtWJXvs6E3stelsLFERfFuYnWowL3S', '1', '0', '2018-11-20 17:14:11', '0000-00-00 00:00:00', '1fea1417873fe54c6064c2a4e32a7080', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4463', 'May Zick', 'mayzick6495043', '58868mautz@enercranyr.xyz', '$2y$10$ld1hRXCOuWtgfinD7KTv1.rJEhw6ZFQ1mljD91L7c5elqeF.BAoW2', '0', '0', '2018-11-20 17:14:22', '2018-11-21 00:05:05', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4464', 'Hugo Gillette', 'hugogillette584', '51677merganthaler@centnetploggbu.xyz', '$2y$10$S0sn95/caVaOkvj0KwjWc.XdULVlaSMxrPbUqdJrCse9GkdmZkW4e', '1', '0', '2018-11-20 19:08:46', '0000-00-00 00:00:00', '3f8954f73dc6c25bfc732f5b472f9070', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4465', 'PeterloazyBX', 'Peterloazy', 'ajitsura@list.ru', '$2y$10$mFZEsHDURvGxmRQaB4T/xuUQsr3sl.QeDV8/Xrk05ixQPCfy/dKeO', '1', '0', '2018-11-20 19:12:44', '0000-00-00 00:00:00', 'b95af2a91909db77e165ea428e203d43', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4466', 'Carissa Sisk', 'carissasisk109', '74398laflen@erexcolbart.xyz', '$2y$10$dIPeMsGfonhgvc9rpX4xJeo.4Vb9/OUmVfZBjhb1uMDFtgKLGb3my', '0', '0', '2018-11-20 21:17:44', '2018-11-21 01:47:08', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4467', 'Raphael Moorhouse', 'raphaelmoorhous', '29980zacharewicz@concetomou.xyz', '$2y$10$R1gJxH/Mr9JYqXqOSEGfyuhJsZDx/D60uIKelYEwn/Pw09Ff4MWpW', '0', '0', '2018-11-20 22:09:30', '2018-11-20 23:00:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4468', 'Leora Lorenz', 'leoralorenz8442', '25771molz@compscorerric.xyz', '$2y$10$37eT3dmeBowUumkFjEXYy.n2AvLI12yYG6x/p1hnJmo9NTS/T2d2m', '0', '0', '2018-11-20 23:01:57', '2018-11-20 23:40:51', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4469', 'Benny Deeter', 'bennydeeter3663', '84294haynesworth@towndewerap23.eu', '$2y$10$8miypO4BieU7BJZVJGQmPujcL.2PHTm7JOaNAkXF.4K/iabQBZApi', '0', '0', '2018-11-21 00:24:22', '2018-11-21 00:46:20', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4470', 'PopkajugPJ', 'Popkajug', 'support@kwork.ru', '$2y$10$myskjrTYW6Mmfyb.lTFFXuZ2Qjze72FnzzjJJTKSBFNgfdk0LvLeq', '1', '0', '2018-11-21 00:44:57', '0000-00-00 00:00:00', '3cd039fbe76cec87b2519083164beda2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4471', 'Caleb Harvill', 'calebharvill271', '76414ruhland@analenfo111.eu', '$2y$10$2YxEu50gMgKpvJM0N0fc/.MASCbwGJnPfptx76rDXtI2ouXTsZMbO', '0', '0', '2018-11-21 00:55:27', '2018-11-21 01:27:31', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4472', 'Uwe Pabst', 'uwepabst7229602', '76414ruhland@compscorerric.xyz', '$2y$10$xDhGm2gniAf9BUeUQQhDrezepw.7QDM9Kz56hIe2tR7S0CmoGFTlC', '1', '0', '2018-11-21 02:30:14', '0000-00-00 00:00:00', '65c0191b2ebd62bbcd7d8d6abe6a9873', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4473', 'Garland Charette', 'garlandcharette', '20408larman@erexcolbart.xyz', '$2y$10$MXxl55qmhlLKMKFY4/l6Fe937a2DMNRUC5lKdD7h9RvQGJtKXgu7.', '0', '0', '2018-11-21 04:12:31', '2018-11-21 04:42:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4474', 'Beryl Brinkley', 'berylbrinkley2', '82619randall@acnebrufolirime43.eu', '$2y$10$gMRmP/Q45rX6YIV8Xt8N.efIeO9VEXA5rn6NPvPcPBA/XRr6B6qSW', '1', '0', '2018-11-21 04:46:25', '0000-00-00 00:00:00', '229b1808ab655f1c340ca727f7f1096f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4475', 'Annabelle Edkins', 'annabelleedkins', '21612benyo@analenfo111.eu', '$2y$10$aWGtNCAGaYNRr/LN4h0tOeH/th/AElXrcWo8oDTec9JfyxzBlH82O', '1', '0', '2018-11-21 05:02:34', '0000-00-00 00:00:00', '15d4e7698496abe47dfaa4fefa620f97', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4476', 'Tracey Strangways', 'traceyrnk15050', '73749teehan@enercranyr.xyz', '$2y$10$iW0CSZBq/N8kQ9H/L3WaCOgSua/XWyR.6U2Kay2XG1WWLqb8KYMCG', '0', '0', '2018-11-21 05:28:01', '2018-11-21 06:03:04', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4477', 'Melvin Fix', 'melvinfix97110', '62831tonne@concetomou.xyz', '$2y$10$hLW/g2muCBnMFMBVcbUxfOfw1K3aU95pcQ9TFPDt.Al00J86mIdZq', '1', '0', '2018-11-21 05:40:00', '0000-00-00 00:00:00', '46e4f97862623677c2329caca6da08c8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4478', 'Wolfgang Colechin', 'bjuwolfgang9375', '76414ruhland@erexcolbart.xyz', '$2y$10$rzOlL3xKgllyGrpgYm8kB.9Eee6iumG8y/34UxwmYCiChtfpwEUa2', '0', '0', '2018-11-21 06:10:45', '2018-11-21 06:48:52', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4479', 'Huey Kingsford', 'hueykingsford25', '20867hagler@enercranyr.xyz', '$2y$10$LaHbPKQOOzJftC6G8y8WD.JFVkdMiyVB1qMGMeQhkjFCoBSHX2fU.', '0', '0', '2018-11-21 06:54:30', '2018-11-21 07:55:59', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4480', 'Caleb Stroup', 'calebstroup6557', '58075badon@erexcolbart.xyz', '$2y$10$0iWcFHTpNXdojbT2TopeCeFzAcBOU.cX9k0/pTjvoQKqqg8xms8V.', '0', '0', '2018-11-21 07:48:19', '2018-11-21 08:02:27', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4481', 'Mackenzie Giordano', 'mackenziekwv16', '76719arre@erexcolbart.xyz', '$2y$10$ZYIagOnZOTbkzcCRWqRXUeLexmm2UWr7/UcAgHOkuk5omhiWIr6vq', '0', '0', '2018-11-21 08:18:09', '2018-11-21 09:00:38', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4482', 'repair - prom-electric.ru', 'repair - prom-electric.ru', 'solreddit@yandex.com', '$2y$10$JcohNv8sRvSrhD0bCxXD0eKonfZOW9p5NcPJAxj23.TV98hitzB6C', '1', '0', '2018-11-21 08:42:17', '0000-00-00 00:00:00', 'abeda2a32f19a648a74ed2e13b97abfb', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4483', 'Tahlia McCabe', 'tahliamccabe43', '73749teehan@towndewerap23.eu', '$2y$10$rBwVBDGxUFVcUxpRhVMQK.s6/lv2OJ8vE/26VydUBIFT7mXVcsIj6', '1', '0', '2018-11-21 08:52:58', '0000-00-00 00:00:00', '3f152a1148a264c7f9e455d76122ec63', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4484', 'Veola Astley', 'veolaastley0353', '62833nieves@enercranyr.xyz', '$2y$10$U8JWqNaa0XySxd0y6oH6ceBtcoKwkD3yTiiPJvbcbZILH5v42PUTK', '0', '0', '2018-11-21 08:54:04', '2018-11-21 09:38:22', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4485', 'Lettie Kippax', 'lettiekippax72', '25771molz@erexcolbart.xyz', '$2y$10$uGvZI9jDxS551rp3U/uPxep6oOjW4IhrmmnwS/QypQ2U.y6cvDom.', '0', '0', '2018-11-21 09:29:29', '2018-11-21 09:56:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4486', 'Carol Peter', 'carolpeter77780', '82266koczela@enercranyr.xyz', '$2y$10$C6KzUBYvzqpsVlp27qITgeCH.A4RB9OJVeJpG4hHofHn5gpUCAm6y', '0', '0', '2018-11-21 11:10:14', '2018-11-21 12:29:12', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4487', 'RachelThagoDD', 'RachelThago', 'zen299@taidar.ru', '$2y$10$Af9EMusl1CvO6RoqXwiN9.kiE5RIcxY9hGXIJ6tabPl7qylCSVsCu', '0', '0', '2018-11-21 12:38:35', '2018-11-21 13:10:06', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4488', 'Milla Aiken', 'millaaiken5729', '28357lahti@enercranyr.xyz', '$2y$10$92eTqIH.ppZneyQIQJFz1.qKsCzqgb4jaVN7dJpMDUsdDy.RcGMki', '0', '0', '2018-11-21 14:38:13', '2018-11-21 14:53:07', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4489', 'electronics repair prom-electric.ru', 'electronics repair prom-electric.ru', 'furymac@yandex.com', '$2y$10$1.37KEcyVgu2ioV.BtMCdOIZLv0bJIOIHlj/oERxwPjYWdgeAIMMG', '1', '0', '2018-11-21 20:10:46', '0000-00-00 00:00:00', 'ac8099cab4b6974b1978ae1ff65c0370', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4490', 'control panels - prom-electric.ru', 'control panels - prom-electric.ru', 'benwhiter@yandex.com', '$2y$10$9kAo44XYJcihH2FNP300N.kFPG9DMzlh4cn0YA10Ufa0q6bg0A4kG', '1', '0', '2018-11-22 06:43:33', '0000-00-00 00:00:00', 'b771d80c854bfc6feb6955ed3881e075', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4491', 'automation - prom-electric.ru', 'automation - prom-electric.ru', 'lukdark@yandex.com', '$2y$10$AFE6FIvGaOuq.PWQ5nv1reXsNp9aoXxYzx5gI8ypOt2gZhHMj89VO', '1', '0', '2018-11-22 10:04:16', '0000-00-00 00:00:00', 'a6f7d5ad01395edf10d86ff9b1ed5cd2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4492', 'power electronics - prom-electric.ru', 'power electronics - prom-electric.ru', 'alexziker@yandex.com', '$2y$10$DKUy.28/keTmX2PblZ.Gf.yXfhCJGI5HfsD3KZpQzTO2UMvJLXCN.', '1', '0', '2018-11-22 13:07:02', '0000-00-00 00:00:00', 'e089bfc8fc3ec1ea4dc98c9ef2dcee9e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4493', 'inverter repair - prom-electric.ru', 'inverter repair - prom-electric.ru', 'kemlodes@yandex.com', '$2y$10$n9sEJOPn/7WtePnsrtOXyusuMeND6geikQ912iG538Z0uqTmhJhzK', '1', '0', '2018-11-22 14:45:22', '0000-00-00 00:00:00', '87922c82666a3455bb3a3fc4826ec774', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4494', 'equipment - prom-electric.ru', 'equipment - prom-electric.ru', 'filgreent@yandex.com', '$2y$10$MhOcAmvlXfMeTcBfaNQjsuXurq47XOSbxO9ufNEj4bV1zIStIZ0S.', '1', '0', '2018-11-22 19:57:49', '0000-00-00 00:00:00', 'ebb155cee4a49df554fdb5f4ea3def7c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4495', 'softstarter repair - prom-electric.ru', 'softstarter repair - prom-electric.ru', 'kasvikton@yandex.com', '$2y$10$dSgtkIEbf0Rid4CMKprOvuG52z5dewGDQz8AGrUA5CWIDShE.rOri', '1', '0', '2018-11-22 21:58:33', '0000-00-00 00:00:00', '752cae02f82ea34001403038d1b7230b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4496', 'LaquitabopVX', 'Laquitabop', 'zen300@taidar.ru', '$2y$10$wePtziJZh6/TU7zQeanEaeR4U/ps490YQlsxgSBLiID7Rt421vD/S', '0', '0', '2018-11-22 22:27:23', '2018-11-22 23:07:10', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4497', 'conrollers repair - prom-electric.ru', 'conrollers repair - prom-electric.ru', 'zakvurry@yandex.com', '$2y$10$HtBKkFnM9rIjPZRDeA1VX.fJfYIqn3wN3movGjs8Tglt9AvEgWzzG', '1', '0', '2018-11-23 09:41:26', '0000-00-00 00:00:00', '78cf6bc1f1a2762d2bfcf4b8018c1650', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4498', 'equipment repair - prom-electric.ru', 'equipment repair - prom-electric.ru', 'vikgeorge@yandex.com', '$2y$10$JJsOiq84R196gtdhbta7hOQ9LDJdttfcCvQRQ/jOpz/rnOl4Cv4QO', '1', '0', '2018-11-23 09:52:13', '0000-00-00 00:00:00', 'dce0e9223bfa53278f5cac07e04e85a2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4499', 'CaseyCobXF', 'CaseyCob', 'nhqdhq@dertul.xyz', '$2y$10$4j6Gh6tbkuMQR4RDceeWqunr8xuQzKF81bkfSz8MGZU/MW4zLhUqC', '0', '0', '2018-11-23 12:39:08', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4500', 'remont priborov - prom-electric.ru', 'remont priborov - prom-electric.ru', 'filzilk@yandex.com', '$2y$10$AtyASYvFwa70RhIcAkMace3Umr9.bcS9FiqSM7LPv3juLrLYYJt7u', '1', '0', '2018-11-23 14:39:00', '0000-00-00 00:00:00', 'c039ea7ae38bfdca3fe258dc8a7e0833', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4501', 'conrollers - prom-electric.ru', 'conrollers - prom-electric.ru', 'wilparis@yandex.com', '$2y$10$M27DKhkEL5bxFAsl1A8mfOVWlhgqU9EL8Qey.5hBKXS5Zo2TOkxl.', '1', '0', '2018-11-23 14:39:47', '0000-00-00 00:00:00', '4c106e1a73e81e7dcefb77ea6dd026de', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4502', 'remont priborov spb - prom-electric.ru', 'remont priborov spb - prom-electric.ru', 'mikdopler@yandex.com', '$2y$10$xg17uEzKWyjVcocWVdAX6OnrYq7NJ0mVoaWXAcMw8wN0D2sWaSjwi', '1', '0', '2018-11-23 20:48:25', '0000-00-00 00:00:00', '0c34c9368d4bf794e56d52523c2da73e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4503', 'mcu - prom-electric.ru', 'mcu - prom-electric.ru', 'dinserp@yandex.com', '$2y$10$wTQD3rGGFXzT05jvom7RY.y0/1VX0IIILmOQ..Jz0akVSAS74dui.', '1', '0', '2018-11-23 20:50:53', '0000-00-00 00:00:00', '1b236c3f7f38b604a83e8fa70f9475d8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4504', 'remont cnc - prom-electric.ru', 'remont cnc - prom-electric.ru', 'renbasic@yandex.com', '$2y$10$yUYHd7vpsfSxe9mn6lVIn.Hc2TI/03RuIOSb4wJfJvc4y6vlDOzk6', '1', '0', '2018-11-24 14:21:59', '0000-00-00 00:00:00', '781a664d58600f5153bb2fab4ee7b668', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4505', 'pcb repair - prom-electric.ru', 'pcb repair - prom-electric.ru', 'bendivov@yandex.com', '$2y$10$HC2FhWRmvsZ8qzIqYh1VheM946PAM2.rhkjd5fxX4olKKlvXlJwNi', '1', '0', '2018-11-24 14:22:06', '0000-00-00 00:00:00', 'cb0a392a67a0afcad4f3f750b5828ed2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4506', 'cnc repair - prom-electric.ru', 'cnc repair - prom-electric.ru', 'bilkirk@yandex.com', '$2y$10$Nkfp7GB9u9TsyQ8aWmWIrOq/rXPC9fMseNPqkQGqNaUyGzZExj0x2', '1', '0', '2018-11-24 19:32:17', '0000-00-00 00:00:00', 'a8b94abab54e73b9e98b2613e1ff1f6c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4507', 'machine repair - prom-electric.ru', 'machine repair - prom-electric.ru', 'lemkrown@yandex.com', '$2y$10$wVivnJ5J9d2jentsnUdNHetFYkMd8w4jDdn.9aTThKFvPqH.vysj2', '1', '0', '2018-11-25 11:01:28', '0000-00-00 00:00:00', '41e58ac18f82042a94958613f34f6a31', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4508', 'plc repair - prom-electric.ru', 'plc repair - prom-electric.ru', 'binhexter@yandex.com', '$2y$10$AWDXJDDFEqqTDc/mYfgm4.Z5UZ3syxhnO43L3LhYYdhtN1dyOo/fK', '1', '0', '2018-11-25 19:57:30', '0000-00-00 00:00:00', 'b22325b0e6acfd3f8c958fded7144d16', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4509', 'caurFiliRM', 'caurFili', 'pithamer@yandex.com', '$2y$10$uYy7HB8KZFK5MzDvCmj/SOFbNa4Voj4eowuHDm8PwrK8vEcUPlylS', '1', '0', '2018-12-18 14:08:59', '0000-00-00 00:00:00', 'a7b15ebbcd592d083033d81bd8e5c9ba', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4510', 'PalosDricadotoTI', 'PalosDricadoto', 'pb5087206@gmail.com', '$2y$10$GERRmQzBPNWviiASO4f07uP2rD54JDeONobW.Jl05msh89WEZ3ny.', '1', '0', '2018-12-18 21:01:08', '0000-00-00 00:00:00', '7032198d8e929c9f3a32cf9c64d77678', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4511', 'Porn Dude', 'PornDude', 'lisa.asti48@gmail.com', '$2y$10$b65nXCNxwlV/Sv8vfLgM7eKhYo44Hu88exZPhsuY1unPgPWIFB.cS', '1', '0', '2018-12-19 04:00:22', '0000-00-00 00:00:00', '3f5ada68cbeeccdb406b655e16b43789', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4512', 'MelissaMahWE', 'MelissaMah', 'zen310@taidar.ru', '$2y$10$IqTg0a5zpgZsODfrwBg4BOw8132YF7UkbUb9XJYgWytFHvPew.Q.W', '0', '0', '2018-12-19 21:26:56', '2018-12-19 22:37:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4513', 'DimitarHarOBE', 'Dimitardoca', 'izabella.lozhenko.1974@mail.ru', '$2y$10$HXM/F3qRHtbyBA2EqmknRuzLavK4xS6jL0yGDaUFJ78w57dHGlCVi', '1', '0', '2018-12-20 10:22:20', '0000-00-00 00:00:00', 'ca727c46fe54a6d2f1eeb3381b993d71', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4514', 'MarikOlNJ', 'Marikmak', 'sveta.koptilkina.1981@mail.ru', '$2y$10$aZpkkFJTLv2e0M6yiHf3b.vRTlHlSJ/5LlGOhHi8HEwHCjXsCoycy', '1', '0', '2018-12-20 12:03:23', '0000-00-00 00:00:00', '6f95faa981a4105da85e4c4019056011', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4515', 'deedewenhorAO', 'deedewenhor', 'trasintre426@dtdns.us', '$2y$10$zizRDg/ykONo6EQ6cGaTL.eiBlqQuc67UyT/ODYHjFYPfvrCgG6Ca', '0', '0', '2018-12-21 00:48:52', '2018-12-27 00:18:10', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4516', 'LucilleiteseKY', 'Lucilleitese', 'zen419@taidar.ru', '$2y$10$czhY0TPoP0Pp0dpfVlnaMu2K8AcyeqN62Zn7ux4o.C9xQSoDtsmBq', '0', '0', '2018-12-21 05:05:06', '2018-12-21 06:22:23', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4517', 'DennisvemKD', 'Dennisvem', 'ktpvn410@gmail.com', '$2y$10$mRRlKBAuIx4ZT7aJ7zMzLOg.xwY7FFWpOSd.5KNXeylNGKlPpH6/u', '0', '0', '2018-12-21 16:44:42', '2020-05-05 01:48:17', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4518', 'Шлюхи Уфы ', 'Sxuaffaet', 'ufasx2112@life.tw1.ru', '$2y$10$Tkebqo7cci3UNYihmHgieenPgzaFEBHCoxzG5xCiEw5.3NohO2Dti', '0', '0', '2018-12-21 19:04:20', '2019-01-07 19:18:44', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4519', 'xzusaymebtdvzyfGP', 'Universalcqc', 'keytahersell@hotmail.com', '$2y$10$AQjbcxllEjXZdCjdNSWmpuqSFfU3kowMzwIFddGmXMp1LBUNGFo/a', '1', '0', '2018-12-22 06:11:24', '0000-00-00 00:00:00', '47bde998933acd4ff04ef56db4a852ce', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4520', 'yulya.ferencVT', 'olimp.rus', 'grybovsergey88@gmail.com', '$2y$10$xP7ztOgxSohfVanDndAfpuIL6tf/gI/pdlWHxNZiwzlfF00nJfQUO', '0', '0', '2018-12-22 06:30:15', '2018-12-26 18:09:33', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4521', 'KevinburceVX', 'Kevinburce', 'tristysigns@gmail.com', '$2y$10$2rNFseaoiEx2dNKUmtk8JOFdfDfTRg7Bx6b9p31xOOH3HtWgeZqBC', '0', '0', '2018-12-22 18:13:32', '2018-12-24 16:56:09', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4522', 'ShanellVotXG', 'ShanellVot', 'zen311@taidar.ru', '$2y$10$sRp8Qd5inN/5vLpftoXI3uVQEm4m/1xJcZBv1CjzZCF2NLz5.r6gi', '0', '0', '2018-12-22 18:17:56', '2018-12-22 19:29:47', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4523', 'TamikavedUJ', 'Tamikaved', 'zen420@taidar.ru', '$2y$10$hrWxonwqbz8Iv2mhcoWneOHvFAflqzhafSw1Ctg58y8a61AHWfye6', '0', '0', '2018-12-24 08:14:54', '2018-12-24 09:18:28', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4524', 'vanes_83\r\n5CY', 'galimovansel5', 'koptevandrey88@gmail.com', '$2y$10$mC9QgW/sJ45vSNl04Mqyx.ftTRMNtPpI0FH8qj4bDBgiw4mOcsy6S', '0', '0', '2018-12-24 16:10:31', '2018-12-24 19:36:16', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4525', 'EssaystudioHB', 'Essaystudio', 'tim4enko.ilya2018@yandex.com', '$2y$10$Z5Lx4bGDWMMmrTSbk8wchuXb/nWghjVQm.29lHj4wW41dJp1TPS.q', '0', '0', '2018-12-24 17:17:42', '2018-12-24 18:43:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4526', 'DudleysafWH', 'Dudleysaf', 'profiplast-22122018@meta.ua', '$2y$10$2fFGmBJeEyY2xozUgBhkh.mce9kmnVyVZi6PsROF1hA7UtGbWskkG', '0', '0', '2018-12-24 23:39:00', '2018-12-30 10:40:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4527', 'CarolsmuffTZ', 'Carolsmuff', 'zen421@taidar.ru', '$2y$10$gK37iZ9xUYVs/G4Z.ajEWuZtubB/5NzpMXauHqCymKuXDR.AKUTCC', '0', '0', '2018-12-25 02:12:30', '2018-12-25 03:13:43', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4528', 'GilellVX', 'Gilell', 'dwtgxm122@mail.ru', '$2y$10$ucpRXJpd1WaPNLYU4upaEuNfNCa.XQCb23dr4mRwBQSrDf/NZuC8a', '0', '0', '2018-12-25 10:13:04', '2018-12-25 10:13:21', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4529', 'Essaу writing service http://7gw2018.trade/essay.php invite №8321295', 'Essaу writing service http://7gw2018.trade/essay.php invite №8321295', 'heks@a0g.ru', '$2y$10$HVyLMX735H1T0pAbhpnD3e9gLvu1/uTK3j5fCxrQCB/z.e6v6QEK6', '1', '0', '2018-12-25 11:23:55', '0000-00-00 00:00:00', 'b6ce87c5d153130da74b4f0f3467bc76', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4530', 'JustinDapNC', 'JustinDap', 'gevorgchaturan77@gmail.com', '$2y$10$y52zj2WQkB5RL5d5zURXQOVKEQGPh06OS09JU/6dgEZm8TqvJMP92', '1', '0', '2018-12-25 20:18:50', '0000-00-00 00:00:00', '26f4d4970401d638a89e7c0871cb05a6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4531', 'CarlosMexZW', 'CarlosMex', 'fame@famemizik.com', '$2y$10$7IcdGYeDWyh3dsP0Thz/NePoHv28Z17OopDoxUtXKQrHhiRRxuUNu', '0', '0', '2018-12-25 21:19:39', '2019-01-05 00:07:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4532', 'cekIQ', 'cek', 'alys151@mail.ru', '$2y$10$YuNw.TOTU88m56DhW9UQ.eWDkRCi2kpe0W0snE5uI/Ovd/qlLDJxS', '0', '0', '2018-12-26 05:40:56', '2018-12-26 05:47:01', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4533', 'RobertScumnMA', 'RobertScumn', '19102018@betiforex.com', '$2y$10$aUcCyKbB2WRg4w.EEOJaUeo6az81Zm/nbTKSVYiO/hOQrkF00A5sa', '1', '0', '2018-12-26 15:36:54', '0000-00-00 00:00:00', '2d7404680d6ef726111f8e4eebc1db0b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4534', 'LusleyanapyWD', 'Lusleyanapy', 'pavlovadina263952@gmail.com', '$2y$10$4tvZcmgf3jfURrrv24SyHu54vsesPJ7JbvYQULBt40zFmEI.YoX62', '0', '0', '2018-12-26 17:11:26', '2018-12-28 09:53:55', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4535', 'JuliaRhyncDK', 'JuliaRhync', 'zen422@taidar.ru', '$2y$10$ahF7HJ4EPvui5w283V8Oy.8ytjUXruAyDR3Ee7.wkIvCOSXaRQJIq', '0', '0', '2018-12-26 18:07:30', '2018-12-26 19:15:17', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4536', 'lalala_789IM', 'guzkpc_kdo9', 'putyanhinvasya@gmail.com', '$2y$10$Mtmwvs79qKkcr1sJin/qmeBDJ9mYUaNbR/6i/Ak3OB92Wierd2ke2', '0', '0', '2018-12-27 05:44:54', '2019-03-03 22:47:43', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4537', 'Essay Writing Service', 'Essay Writing Service', 'vera.popovaua@yandex.com', '$2y$10$qEDilz316Otfry9RtcWuEO83U8DPU2dP3zoz16ZIRkpI7zp9ibZWO', '0', '0', '2018-12-28 12:47:15', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4538', 'MinniejoyncTI', 'Minniejoync', 'lav.lavana@mail.ru', '$2y$10$VJI8VKycWosdM31.5/JmIed/6uAWlW/uPqnR.327aa9J3YU1.tiYu', '0', '0', '2018-12-30 11:58:02', '2019-06-06 01:07:15', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4539', 'CaroljamXI', 'Caroljam', 'zen312@taidar.ru', '$2y$10$7TPFTgu57ZGt7YjJ2jgwruyb.Wot85zpvkg6EmCq/Qcj16pJ0NrzO', '0', '0', '2018-12-30 12:35:13', '2019-01-06 08:36:16', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4540', 'RobertFakSF', 'RobertFak', 'wvwiym@dertul.xyz', '$2y$10$3qk530GS10a.6yILq/Hl5O6AaTIFSpeoOYnNsTY/YMOLL3RHz4/4i', '0', '0', '2018-12-30 16:20:11', '2019-02-16 04:55:36', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4541', 'gofBW', 'gof', 'nl151@mail.ru', '$2y$10$e.r4xPeixDlkrGEqAs0EjuAm4Xw8KZ7l7qywUhb5yl5xdFeyp3q2K', '1', '0', '2018-12-30 19:31:08', '0000-00-00 00:00:00', '14d56399c224db4c17cf6b4abd75b596', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4542', 'VitaliyqueptNP', 'Vitaliyquept', 'realtycomgid@gmail.com', '$2y$10$GICQ3Jjq7L5V3XIGH.b91.XTVbe2l8DQHuTFB/ZoMOgXaV3dZFm72', '0', '0', '2018-12-30 19:42:26', '2019-01-02 07:15:06', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4543', 'BrEeksMK', 'BrEeks', 'arlhe1025@list.ru', '$2y$10$V8VMcVPThyBejypWhbcGAuT2zIV6Ie83M99cH8R0axKZHOoiKBQue', '0', '0', '2018-12-31 14:47:36', '2020-02-24 20:42:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4544', 'Andrewmealk1AG', 'Andrewmealk1', 'ib.la.c.k.vlas.te.lin@gmail.com', '$2y$10$LoWWFh9nf7OV03O/o5Oy3u66X0qM5QPznAkRuAnrjH5K37N4u/7Jm', '1', '0', '2018-12-31 17:30:06', '0000-00-00 00:00:00', '8f189256b88ed835494f644f59100813', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4545', 'AphilipSkymnAZ', 'AphilipSkymn', 'kunststoffpalettenfff@mojxpocztar.poczta.lolekemail.net', '$2y$10$tMphWJT7WV5WQ0FTAvL8ie5PrNzNjD7gFcmMqEF0yi3ePDgQJLXuO', '0', '0', '2018-12-31 20:42:19', '2019-01-05 23:35:48', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4546', 'SarahfueraWO', 'Sarahfuera', 'zen313@taidar.ru', '$2y$10$j4hRARyAssHr3Iv2DALmd.1Gyg6tjpHja1Gs5xZ4YH5pjfICggtZe', '0', '0', '2018-12-31 21:15:03', '2019-01-06 22:04:47', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4547', 'MelvinSworoKG', 'MelvinSworo', 'hygienepalettenyyd@mojxpocztar.poczta.lolekemail.net', '$2y$10$57o9d4UxG/Ficv.pQ2DRA.eo5YRVB6fopHaFsGeEx5G4V9YkyaaDy', '0', '0', '2018-12-31 22:45:39', '2019-01-06 05:08:35', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4548', 'CrystalledayJV', 'Crystalleday', 'zen314@taidar.ru', '$2y$10$lEnWY74H2Y6jPWBlKbVZde1lwFbQ69Yd7wdNovEhZkFbZHIjMzEpe', '1', '0', '2019-01-02 11:18:31', '0000-00-00 00:00:00', '27051e3589050cbe63912c4cd9c2108e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4549', 'chef\'s knife', 'chefs knife', 'coltrene8888@gmail.com', '$2y$10$S5D5FLVpyGy/aqEsKAo26e.4Ecce2e.FDRCSgdtUZnZ4frLsoEu5q', '0', '0', '2019-01-02 22:05:15', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4550', 'Вам начислен бонус в размере 3175р --->>> https://mail.ru/wrddkfurxan', 'Вам начислен бонус в размере 3175р --- https://mail.ru/wrddkfurxan', 'dorer.1974@mail.ru', '$2y$10$sAjfuFybZSGi51sZO7t6kuHwkxeuqsj0a8jSjSLqzUSdIZUdJD7Aq', '1', '0', '2019-01-02 22:57:38', '0000-00-00 00:00:00', 'f7d9a68df08d06a284a308bcba4bf008', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4551', 'PaulaAlocaVU', 'PaulaAloca', 'paulawollfe1990@gmx.us', '$2y$10$r21bl0D9RQIkaOeIBhPx8OCZYKxRhxDU.dmXDb3sZl0nOpFtrklsW', '1', '0', '2019-01-03 10:52:28', '0000-00-00 00:00:00', 'cee9dfc229281892739b50f65ee572cf', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4552', 'DonnaFugNS', 'DonnaFug', 'zen315@taidar.ru', '$2y$10$pLAcylYB8augIFvAI8UBxu1Z6bc7Ixs5vhWpFN785Yugjk23p5Tzq', '0', '0', '2019-01-03 21:50:10', '2019-01-03 22:12:24', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4553', 'DavidsekCB', 'Davidsek', 'denisrodykes@gmail.com', '$2y$10$4XaMncAUNRmUT3nHAFzbEuTqSC7csAzsvsG8K4zJflMx1VkyQm/bS', '1', '0', '2019-01-04 02:32:27', '0000-00-00 00:00:00', 'bbfdd1ad7cd0e211bb964cfe49c527f7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4554', 'NikitatSycleRA', 'NikitatSycle', 'ppolonskynicita@gmail.com', '$2y$10$UClq9QeLVgjS4fq89gZENuloGtdJdBr/8MAGUWXnpfJUr/801H0hS', '1', '0', '2019-01-04 11:31:21', '0000-00-00 00:00:00', 'e5e067f56193b1c839c61fcee4063ab4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4555', 'LaurieNekXN', 'LaurieNek', 'netlooks@outlook.com', '$2y$10$qerM/aNd8V1Qf0QgewLoS.bEwkevwv3jTg3DqMhGAeRyV.eai849y', '0', '0', '2019-01-04 19:50:19', '2019-01-04 19:57:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4556', 'slussylyncXF', 'slussylync', 'hiry2213@dtdns.us', '$2y$10$tyTySrCyNXtXUUGUANGRlOFBLaLm22oK22.oruluYfMVduObdCUuy', '1', '0', '2019-01-04 23:44:49', '0000-00-00 00:00:00', 'bd75c73044ca3cbe50986e839c533b65', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4557', 'NicoleTrumsVH', 'NicoleTrums', 'zen316@taidar.ru', '$2y$10$d.dG.e/SkQWxb6VrwQSoEO62//EqE5VLyy/.SBYLcHoE9HnFmNERC', '0', '0', '2019-01-05 13:58:42', '2019-01-05 15:11:48', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4558', 'ProsSvetkovaW', 'prossvetkova', 'proshatsvetkova@yandex.ru', '$2y$10$LbHS78IJ0BL7p/bm3goUAuHpoe9rG6BxP3PwpH6QPO/JjKsjIO/qS', '1', '0', '2019-01-05 15:38:36', '0000-00-00 00:00:00', '394332dd1820694ac0341786a69f8b25', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4559', 'GregoryPhaseVI', 'GregoryPhase', 'mannanachalova@bk.ru', '$2y$10$MTzuhA2hY4zOA/YTKvXmPOPmdzcPYDw/ItuUL3r7YvhfYgKRHWZlK', '0', '0', '2019-01-06 06:22:09', '2019-01-06 06:27:53', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4560', 'LizBrychkinaX', 'lizbrychkina', 'lizabrychkina@yandex.ru', '$2y$10$vPvjcvHq3ejKg9DlnvXcYuy0YDZzKiaSrcFDUEOn1.oiEsWBHYB9y', '1', '0', '2019-01-08 02:45:08', '0000-00-00 00:00:00', 'b106a1a5edd6cdb5440f726fcd54d04f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4561', 'ValentaMeemoRB', 'ValentaMeemo', 'berdaris@yandex.ru', '$2y$10$wxmnxrXS3XoPVK6OZyGVduc9PLRzb6b/aqmIwLyiOj2wjsvKO8LgO', '0', '0', '2019-01-08 10:33:24', '2019-01-08 13:45:37', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4562', 'MarionchaibJD', 'Marionchaib', 'zen317@taidar.ru', '$2y$10$2cruuvOiPDFphhasxbInfe6J90U.Rx17hFwwRImxF2VopZxEcXeV6', '0', '0', '2019-01-08 15:21:14', '2019-01-08 16:26:36', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4563', 'teellaalonVS', 'teellaalon', 'hirogim7579@dtdns.us', '$2y$10$mOyQBhBgGk5XEaKT0KrrcOcHwe3skbDNpt0gHnUyPNZhRyym4sZfy', '0', '0', '2019-01-09 03:00:21', '2019-01-21 16:03:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4564', 'JamesjabMQ', 'Jamesjab', 'praskofyashumakova@list.ru', '$2y$10$drdZByl6QavPhZeJILqCOuZXMRWOEHlgZqQHZylvyfe6hpqnGVlBu', '0', '0', '2019-01-09 17:44:23', '2019-01-09 17:45:36', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4565', 'lsnezhinkinaFO', 'lsnezhinkina', 'larasnezhinkina@yandex.ru', '$2y$10$BD5GF9x.szKBt.U.DegBaeX606PlnYgG.JMiX/cHvASOnGuqbsHa.', '1', '0', '2019-01-09 21:43:12', '0000-00-00 00:00:00', 'e274ed4496cd91a557da3e0b26e79418', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4566', 'EreseSheafeSX', 'EreseSheafe', '879hirona@dtdns.us', '$2y$10$YfwwTRpLYujaXt4xBcVff.QEBZUlJR9BaRQZCBKo5nHqSBoC/kmne', '0', '0', '2019-01-10 04:57:56', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4567', 'StanleySmotaGD', 'StanleySmota', 'xlypphf3@mail.ru', '$2y$10$FpBXmtXf0yObH/LyH1i././xq9Bfm4.yZ15glXOG6r8iag4pmaRFO', '0', '0', '2019-01-11 00:01:28', '2019-01-11 00:03:42', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4568', 'MilesWouttWI', 'MilesWoutt', 'rosylova.1984@mail.ru', '$2y$10$9A8.rq.nTGhlIGZEhLAAT.jw5ZggCpDtJ7qGBss/tFapbTw/iSWdG', '0', '0', '2019-01-11 09:23:35', '2019-01-11 09:25:17', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4569', 'EdithfleleHU', 'Edithflele', 'zen318@taidar.ru', '$2y$10$cgJ3eoAZcKaV70vFxLc9R.QfKK0pWk3m.eGNElxOhzkap9hTh9nXS', '0', '0', '2019-01-11 21:34:32', '2019-01-11 22:27:33', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4570', 'MichaeledidoXI', 'Michaeledido', 'xforex.mobi@gmail.com', '$2y$10$pwYAQzL0qPpmKanG1cZFy.2xCFohxjYg.FHRrwzpviPBCtbIRQrcO', '1', '0', '2019-01-11 22:16:51', '0000-00-00 00:00:00', 'cfd6e4f01f4b15530d7c356463ebe371', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4571', 'EugeneStifyLE', 'EugeneStify', 'fxmobilf@gmail.com', '$2y$10$dthY4bf9/v341bGfmlQSCe/93qocJLf0zLDRnZ6qdvNFeAU/N50gC', '1', '0', '2019-01-12 00:57:41', '0000-00-00 00:00:00', '57c5decb2b2adbea204652285cc9d635', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4572', 'TimothyGakGA', 'TimothyGak', 'aleksejmaewich@rambler.ru', '$2y$10$L0bve.1t8WCM3T47cZ6Dv.HnWxqJ8R0g8fTZyOwNef2Ym2XxOGX.K', '0', '0', '2019-01-12 20:11:19', '2019-01-12 20:14:23', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4573', 'EstelleGlypESP', 'EstelleGlypE', 'zen319@taidar.ru', '$2y$10$4ckFCqElv/2ziaQaP/AUiupQraZWciEHDjBhTrKvq4xJMNhG8Th.a', '0', '0', '2019-01-13 04:18:41', '2019-01-13 05:26:54', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4574', 'JamesMupPA', 'JamesMup', 'rudnickayaaine@list.ru', '$2y$10$CfXCazorKQ2D3twIpsHTGuAM/qfZDQjlxESvngJem3aBEaHvp1kCe', '0', '0', '2019-01-13 10:49:32', '2019-01-13 10:52:59', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4575', 'YolandaSicGE', 'YolandaSic', 'kakkupit@mail.ru', '$2y$10$FLsFMFAMf2TYv1gjfkhESuzTnocVJcX6GUMO5z6vJxnFp1XVBD5hC', '0', '0', '2019-01-13 20:17:21', '2019-01-20 01:30:06', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4576', 'EloisaEnartRY', 'EloisaEnart', 'zen320@taidar.ru', '$2y$10$2Fzxx4cd5qR.7bk0BB/NeOF/VXDDUKZKjqVwzV0CYrz54twu3Gthu', '0', '0', '2019-01-14 06:02:53', '2019-01-14 06:39:49', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4577', 'slibiaYD', 'slibia', 'fedtelams@yandex.com', '$2y$10$sDTbtx06XaW.DfvjhsG/ROUij7lGZzt63Fzib2ss7J1Iq5Kiib/6.', '1', '0', '2019-01-14 07:40:23', '0000-00-00 00:00:00', '0790a59e644e5cebab445bdceeeca98d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4578', 'ShawntupOZ', 'Shawntup', 'temurtelams@yandex.com', '$2y$10$GuWBocj7PglL8zaBh0SGOe0ynjiHQ96gYKsVw1K.5s9UTaSSMmZY2', '1', '0', '2019-01-14 17:49:08', '0000-00-00 00:00:00', '422ba259a234dd3ef240c0e16e15768d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4579', 'JameswrachRN', 'Jameswrach', 'pittelams@yandex.com', '$2y$10$Nuzvbnk4d1PsP3bXrnvVE.HawEN8owUhShHw0b6UjgMjozTsJVTwS', '1', '0', '2019-01-14 21:53:13', '0000-00-00 00:00:00', 'a11a2e12f41a4f0fa5c556312c084c44', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4580', 'PatrickLabQX', 'PatrickLab', 'filippbolers@yandex.com', '$2y$10$8Ty.kdqYBhe6XCCeWwlytuSautUkPO24d3ydPXp/YOtFg8MU557qi', '1', '0', '2019-01-15 02:27:33', '0000-00-00 00:00:00', '1c57dcb8d8407de33c6124bddee5f7e7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4581', 'MarieDreniMZ', 'MarieDreni', 'nikiforovskijvladislav@rambler.ru', '$2y$10$A.BDzoCeaB5rJxpMU4eBqeUJZEc.ptWVsEsUQ3PCkruRThR5NPXMq', '0', '0', '2019-01-15 03:15:32', '2019-01-15 03:16:35', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4582', 'Lara Ussery', 'laraussery240076227', '30135sentz@concetomou.eu', '$2y$10$DD4ftpiHtmlpvX1H3oCIeu5RrKhFY2KblRlzv5zC/rvRuQBCp/pfC', '0', '0', '2019-01-15 07:31:58', '2019-01-15 12:50:09', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4583', 'RichardGlornCR', 'RichardGlorn', 'denis.doker@yandex.com', '$2y$10$UAEcVfe4.gZB3lxM8JSDv.aBEH0oIUnRlMufbC4NGDgU7IJjFw/Xq', '1', '0', '2019-01-15 07:57:31', '0000-00-00 00:00:00', 'fb31bf551b0a0918e26860ce46dc5208', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4584', 'stasmiks5lOH', 'maksimo-19705l', 'shamrykenkokatya@gmail.com', '$2y$10$4nslm.S/xqXF5SVTp3JjVOm8MmazUX0yVtaZfm3PWSTP61LnYmv2K', '0', '0', '2019-01-15 08:04:23', '2019-05-16 05:09:10', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4585', 'DarnolljepPB', 'Darnolljep', 'rikgersen@yandex.com', '$2y$10$6L9ZqeyAGM.w8VWIDDx8weMLRFwP5ax82hddeGHDMXQvCImVjt53G', '1', '0', '2019-01-15 19:50:56', '0000-00-00 00:00:00', '32eb8dc74c9e66a54e4e8fb00b023d99', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4586', 'szusalmeztisxveGP', 'Rigidvqc', 'minviconmi@gmail.com', '$2y$10$15gmOscFzBNoZDqzWeUerejeViCZkvJH0Iw2rocHhbHMDTXnHJJc6', '1', '0', '2019-01-16 14:08:07', '0000-00-00 00:00:00', 'a57f42bee359b6a2ac86ae844d0037f7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4587', 'DionneresLZ', 'Dionneres', 'zen321@taidar.ru', '$2y$10$3Hls.ozGfraROznvFzmggezDMNM7uY5nQOGarO5Dg1eCVSeO.BuVu', '0', '0', '2019-01-16 16:20:36', '2019-01-16 17:19:35', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4588', 'DanielLixPO', 'DanielLix', 'bezhan.94@bk.ru', '$2y$10$fuaAhV5PSu5Gwhha8gFgSew5BCejnLaDs97YfNlizcFHRBBj8avzy', '1', '0', '2019-01-16 22:33:25', '0000-00-00 00:00:00', '6c20ba4628fe2c8b664b348dffab7da0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4589', 'immessyWU', 'immessy', 'weaoz1014@bk.ru', '$2y$10$y3docQVGtGrU.ejmCEUnquri8NfMu8QYpHqAyhYpUi8o4GlcStZz.', '1', '0', '2019-01-17 02:24:13', '0000-00-00 00:00:00', '7260254710e9a7ed9e66b28bd26aafaa', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4590', 'JameshotGV', 'Jameshot', 'kolmogorovabiddi@mail.ru', '$2y$10$JdB11A5RN2C7dOhzvmWV9Om6EnCwKLICCrKmwsnsHwfVbvfmfDZ4q', '0', '0', '2019-01-17 13:34:49', '2019-01-17 13:38:21', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4591', 'ZontidinimicrottAS', 'Zontidinimicrott', 'zonti@post.sanok.pl', '$2y$10$aewH5eb3YwTf5tNc9WnSg.ADNaXlkzXXMRm2f91ykh1f3VtNRsQZ.', '0', '0', '2019-01-17 13:44:46', '2019-01-17 13:47:40', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4592', 'DebravogJF', 'Debravog', 'nadyafloranskaya@rambler.ru', '$2y$10$vtijUZaQ6KLR82tf9HghweNj1S6LGbKDX2d3DdGcwWr6ftZXt9JZO', '0', '0', '2019-01-18 17:31:11', '2019-01-18 17:33:54', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4593', 'NickolaiTuruI', 'nickolaituru', 'nickolaiturunov@yandex.ru', '$2y$10$OI9IPN.zeLYFRrsYby78EeUx8Uao8ygO3DofG4DkJcV463MuDajZy', '1', '0', '2019-01-19 10:29:31', '0000-00-00 00:00:00', '13c26792103106cf8d7dbd1871602fda', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4594', 'DmitryIETU', 'NikolayWW', 'leo.lemers@yandex.com', '$2y$10$QxNHRVsPn3Y1qLCbQ4v5w.UrMmiv.AkybBD7zYgYSwcIjVu0cmOha', '1', '0', '2019-01-19 19:57:27', '0000-00-00 00:00:00', '2c02ddd9bc2921da8f14738a22becd32', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4595', 'WalterdowlYLK', 'WalterdowlY', 'doopool796@gmail.com', '$2y$10$hvz2npRr9DByfDE8Bi8kduvumRqfYMlE8h7O8P7gjbXzmj5IYE1.y', '0', '0', '2019-01-20 12:40:46', '2019-01-24 09:06:24', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4596', 'KennethbigCZ', 'Kennethbig', 'ryabochenko.vitack@mail.ru', '$2y$10$ubmttReaIPmfk.w85J.iu.0DuIgUy.rVxRPUKqGsQr7DxQHXjciE6', '1', '0', '2019-01-20 22:01:52', '0000-00-00 00:00:00', '5415131afbecd2c40f18db43b8b8475f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4597', 'NicoleGoalpVR', 'NicoleGoalp', 'zen322@taidar.ru', '$2y$10$985eAIWIioLPc7pXdtczTOWTuH8MLOgqgmQlyxushjPGVVadr0mza', '0', '0', '2019-01-21 00:29:25', '2019-01-21 01:53:23', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4598', 'GregoryAstenWO', 'GregoryAsten', 'barabonov.stepanv8@mail.ru', '$2y$10$ePoy1BZp6f2ovKMU4.Cks.kCc/Cp7W6JOWYQPMo2ipBXe4iaV8.UC', '0', '0', '2019-01-21 03:46:27', '2019-01-21 03:48:35', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4599', 'JustinusadOGM', 'JustinusadO', 'paclanutsrench1977341978@yandex.ru', '$2y$10$BCyPvLER6OLczrEm9YEy2.np2NNNsuKPOi6tYpG6i8uCdgbb5Dn8e', '1', '0', '2019-01-21 07:52:44', '0000-00-00 00:00:00', '4986247a255272c7cf94aee2e76cb462', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4600', 'NikitaKITU', 'EldarPR', 'jakhensel@yandex.com', '$2y$10$iWlPTB1pjV.CIPPfKrmKs.yX8yOF6XAcl3S7FZPnfF/rwOcj16RGG', '1', '0', '2019-01-22 21:41:21', '0000-00-00 00:00:00', 'ee5eec48a77c6a211efe4322c412a772', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4601', 'EvgenTurinovA', 'evgenturinov', 'evgenyturinov@yandex.ru', '$2y$10$jFUS1xeBugWlqFZEPWPmju6hzmTKVeLVvfY513sIKFgxqogmc2ZgC', '1', '0', '2019-01-23 05:03:35', '0000-00-00 00:00:00', '94cce15b185cb21db3f102e8ff64622f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4602', 'LesliedexRG', 'Lesliedex', 'lesliesd@yandex.kz', '$2y$10$gXSSRqPJ0gmJRP1uk27SEe8LPiwDVV6ozmp5iO/LZdLUHNq2qlcNi', '0', '0', '2019-01-23 16:36:22', '2020-05-28 19:08:37', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4603', 'MikhailNDZN', 'LeonidLD', 'r.bolers@yandex.com', '$2y$10$L/uy9ob0j1U.Hcq2ZuAhmOir9fapMUTFm/JKRW5CpuZbVSPaMjlUC', '1', '0', '2019-01-23 18:02:30', '0000-00-00 00:00:00', 'bb9c53a328663f06c44905c6627626a6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4604', 'NikolayBNMJ', 'VadimZN', 'whitersvic@yandex.com', '$2y$10$WPn5QeP052NYTlKE/geiw.1Q6XzthNbvGkHsQbWkKqM7w98FRmv2K', '1', '0', '2019-01-24 15:23:07', '0000-00-00 00:00:00', '7dea20c8d742bde19c2af1a1fbb0f676', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4605', 'RaymondBleatVF', 'RaymondBleat', 'carolhawkins3766@gmail.com', '$2y$10$1m0aMEu/CLebwZ/bsMoCHuBCV1FYopNlTCvkuHYVO34hozHXg0XwS', '0', '0', '2019-01-24 15:43:22', '2019-01-25 23:18:45', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4606', 'RobertfefJJ', 'Robertfef', 'andrewautir@yandex.com', '$2y$10$3tqhGcTRKS2HKFn5cAJhVehQv52K4YSHTvtckvfBO/Ictd5Oy6uda', '0', '0', '2019-01-24 23:51:24', '2019-01-25 10:33:39', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4607', 'PaulaHixND', 'PaulaHix', 'zen323@taidar.ru', '$2y$10$rjHHk7fwQuRwSxTfcZzU4uSRQTnm6TzvPJ0ODX1A3nRKxMXf5Jp4C', '0', '0', '2019-01-25 00:37:49', '2019-01-25 01:44:54', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4608', 'RobertstypeMW', 'Robertstype', 'tsavuxina@bk.ru', '$2y$10$UYkYzZWIlymPkRe7umTR9.KyxRDk7Kl2KUm7Tl83F0yHzWt/es2vq', '1', '0', '2019-01-25 03:13:18', '0000-00-00 00:00:00', 'd971a830d69ab2065ba45c6e8d775d88', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4609', 'EdwardDridsMX', 'EdwardDrids', 'v.a.n.or.ef.d.65@gmail.com', '$2y$10$XXzNdAiXshyS5pvNNUxJe.DY83ANdxpNQ8Kx0ubI9f.ZHektj6D46', '0', '0', '2019-01-25 18:29:41', '2019-01-26 00:01:24', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4610', 'DerickUnpaxSI', 'DerickUnpax', 'dima83838383838.3d.im.a@gmail.com', '$2y$10$krFAg7DHBnpP2rORmkCpjOVfq1srhSDw1HYxcHWQwMaIKGY0YtvMS', '0', '0', '2019-01-25 18:58:30', '2019-01-26 03:51:21', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4611', 'KeithHowTD', 'KeithHow', 'asdfghjk.lqwertyuiopzqdiid@gmail.com', '$2y$10$kStQ/JHKGTCrln2x3YN5AOo6blzIkW2uAuhOhkDMlDkRCdrHDM1oy', '1', '0', '2019-01-26 07:26:24', '0000-00-00 00:00:00', '28eacde93a92af78fc873b37be97a428', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4612', 'Andrey Seroglav', 'AnodusSRtz', 'anodserov70@mail.ru', '$2y$10$SN/BW70y2FggiUtYriNO2etDQ/pdg8TRbLirQ11l0O3M094uX54bq', '1', '0', '2019-01-26 23:23:13', '0000-00-00 00:00:00', '7b8f7d2459286c286972c0259df7b07b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4613', 'JamesgemOE', 'Jamesgem', 'suihuanv198827@yahoo.co.jp', '$2y$10$RcstaTwdVblmf.PYwyJyqe.f8kiS1Dc6VsHqxbS0sfgPrv0P8DvdK', '1', '0', '2019-01-27 10:25:49', '0000-00-00 00:00:00', '6a7c9e44eae3ffd6ab9e0a2d444ed32c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4614', 'LenaGulievasoviBB', 'LenaGulievasovi', 'pashakolmakov6200@mail.ru', '$2y$10$5Gjz./gPd5pk46R7jPrrMOLjwCt7n8Vbe5eS3KnctdWE380XdWwh2', '1', '0', '2019-01-27 15:10:36', '0000-00-00 00:00:00', '14d6a5beabb865d3287b6b39d0ffa7b7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4615', 'Sex TousBJ', 'Sex Tous', 'smitherika846@gmail.com', '$2y$10$3WD95aOx6N29pLsLCHwQP.eacCfQdQJzThHS.vAT.wF1rfqA8tlZ2', '1', '0', '2019-01-27 16:04:10', '0000-00-00 00:00:00', '2ea6ace911011fb04bf1ac844120aa40', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4616', 'PattyPhymnPB', 'PattyPhymn', 'zen324@taidar.ru', '$2y$10$fCUO0zgkGL65IqIIa077tejDnjKpPmsVtEmvvWDItdSK5Ua51bCjC', '0', '0', '2019-01-28 01:22:12', '2019-01-28 02:37:53', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4617', 'DavidBeiskNY', 'DavidBeisk', '1977.kautsh5@mail.ru', '$2y$10$DBDFe/3Mms9Ebcn7jovlyeB3K.o3vAcchND0A6rSmzKn0Jb80HZ9G', '1', '0', '2019-01-28 18:47:43', '0000-00-00 00:00:00', '4bbd61180254357e64d56d7b0ecd832e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4618', 'CliftonscotaCU', 'Cliftonscota', 'marfeli.igori4o@mail.ru', '$2y$10$ogUCCTo2AfoAufFTMosAPOKIrNGtwyYk3wsdK7ImXBmrg44BbmNmK', '1', '0', '2019-01-28 20:26:27', '0000-00-00 00:00:00', 'ea31a7e37fbdb2bf566ec3cde46308c3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4619', 'EmohyloamyXC', 'Emohyloamy', 'sgsew24@dtdns.us', '$2y$10$n4KDihSKIyDj.69kfdV0KO58S6Mz3qnCPc7KHVe1BC/RxD66OIjky', '0', '0', '2019-01-29 05:18:30', '2019-01-29 05:36:41', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4620', 'RichardTonDT', 'RichardTon', 'vitalikevlaxov@mail.ru', '$2y$10$P5GMaRwHrgZykb2LgB5GIe.t0Coe/KVKR3SskGK7ZSFFIXVoch7ce', '1', '0', '2019-01-29 05:30:18', '0000-00-00 00:00:00', '9daeb9602436dd9b2c21046fbf309858', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4621', 'RobertticFR', 'Roberttic', 'va.noref.d.6.5@gmail.com', '$2y$10$XY1Ai36/8iFfiaxa4Twg..g3O9YhruaK65f3dHXR9K/55IxHYbhEG', '0', '0', '2019-01-29 08:05:44', '2019-01-29 08:19:27', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4622', 'RobertSopJU', 'RobertSop', 'cmirnov.v.p.avv@gmail.com', '$2y$10$71cGaTuJmNC/Y//atZT9PeFmeS2nMC6weL..IaYnPACdfKzD39Avq', '0', '0', '2019-01-29 11:12:49', '2019-01-29 17:16:10', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4623', 'JorgereamiUD', 'Jorgereami', 'iiiiggggoorrr78@gmail.com', '$2y$10$a7hWkRh.Lk1MdOHxzYJj.OUE4AlnUAlNstF7LsJFrU7LFHTHbne8m', '0', '0', '2019-01-29 12:55:12', '2019-02-01 02:42:04', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4624', 'LarryruimaAP', 'Larryruima', 'kaptooos@gmail.com', '$2y$10$ELosQCsKswl1EvX6rmdj6.yhxWQEtt.emaWO1DYbjexe1.i0ZLs4i', '0', '0', '2019-01-29 15:06:47', '2019-01-29 21:27:46', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4625', 'KarenZOFAMPQ', 'KarenZOFAM', 'zen325@taidar.ru', '$2y$10$fWFJZMSzTVi26Z41rhxVYOrk8zezfoiONb4LIVe.WZdTtoiAZLCxu', '0', '0', '2019-01-30 11:26:47', '2019-01-30 12:42:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4626', 'AmberacrokGP', 'Amberacrok', 'infoinfotrast@gmail.com', '$2y$10$KUWvFltr55BfY2rpG/mxpOSWp070Wk4es8WhonIipmSuXon4yW6TS', '1', '0', '2019-01-30 19:13:16', '0000-00-00 00:00:00', 'fbad761f8f646664ac964c383827f0cc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4627', 'TerrellPhiceUF', 'TerrellPhice', 'sidhdjsidhdhxi@gmail.com', '$2y$10$81HFuqd27HZVG8Q6oHHwYOKVeJhi3LutRBFi4oT24IyQbBCu2XslS', '0', '0', '2019-01-31 05:18:13', '2019-02-06 19:55:44', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4628', 'GregorysperyRC', 'Gregoryspery', 'cmirno.vvpavv@gmail.com', '$2y$10$BAaNSFknEVoCApMegtF87uH7HQGmNqwlls.GkHwSQ4OszPWAHFJUe', '0', '0', '2019-01-31 05:22:45', '2019-02-22 22:03:14', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4629', 'RicharddusGN', 'Richarddus', 'iiiiggggoo.r.r.r78@gmail.com', '$2y$10$rtJCm.MXfqC2OPYkqXTdKuPbmvhU8JG3ywTZ8QDhuHtW.Sib/EYKC', '0', '0', '2019-01-31 06:46:39', '2019-01-31 07:02:02', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4630', 'DarrelllakUH', 'Darrelllak', 'johnywal.kowi.cz.owi.cz@gmail.com', '$2y$10$7ozyc9EUeoXT2EWQEtaZ.u0.48wgnGzbnuEXtuVcAHS0oy2xJcn5m', '1', '0', '2019-01-31 20:17:19', '0000-00-00 00:00:00', '297d0009efe9afa429776c24b002325f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4631', 'RaymondpiemaXZ', 'Raymondpiema', 'gennadijoluxov@mail.ru', '$2y$10$3YBkYHQFz7QdKHwD2lVMYewTXOyNn2OjBNxu6XKnNBmhND0CY67QO', '0', '0', '2019-02-01 19:50:14', '2019-02-01 19:54:46', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4632', 'CharlesdewDZ', 'Charlesdew', 'iiiiggggoo.rr.r78@gmail.com', '$2y$10$daO8caceMjkBjXtfVjjnD.GnEfGxPaV7aSj0f5qYe3bBJ4m9wj8ze', '0', '0', '2019-02-02 07:18:58', '2019-02-02 07:43:10', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4633', 'KevinCopEA', 'KevinCop', 'cmirno.vvpa.v.v@gmail.com', '$2y$10$bz4BySYLRWnc6WOmb.1HPuuU1BPDuahCGl3T0QDFdimYlrxVF0156', '0', '0', '2019-02-02 07:42:07', '2019-02-02 07:59:55', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4634', 'SanfordUncewDH', 'SanfordUncew', 'kap.too.o.s@gmail.com', '$2y$10$PI6Y4zL9yidw1QNWoiV9jO046.j043YJFGl5br.Li8zFyWMr8c5mW', '0', '0', '2019-02-02 08:43:28', '2019-02-08 18:28:30', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4635', 'AlissaglacyFQ', 'Alissaglacy', 'zen326@taidar.ru', '$2y$10$JsUB7L9M63ldJ/5Rgy..2u8ixHv9vp5Wk5NOekyShoIpQzHusl7FO', '0', '0', '2019-02-02 09:15:17', '2019-02-02 10:14:23', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4636', 'KevinnalRJ', 'Kevinnal', 'tolik.brusenkov2w9@mail.ru', '$2y$10$37mZWg8uCC1LnKk/lBKytuu6q9K3w6mFnFV5ZIiH/0d/L8jlcPrLy', '1', '0', '2019-02-03 07:25:00', '0000-00-00 00:00:00', '708ba69241c798d3e4e65ebc4f97fc5a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4637', 'NakishawogNU', 'Nakishawog', 'livnabekk@rambler.ru', '$2y$10$pPFlsBxC5YLu4nPhVEVQ0.SRX0fBCikqBmOc9W.pHlC96DK6mrY2e', '0', '0', '2019-02-04 06:40:49', '2019-02-04 06:45:42', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4638', 'KevinAbadeJP', 'KevinAbade', 'robertrobert321123321@gmail.com', '$2y$10$PNnKtlXWJDufuTZK5MP6pek7ssTxQbr8Vd6V5El0Lmu1O4dih1bq2', '0', '0', '2019-02-04 08:00:19', '2019-02-04 15:15:35', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4639', 'AndrewdrypeGS', 'Andrewdrype', 'kap.to.oo.s@gmail.com', '$2y$10$CKUSfJQY.NVTH.O8NFtuxeOi1xLldtlgC.kgdj0wPumcj8SqE97Gu', '0', '0', '2019-02-04 08:32:04', '2019-02-25 22:54:11', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4640', 'RogerwaithMS', 'Rogerwaith', 'iiiiggggoo.rrr.7.8@gmail.com', '$2y$10$tS2qfj4prBQs1bJb74WYzuBlYP6Ni58NM2EPLFqwVWi/unpbRh1s2', '0', '0', '2019-02-04 09:29:58', '2019-02-04 09:32:44', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4641', 'ojfbihqQQ', 'vnrgpuy', 'h.a.ni.to.m.bers.c.h.m.i.dt.von.hof@gmail.com', '$2y$10$OkFXpG41s0cWjOWYBVc5ZeUAIB3TWIUkWw7whdtpqw290UciihwWm', '0', '0', '2019-02-04 10:05:59', '2019-02-08 23:49:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4642', 'TraciGueltJO', 'TraciGuelt', 'zen327@taidar.ru', '$2y$10$jIKnLTfJphdRhKwc.QvwJuGuOfr2PUCb5tDajd7kWOOpOihGq7gFC', '0', '0', '2019-02-04 10:22:49', '2019-02-04 10:52:05', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4643', 'ASMR nail tapping', 'ASMR Long Nails', 'gefexasuata@mail.ru', '$2y$10$O.nkLzZoYxa6TBaLp0mcx.xiFU/P55PlVtHRTfPdhHdf9eAUgUpVK', '0', '0', '2019-02-04 13:57:09', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4644', 'MarionmizDX', 'Marionmiz', 'witalina.zhivoglotova@mail.ru', '$2y$10$qn/p1gfzX.WUgPL6PcrW4u.rl3eTaUBtpI9zk.cEXzbFGfB0VwGL6', '0', '0', '2019-02-04 21:03:27', '2019-02-04 21:04:56', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4645', 'KurilovPetyaO', 'kurilovpetya', 'kurilovpetya@yandex.ru', '$2y$10$iy5uLuSGbMfdtea.BXvtcu5QeLsm0V39HZ8n9ANODcfwg.TRRrome', '1', '0', '2019-02-05 03:19:47', '0000-00-00 00:00:00', '9b4e1cd4573ca63f62b673bd25b72cdd', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4646', 'MahaSkurkinaZ', 'mahaskurkina', 'mashaskurkina@yandex.ru', '$2y$10$s0EN9S2JmBF2UwWkZ5htD.phthSaBTxru0zsLXGz40ptpm6JfGzfe', '1', '0', '2019-02-05 08:37:33', '0000-00-00 00:00:00', 'a7a0a9e8a5e1ba853028bf8da08c75f1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4647', 'Misha Nabrodob', 'OsmiusRDBa', 'osmiusmiha75@mail.ru', '$2y$10$PF79TPsL3qwCNnFGP30ZT./MsQWyvTAsE0A53cEIRHDi1skFFpbA.', '0', '0', '2019-02-05 23:18:59', '2019-02-05 23:20:37', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4648', 'HailyBycleHD', 'HailyBycle', 'haily85wor@gmail.com', '$2y$10$mFxnl7DWq5iNLy0UD0etAOfkMQJpv/aNVhQd5.ODzo4M9bNCcqI8S', '0', '0', '2019-02-06 01:15:54', '2019-02-10 23:12:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4649', 'PatrickVahUL', 'PatrickVah', 'i.hrearbeitsagentur@gmail.com', '$2y$10$aqD6k5Lk0apxiK5hGSEbtOf917kp8xsIhRDdvFiv6QPZ4k.SDYEhi', '1', '0', '2019-02-06 11:04:41', '0000-00-00 00:00:00', '3ed077180759a60e4bfae02f07fe3f0a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4650', 'xzusalmeemukcbpGP', 'KitchenAiddoy', 'pasticatel@gmail.com', '$2y$10$oAbkaF1ndT5AGFv0ccppoeXlemdXmttPIZqBMACJgXIHZ8t5U5aVu', '1', '0', '2019-02-06 11:16:42', '0000-00-00 00:00:00', '6e24b9aa1127ff9928fa560c7abdd449', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4651', 'HenryvawDW', 'Henryvaw', 'kap.t.ooo.s@gmail.com', '$2y$10$qj7boZOizqB8Vo8TOUhBGOzTMKl1IDeLs4mfSUpXjKj23uF4uYPOq', '0', '0', '2019-02-06 13:52:42', '2019-02-07 06:11:36', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4652', 'AnthonyNigYZ', 'AnthonyNig', 'cmirno.vvp.a.vv@gmail.com', '$2y$10$UQ81e.cN7b3dpo.3RTrwku2gFjyTyw4OkTytxMapNfnYt9WlP2AkK', '0', '0', '2019-02-06 14:17:50', '2019-02-06 18:35:50', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4653', 'OrefeSeeniaUS', 'OrefeSeenia', 'flamqwerqs@dtdns.us', '$2y$10$miq.QlhI0hS0MD9/11N89uspQprCdlFKaSG21Ko5LgeCwfj7646f.', '0', '0', '2019-02-06 16:17:02', '2019-02-06 16:51:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4654', 'LarryTooksAX', 'LarryTooks', 'iiiiggggoo.rr.r.78@gmail.com', '$2y$10$vXZOClCLLO61guPsqDxsWu0TgXx4kgiWLWnDZeC7rsVXLhALEAqG.', '0', '0', '2019-02-06 16:56:12', '2019-02-06 16:58:49', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4655', 'IdendanewCE', 'Idendanew', 'trica3245@dtdns.us', '$2y$10$d6aDFddrwFmlhUJcT1jxjexekYD2puEt/r4BlWF0cZlfjucoWnmmC', '0', '0', '2019-02-08 07:30:55', '2019-02-08 07:42:14', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4656', 'WilliamTydayST', 'WilliamTyday', 'allopas@o2.pl', '$2y$10$CxvOccCoGY6AG0pu7ZAS.uis7Q0HFMDVkei3p0Sa.aFuXQzuOEKTq', '1', '0', '2019-02-08 10:43:08', '0000-00-00 00:00:00', '030ec69df4f556f203f1d8f6a62c5b3e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4657', 'Отзывы о гадалке Стелла', 'Josephempix', 'prokladova.lyubava6ik@mail.ru', '$2y$10$zYN9iFTT/Ax4LIw3pzysR.H7k.qawmgciIEUnX4wIGALIjlCKsNGO', '1', '0', '2019-02-08 16:28:24', '0000-00-00 00:00:00', 'df27c6ffa340c2fa456a36665c2fe748', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4658', 'MarthaAcanoPC', 'MarthaAcano', 'zen328@taidar.ru', '$2y$10$xbuwZ9H/VYkW/GAdw1HVB.MgbTTDV9jubdHLmYpWAORB6nbi.Z/dG', '0', '0', '2019-02-09 03:07:55', '2019-02-09 03:28:27', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4659', 'DavidilletKI', 'Davidillet', 'valentinfomichev93@mail.ru', '$2y$10$Tgz4OMtdCX0cljOgELKyj.agSGpdZC2vy6H75SI38D2SKgeI2C/um', '1', '0', '2019-02-09 17:03:34', '0000-00-00 00:00:00', '9d97ec706b116c72a3f14e80fd285fd1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4660', 'RichardHicSR', 'RichardHic', 'pofignafig123@mail.ru', '$2y$10$rXMMBcelFV2my7PLZTiP0OOdumXz1JS8rFtiWvFOunkJKlNZsjNNm', '1', '0', '2019-02-09 18:27:09', '0000-00-00 00:00:00', '5acc8cff65b1a6bfc5a60fbe2fbf7eee', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4661', 'HowardChoxyXA', 'HowardChoxy', 'zadolbalkin87@mail.ru', '$2y$10$PJb0RVr.yfNHbEnNGLljvuvCb03Xmop4JNJZJgEApmrjXAZXmeXd6', '1', '0', '2019-02-10 01:43:37', '0000-00-00 00:00:00', '8f4fdf7e50994f49b268211b330475df', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4662', 'CecilkagFU', 'Cecilkag', 'aristarhyudin95@mail.ru', '$2y$10$/.FNwU0I6/Ahc1C0ZEEwnu9mSQyiIQPctf6DtCF6CXfsRnsabH.Dq', '1', '0', '2019-02-10 03:39:54', '0000-00-00 00:00:00', '054e22f3383372e3eec5767f2a063e32', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4663', 'KarenShackCB', 'KarenShack', 'zen329@taidar.ru', '$2y$10$RekigMjpArbQfnfaVEl5SeWUARw5LVuf78Gedh.qsHlG5pjFBfT1y', '0', '0', '2019-02-11 04:15:03', '2019-02-11 05:10:38', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4664', 'SandypewXL', 'Sandypew', 'anastasiafisher864@gmail.com', '$2y$10$JxLTdDpQW3Y56SnMHoxrNOLZ3c.PsQL1iu.mJaEXnniXC1WKcYZwW', '1', '0', '2019-02-12 02:16:50', '0000-00-00 00:00:00', '9b989df038db225b705d0f2c5d48a745', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4665', 'FrancegemTY', 'Francegem', 'zen330@taidar.ru', '$2y$10$y3QDti.yYGC8WGmBibn1vu0.g5P862l4ZjNOD1SFnwLAtsNh87Bna', '0', '0', '2019-02-12 02:22:39', '2019-02-12 03:11:17', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4666', 'zzusalmeutabzmmGP', 'Edelbrockhks', 'stabdorripi@mail.com', '$2y$10$VS2c6kgh1LhjVH98xlibjObItV0GJ1VszwbdkIh.Wmm2U8OKGueDW', '1', '0', '2019-02-12 03:17:25', '0000-00-00 00:00:00', 'fc273280f77808f91fc3a96bb6f11443', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4667', 'CherribroatHT', 'Cherribroat', 'evleniya6wga@rambler.ru', '$2y$10$/ReFqWnp8cC/9b9IY3DUpOfd6rJRlMEw9yGQCu6t7icHEgkOZEGK2', '0', '0', '2019-02-12 13:44:49', '2019-02-12 13:46:48', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4668', 'DubkinanoraKI', 'dubkinanora', 'dubkinanora@yandex.ru', '$2y$10$hF8Q68nzCUwJjjgnwLSLgORn4Vt6PEVCLw5wyCs271ja3NeA4P5U.', '1', '0', '2019-02-12 23:20:00', '0000-00-00 00:00:00', 'e9975da173ac547e9f395ceb7d5980a0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4669', 'AliaMaginaH', 'aliamagina', 'aliamagina@yandex.ru', '$2y$10$3ZJGvALIAW1RX3mTjKolvO78pZCTqHtgIZHTN6l3GN3IpAzLfTP0y', '1', '0', '2019-02-13 04:03:55', '0000-00-00 00:00:00', '64cb2c130ad828d9a12324622e6dbb5b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4670', 'ReatserseXJ', 'Reatserse', 'ewzw24ie@dtdns.us', '$2y$10$UTL0lAfk86pPaByYGDp9L.Kv5khDPwpezfeR6NL2A6p4Iv0HeL8Ee', '0', '0', '2019-02-13 15:59:00', '2019-02-13 16:19:33', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4671', 'EthelNabXK', 'EthelNab', 'zen331@taidar.ru', '$2y$10$u4cEPgvAqwUaJWQP6VuuL.ghhtf6WH19JuuRqrQxs9RAQ.lurDQYq', '0', '0', '2019-02-13 17:47:54', '2019-02-13 18:15:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4672', 'xwusaymeomgszxcGP', 'Vortexmfw', 'fauverphare@mail.com', '$2y$10$wrA.iHOjckaUSgFn1t7IvOgO9SUnr7ljpYVXQ.KJX7f5wDlBbAUKS', '1', '0', '2019-02-14 07:55:35', '0000-00-00 00:00:00', '4c04c86edd0c03fc416b4e7cae5b075e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4673', 'MshashckinaMK', 'mshashckina', 'mshashckina@yandex.ru', '$2y$10$nwyHES2.mF19zXOvvKJUQeezf7uq4dC73Cz3LMuIPYDrbxktzaYL2', '1', '0', '2019-02-14 16:47:48', '0000-00-00 00:00:00', '3964ee665e56672ff6c8491f253dccab', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4674', 'MelvinsibQH', 'Melvinsib', 'imanedkgg@rambler.ru', '$2y$10$g5mS9Pozh9HS5RtmGwJ62ugBUMJ6EEDgkbYb9qRPXQJWsj4yTCKkO', '1', '0', '2019-02-14 21:26:49', '0000-00-00 00:00:00', '76852bef073f863809497df9f7ee65af', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4675', 'WillieunadeHP', 'Willieunade', 'zen332@taidar.ru', '$2y$10$BZyBPSZt5Vj9v5gfXCBR/uHX7mpSKsw0zcqBRZCshuXwU/TWBjZl2', '0', '0', '2019-02-15 00:53:15', '2019-02-15 01:13:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4676', 'Сергей', 'vdlptlkvkgroup', 'vdlptlkvkgroup@mail.ru', '$2y$10$JhpFfij3RApTmCHXEVV1e.x87.I4g7yBcFgYJbpDlMIhI0pi7rQeK', '1', '0', '2019-02-15 16:40:05', '0000-00-00 00:00:00', '921e17328fbc552fd1b3473b6350e827', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4677', 'LouisehYcleWK', 'LouisehYcle', 'zen333@taidar.ru', '$2y$10$zFXlatYurM90OAfHhQ8FfefjBhKlIo2/oixAcBvpmTsASReGsvrmO', '0', '0', '2019-02-17 00:11:49', '2019-02-17 01:25:23', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4678', 'DennisfutUI', 'Dennisfut', 'x.r.u.xmer@gmail.com', '$2y$10$qFAxyP4G.tZvwUJiv4aFDufF8LLz92Qy80CWmJgND.vMxsxDpUCSq', '0', '0', '2019-02-17 02:43:41', '2019-03-04 13:19:52', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4679', 'xzusalme3mkmxjqGP', 'Annotationsfky', 'mandcoortiha@yahoo.co', '$2y$10$oikdbr1S6zS.ETi64mg5Su1xUnFK09w2Q2HhGfCdZnc91Dqp3jrIC', '1', '0', '2019-02-17 17:59:53', '0000-00-00 00:00:00', 'bf7868d6ad6ba6868dc37ec94c8dc680', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4680', 'SharondobNR', 'Sharondob', 'zen334@taidar.ru', '$2y$10$UNkh9XImBx1yRa2H5S8LIOvgaGdzb.644wpxziCkpDG1DNL.UqVtu', '0', '0', '2019-02-18 01:52:15', '2019-02-18 02:29:27', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4681', 'Nikolay', 'KolIkA', 'sun-lenta2@rcnika.biz.ua', '$2y$10$D3k5tcpXZkcdF84KcPZ4kuKLDT53pjz1DEQ3kuWz4T76R/YPFzy46', '1', '0', '2019-02-18 07:55:07', '0000-00-00 00:00:00', '1829718bcc535db9ea80a20e6e36699b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4682', 'DonaldkeessAN', 'Donaldkeess', 'rostislawgerakow@mail.ru', '$2y$10$MckYRLRYVhcWhr.bs9a8cOxY186hdEp5636SovhG37S4HORoOGa5O', '0', '0', '2019-02-18 23:10:19', '2019-02-18 23:12:40', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4683', 'szusafmewnowcyuGP', 'Backlitgnb', 'osenualex@gmail.com', '$2y$10$0Ihiy3VJVZCMflQr3CgRHu9m1/pZKURpVyKTY0JVRp5yeLoi.LiVG', '1', '0', '2019-02-19 08:46:39', '0000-00-00 00:00:00', 'bd59c83db393599f70e939bfab807452', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4684', 'CynthiafahNL', 'Cynthiafah', 'zen335@taidar.ru', '$2y$10$.v9ZYEii2rRTSkPv7oD4N.veDJNEHqXxhQ4IGDo5yi49cKNuYJGaq', '0', '0', '2019-02-20 03:28:22', '2019-02-20 04:35:07', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4685', 'IcubasowaKO', 'icubasowa', 'icubasowa@yandex.ru', '$2y$10$PDrNi6Mc2njopy/fsWmtFuVMo.cjLoJ3MPJlzleQWI3Ktcnzq90wu', '1', '0', '2019-02-20 05:33:55', '0000-00-00 00:00:00', 'cba7ed53b5ae59a2ef4ea7c4e087a689', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4686', 'OparamonihaJH', 'oparamoniha', 'oparamoniha@yandex.ru', '$2y$10$Je3b0vrhsM/HIXcOmzH/ieywjDIB74SSXD8zTw5i3KZNEGMB7T7bi', '1', '0', '2019-02-20 07:03:11', '0000-00-00 00:00:00', 'da96637fc14db551c1c14d1c812cee4e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4687', 'PhilipsleedNA', 'Philipsleed', 'hibbub@dertul.xyz', '$2y$10$lnUzg26I0.PQfQPLqlh0eeIzDsPPGnKkTHw9LwCQmQmJ0uVuw13f.', '0', '0', '2019-02-20 23:58:38', '2019-02-20 23:59:33', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4688', 'SilviaVOGMK', 'SilviaVOG', 'arlett1tweku@rambler.ru', '$2y$10$iOjpDG/1EYvkQYbsjK6FsOmaChRTsbNPnlAk3cm9maGgP2uC16nrq', '1', '0', '2019-02-21 05:55:14', '0000-00-00 00:00:00', '9292fc133feca8651a2ccbbb593bb4b3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4689', 'VasilyEDMJ', 'ValeryVR', 'wil.divers@yandex.com', '$2y$10$RIIo/yf5N6AbCm7G8ZekAOSKYLi6mZL/Ok8c/7NB3dC9Q5O6xg3r.', '0', '0', '2019-02-21 11:25:41', '2019-09-24 17:50:16', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4690', 'VadimFXMJ', 'EgorOL', 'wilgolers@yandex.com', '$2y$10$HgfXYuU3hg4s4msvsfQ2YOb7NUe/toK.lWMuKRs535PIucnCJq97G', '0', '0', '2019-02-22 04:17:37', '2019-09-09 04:33:15', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4691', 'ArmantoacizeKX', 'Armantoacize', 'shorena5xs@rambler.ru', '$2y$10$UaPWwrD.w2j8NqHwVT5SGuMBdmVos9mZ6R.IGkR.riCsGPYL9GfIW', '0', '0', '2019-02-23 03:26:25', '2019-02-23 03:30:54', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4692', 'LidiaPlumpZM', 'LidiaPlump', 'zen336@taidar.ru', '$2y$10$dnINiAv8Uu5yyKScDhWHgetqEAcZfm6LFSDaR6GMQoPLgY6hiSGQW', '1', '0', '2019-02-24 07:18:10', '0000-00-00 00:00:00', '39641d5ccda3ef335a9bd66d0957bf23', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4693', 'Clifford Purton', 'cliffordpurton216338', '23003semetara@enlerama.eu', '$2y$10$s/o4aRp2Mx5Rz/7Kl9/16uKerTGTWvMfdDSIpbZSu0yHgzc3pnas2', '0', '0', '2019-02-24 10:58:35', '2019-02-24 11:04:39', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4694', 'WarrenSonGZ', 'WarrenSon', 'sophia.abramson.76@mail.ru', '$2y$10$FTyqDy/5cR3a3nv4t9wFTeR.hGQK7cVPnexKi2ur9q8eM6UCNT93i', '1', '0', '2019-02-24 17:50:05', '0000-00-00 00:00:00', 'b1f8adb047be4b0c9b15877b9dfd4c37', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4695', 'AdavidRicDT', 'AdavidRic', 'uslugiremontoweslupskk@mojxpocztar.poczta.lolekemail.net', '$2y$10$9EBFdWI.E7qT2PTcU/ypruaMGw7fNusY40CrsB6N9AHH23xcDmu8a', '0', '0', '2019-02-24 19:27:04', '2019-03-01 15:10:22', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4696', 'AphillipMophyJG', 'AphillipMophy', 'uslugiremontowewslupskuuu@mojxpocztar.poczta.lolekemail.net', '$2y$10$YLd2.L38o.OvHs5jIY8a3ehYuQJbW78hmOzpaiXcKlcd1QBgFOhpa', '0', '0', '2019-02-24 20:31:54', '2019-03-01 15:48:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4697', 'DostalNesGY', 'DostalNes', 'mayboroda.aleksandr.1994@mail.ru', '$2y$10$7pg69AgtRzSL6zpaT8CH2.BNQ0DWbqhbtuzX9eY60xe8t03uiCwxK', '1', '0', '2019-02-25 12:21:05', '0000-00-00 00:00:00', '03970e8956a2e9b53bdee611c6aecb9e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4698', 'xwusalmetnhcc2bGP', 'Epiphonecxm', 'iannuzz1@icloud.com', '$2y$10$evWsZF5rqWnMUc4OLkIiYO598Bt2LQeXlnf25ol/PHLTf.TOEzs6W', '1', '0', '2019-02-26 17:16:36', '0000-00-00 00:00:00', '0128ffb0102b26591bf93a11276ee00e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4699', 'xzusalmecmyjzjdGP', 'Securityvjv', 'laurenblum14@gmail.com', '$2y$10$1BjKdpc0UlOM0QVCTdzIDOIRa/ZWJFELFPA33dv.M/uDbkzA7SGw.', '1', '0', '2019-02-27 12:52:03', '0000-00-00 00:00:00', '3c27047cf7d783d87b37753812864db9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4700', 'LtukonovaNX', 'ltukonova', 'ltukonova@yandex.ru', '$2y$10$FJDz9ard2xPnvsdCvTnfMuKCHaZ.IT0u4keztuiOsjRZJZp4HSprK', '1', '0', '2019-02-27 18:22:42', '0000-00-00 00:00:00', 'daf43e60903bb2271e62b014c1926cf7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4701', 'swusafmepmjpdqyGP', 'Holographicxbj', 'd9741300@gmail.com', '$2y$10$GTsJMSc14GzzB44Ln5WJT.BwDbg4GtuQbSTriBZkgkvAihsv9fdiC', '1', '0', '2019-02-28 03:32:34', '0000-00-00 00:00:00', 'aeabd234af97f3db6c76661bb74bdb1e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4702', 'svusalmermafcamGP', 'Garminzsja', 'ciecomkefond@yahoo.co', '$2y$10$iLr.DOrzpno35AXeWooQ1.BWdKUhyfVwpN4dhvd7Ad8vb3YR.l.0W', '1', '0', '2019-02-28 03:36:54', '0000-00-00 00:00:00', '98a1861a5ff4fec1d90452bf6c4b1fa4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4703', 'szusafme3nryxltGP', 'Professionalpmn', 'jlombardi@vrbusinessbrokers.com', '$2y$10$MtSPAllvWsHNK2TnbDNGuODHlp4rqxucwJmM2NRHlHiQOnQ0/WZgS', '1', '0', '2019-02-28 04:35:11', '0000-00-00 00:00:00', '6fc7c95a52b78e13b9e00b464e83902b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4704', 'zvusafmeqmciz3mGP', 'Marshallpag', 'djordje@vuckovic.co.uk', '$2y$10$NgHmrb/Gi4YPVFXZ4RZTxOQYgg3rWgNQsvU306lQ0s4PWCMiXje5C', '1', '0', '2019-02-28 15:14:46', '0000-00-00 00:00:00', '6556940f0e0b3abab71b230173f659c8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4705', 'swusafmeztnxd2iGP', 'WILDKATudf', 'dangoebel@yahoo.com', '$2y$10$9sJju1A6/rsj8eDiHrLsdO9tx18YzRlfkDmGDzYXyWTxFYk7Ox6yy', '1', '0', '2019-02-28 16:35:37', '0000-00-00 00:00:00', 'b5dcbe3e4ea83e4fd50617204160f59f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4706', 'xwusalmecmdyxjkGP', 'Flukeusr', 'jtine54@gmail.com', '$2y$10$UkbByYBem7CJyBYJygwhu.JrPMQuodrzHA2wvI6OAD4Z1kK.yNe0S', '1', '0', '2019-02-28 23:06:33', '0000-00-00 00:00:00', '671735122f878c53ca727634c2176bff', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4707', 'szusalme3mxzdpvGP', 'Carpetimk', 'kwade@towserviceinc.com', '$2y$10$oH/oY1Hv7Md/niC2P1iwuejRG4FloE6cWoNVGayzYbJNdVHNGHzqW', '1', '0', '2019-03-01 06:56:25', '0000-00-00 00:00:00', '975221cecd6a5029bc03edcca78ccc84', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4708', 'LarryPlaseLP', 'LarryPlase', 'artyomomelin@mail.ru', '$2y$10$7PK/etYtTWN7Z2t7el5zwOA1yUqTvzuDJtTy.6yMvlf2NawbBW8ym', '1', '0', '2019-03-01 08:07:13', '0000-00-00 00:00:00', 'd23d75c7b0d04404d82cd3d7986577dd', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4709', 'xwusafmehtxsdwpGP', 'Carpetogr', 'dianandre@gmail.com', '$2y$10$uctrGIRuAGqdIhY6c2Jy.uxmuy.Y7fxzRt.Rk45GwfvDNYFovVTmy', '1', '0', '2019-03-01 08:58:47', '0000-00-00 00:00:00', '381ea0a1ec31bc83691e6051a4031445', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4710', 'zwusalmektsadauGP', 'Foamsje', 'karina-ivanova-1969@list.ru', '$2y$10$lLA1l3ef7dvtzKFGpAytB.slwUSsN5KT2c3Orh9HqfqVNhcNulfb.', '1', '0', '2019-03-01 12:59:44', '0000-00-00 00:00:00', 'e081568a09465f99757f7b39ed86ca86', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4711', 'MarcosHeniaOE', 'MarcosHenia', 'adam.boldyrev.77@mail.ru', '$2y$10$VwAbFO0nNCirHxc0ij7xUutVQ2gVJMcUSyRmk4w7RcgRlY260Znlq', '1', '0', '2019-03-01 13:22:21', '0000-00-00 00:00:00', '76f37c162e223348979608ce68d592c4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4712', 'svusafmeftzzxkjGP', 'Furrionund', 'sunfuchambve@gmail.com', '$2y$10$ByGdRvsg/rWqM1P0t.Q.uu954xxalgiKoNZU49uMvQRLBs5p78wnS', '1', '0', '2019-03-01 18:15:41', '0000-00-00 00:00:00', '3c6bca619c2627f8722256758a2d16b2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4713', 'YolandaLizJC', 'YolandaLiz', 'vyacheslavgr3f@rambler.ru', '$2y$10$iAvPm99z6gZSQCQ2r10I9udHS/zJ2LNrTXiVKMqqGFSqDqBxOcj2y', '1', '0', '2019-03-02 06:47:44', '0000-00-00 00:00:00', '97d617e12564d70578f5b294d272288d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4714', 'zvusaymeenbvckgGP', 'Wirelessyuk', 'creasualinon@hotmail.com', '$2y$10$RlmgnWux2rtKO29j.i5RwePa2yx4quxCuC9nF0BetdzynLU1t29FW', '1', '0', '2019-03-02 08:26:15', '0000-00-00 00:00:00', 'ba8d04d9b52c7154def6c55654af291c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4715', 'svusaymektwczymGP', 'Beateryij', 'gina@belknapplumbing.com', '$2y$10$lUAa5jJoJXAqM4zKInF7D.2vUoApAjWNDLSI/n5iRfO9KxR2PxFge', '1', '0', '2019-03-02 23:58:50', '0000-00-00 00:00:00', '5f8ca91e0fc2a8bdbf142110aa676c80', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4716', 'MelissaphorbYP', 'Melissaphorb', 'zen337@taidar.ru', '$2y$10$Wy24k2XzUBAKTb1zfo9HhOzhEGLjKhfljMr/AVa.1gunPeBbfZgE6', '0', '0', '2019-03-03 05:25:15', '2019-03-03 05:51:05', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4717', 'SantoswayncRP', 'Santoswaync', 'pyotrbzidr@rambler.ru', '$2y$10$t7sLFNK2mAYnj3I7m.YGkO9RuAKXe784cxv9llSEERJ.tBQxW.GCK', '1', '0', '2019-03-03 06:59:51', '0000-00-00 00:00:00', 'c57f280396b8373cc6628892a7877116', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4718', 'GandonlutleSJ', 'Gandonlutle', 'parsinfo@yandex.ru', '$2y$10$cKV1lLxi6kdPInwFAb7aBeTGaHWRH9RAheQZL6oNyARRhe6FZJWVe', '1', '0', '2019-03-04 02:08:21', '0000-00-00 00:00:00', '7f7065e0f81e397403bbaed61226508f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4719', 'RalphAsynCNF', 'RalphAsynC', 'pavel1gvymukhin@rambler.ru', '$2y$10$zSuaLhrx3AZd9JUUhZSacOj.BmqdoiINXEpbFlJUtr73PesAS9ifm', '0', '0', '2019-03-04 09:33:02', '2019-03-04 09:37:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4720', 'szusaymewmmyccvGP', 'Flashpaqnqx', 'recsynchtizi@hotmail.com', '$2y$10$8N/fC5aNsQzUqsOffT3tnOkRF6bi3fqMC6EV4eyr2.k/m5y8Gidlm', '1', '0', '2019-03-04 12:11:14', '0000-00-00 00:00:00', 'd8caa0783325e4b49e5aa6afd5218f31', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4721', 'MachetovvakKS', 'machetovvak', 'machetovvak@yandex.ru', '$2y$10$S.cizNrVE4gnvXIYmCQ4NugqFEnitNkD2s3jewYtr/3aHyIR..ROK', '1', '0', '2019-03-04 22:13:52', '0000-00-00 00:00:00', '56a8e5cc63974977e629909dc77c65ce', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4722', 'zzusalmelmfexmcGP', 'Avalancheugt', 'lindawillsit@gmail.com', '$2y$10$zn..n45/XJ4nXremullifeMiMbX0rfBKgmFhXJiC5X/LQ6dBSZE7G', '1', '0', '2019-03-05 00:17:05', '0000-00-00 00:00:00', 'cce86345173af1894a2fbdc9d2d2a490', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4723', 'fortniteMAA', 'fortnite accountsMAAW', 'k6vfsqm@shitmail.org', '$2y$10$TOwebkGaccWabt3XZwtdgulZgTvxGlRxw6HDxvYO/KgsqyeLeO09a', '1', '0', '2019-03-05 01:25:38', '0000-00-00 00:00:00', 'b7a51eb4d4b32801b6aadc9df6fd4511', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4724', 'xzusalmeptdtcpoGP', 'Seriesxdb', 'murphymegonigal@gmail.com', '$2y$10$msXRZBxBL3xIQ9B5J2qM2u/Ewzb9XgHsgXxd68/ffPvXWOa.dq2Sm', '1', '0', '2019-03-05 02:59:57', '0000-00-00 00:00:00', '51838a1a811cf61a7af32b1a4445f0f7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4725', 'JaninewexFW', 'Janinewex', 'zen338@taidar.ru', '$2y$10$yYnE65VQIJT02UNQOt8ZGuc1Zy2zLmh3b3a74M2E4lW9J8GYCITUu', '1', '0', '2019-03-05 03:36:55', '0000-00-00 00:00:00', 'd54c62929e93580246f91349c6af7e20', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4726', 'LmilatovaQF', 'lmilatova', 'lmilatova@yandex.ru', '$2y$10$RRpBLt4U0Vs3GRoQkQkAj.VQrg2xMSZUBTXoLr9snRVKB2CEww.Ru', '1', '0', '2019-03-05 05:57:03', '0000-00-00 00:00:00', '31647c0680fb3d9f0d006a99d9a9744a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4727', 'zvusaymedmhtcvaGP', 'Artisaniyl', 'peter.dietz@grinding.com', '$2y$10$QYDX70m4g1JXBNJ4KyQl8.JS3AnAWS8MpzWRjiGZ28i30ahCBAF36', '1', '0', '2019-03-05 09:09:47', '0000-00-00 00:00:00', '9d5ae6270e71961d5812ae66f8300269', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4728', 'zwusalmegmgezrkGP', 'Marshalldwr', 'wryan@ryanfl.com', '$2y$10$MmloLk3ONA..YIKz64zHOes6NQBcf0X2sBeQrrqfxvopKLP5z39cW', '1', '0', '2019-03-05 09:43:19', '0000-00-00 00:00:00', '2b288ba99ed1ef51bd4860b28a109b7d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4729', 'xwusaymesmdgcrgGP', 'Keypadaual', 'velez_dianac@yahoo.com', '$2y$10$SCtFs7AYe8fUPOPKvv4Xh.NHRW1U5LP9DMLGfXoR9.TdI2nYS5GYS', '1', '0', '2019-03-05 15:41:32', '0000-00-00 00:00:00', 'c739c9697b256924df751eae38eb68b7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4730', 'svusalmeuncecbuGP', 'Cutteroyx', 'missscott13@icloud.com', '$2y$10$u4XMPsTBhDqJ8Xv80/QKYeAE5zX1ckc4CES0PoF55gL88fRQj4/L2', '1', '0', '2019-03-05 18:27:36', '0000-00-00 00:00:00', 'c6ecaf6817cdda2e04d0540ffda11981', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4731', 'bdsm', 'bdsm', 'madisonwilliams@ukr.net', '$2y$10$NapAa/yLnSDLc0UA4sj0Sujax2Dqr2USyM5SwS6/PGwHzNaDNgYYK', '1', '0', '2019-03-05 18:29:41', '0000-00-00 00:00:00', '245f04df7b2b02a4a48883e9a682a2b6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4732', 'xwusalmezmuldpsGP', 'Batterymoy', 'ryandmartin@gmail.com', '$2y$10$l0Uz/3e2dTg.iNNiUAEtJOaU/fG2CUL709KR6KliuW.aDcaQY25We', '1', '0', '2019-03-05 18:29:49', '0000-00-00 00:00:00', 'd18a705fb5ac5071ba4100c899bd4577', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4733', 'xzusafme3mphckcGP', 'Amazonnnevb', 'loraleegreene@gmail.com', '$2y$10$Js8KSEWYr6iUk6YZ3ENGuuY15/3SMCf4kiO/80aM7taa4Nno.n2W2', '1', '0', '2019-03-05 21:53:32', '0000-00-00 00:00:00', '2108a876d375563761e4794b3c08286c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4734', 'zzusafmecnixzekGP', 'Vortexxau', 'support@bestbabyclub.ru', '$2y$10$iknR/mrPZLiqTiZjRtp6GuS4rgrdRIVSY/e0b0ocREU83XiKDBexG', '1', '0', '2019-03-06 05:41:11', '0000-00-00 00:00:00', 'a72809b810bd2c3329c2ce7e2d1fe08b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4735', 'xwusaymeutnidxuGP', 'Independentyjq', 'reservations@pinetreelodge.ca', '$2y$10$LOaGRzcoBiC.oBn0e2g/HusEqI008K3m1qTxuMJJPW9BKB6kLsfTG', '1', '0', '2019-03-06 18:30:25', '0000-00-00 00:00:00', '2c6806ee123174d2528558aa8a485c4b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4736', 'xvusalmeetjcchoGP', 'Epiphonefpx', 'doreenrush@windstream.net', '$2y$10$D.iL09IFJ3vsp.RdIYu6nup8JDO5kTp5V/L5SJhlEP71WY.n/.OFa', '1', '0', '2019-03-06 20:46:19', '0000-00-00 00:00:00', '411a80dc564b8fff3e5aa05dcdf4c4e7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4737', 'swusafmestpuxaxGP', 'Rigidccg', 'jforcier@co.strafford.nh.us', '$2y$10$71WWpsLT0OGUXSm9/K991.3PRhP0sPrcGh3WNYEsT9ywXKsNEBgxO', '0', '0', '2019-03-06 22:32:03', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4738', 'WayneThamsDU', 'WayneThams', 'daziw@guerillamarketingexperts.com', '$2y$10$gepIPyPYMyilsC7rArnIo.kuYcu7bZjzDIF.ZgjhNPrNs1vxuXKcO', '0', '0', '2019-03-07 00:51:02', '2019-03-07 01:50:27', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4739', 'swusaymevnarcwwGP', 'Sprinklerqcg', 'jose.bautista32@gmail.com', '$2y$10$hYBY51PQGA7MSCQocISm..mjeGwJ.nwC2qVtgfvoKY8YbnzSZK6fO', '1', '0', '2019-03-07 08:19:18', '0000-00-00 00:00:00', '0fb5852d7e8fa6716ed59511f590a9ee', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4740', 'zzusafmekmcbclkGP', 'Fingerboarduxi', 'the_anderson_family5@live.com', '$2y$10$fajeSKWSqbRX81JytS9WJ.0pU1YXQbOCLjOf1r0EdurLinnZ1qxwq', '1', '0', '2019-03-07 19:15:53', '0000-00-00 00:00:00', 'a64d3c29d393c5feeed9011e5d6f5c97', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4741', 'xwusafme2tkxdenGP', 'Annotationstxc', 'latonyab23@yahoo.com', '$2y$10$nrck3C.yT1c8pRvcDGVpm.6H.WSAGfFZmecT9Dw5vEw8hxoWdS2J2', '1', '0', '2019-03-07 22:30:29', '0000-00-00 00:00:00', '3d50a081ef945e571719973ccc9d77e0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4742', 'zzusaymeynrmcqvGP', 'RainMachineigl', 'robin@securityroofing.com', '$2y$10$JUb5hQ6AViNBaW.sfc8zcuWBRI8vTLbM5WV1B2zFYdX0rm.E7a/LO', '1', '0', '2019-03-08 00:18:32', '0000-00-00 00:00:00', 'f805c65889daf4f8b42f8c4b57d73ebb', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4743', 'LindaVablyUF', 'LindaVably', 'zen339@taidar.ru', '$2y$10$A6aWwXTGFSzKL8K1wVgG8eVMyZpGz/rwbuxdxw3vo29/MAyMXNche', '1', '0', '2019-03-08 11:06:20', '0000-00-00 00:00:00', '9648478cce983466303a051d5f3b6dbc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4744', 'swusaymebncpxeiGP', 'Rachioywd', 'mikemalina@yahoo.com', '$2y$10$oMhwoYFjPiV8t17b/6mj8.XIZFcIkeLOX1jk4.Hvpq5dceRzFnELC', '1', '0', '2019-03-08 13:13:50', '0000-00-00 00:00:00', '3c0294ec5951df4427df875c5fe53476', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4745', 'szusaymeymhfcmwGP', 'Rigiddia', 'childs1_1@sbcglobal.net', '$2y$10$a0JAq9yDW8gX4oHIYGdxUeqfF1qHL5ndxF8npyaTQHnpSupx9ftk6', '1', '0', '2019-03-08 17:20:41', '0000-00-00 00:00:00', 'e3e098c9445a6a35eb037a6d8b3e3dd7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4746', 'xwusalmektffdgrGP', 'Holographicxyt', 'ptrckwllc@hotmail.com', '$2y$10$mzh8VCUe04V2PhO4CcYAde2XSZSTix0Thmm.ocbpjKytTfqmibl.C', '1', '0', '2019-03-09 06:02:16', '0000-00-00 00:00:00', '465e9fbd0267e927c6fadfa288a38f49', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4747', 'zzusafmeltrazwcGP', 'Mojavecfe', 'chyna.natoli@gmail.com', '$2y$10$Xdvwn2m6N/VUjdXgJqtJfOIiYwevwOCBUXaZ0i11eatH0Ca1uTExe', '1', '0', '2019-03-09 15:29:14', '0000-00-00 00:00:00', 'eaea469c0c2ba1baf35668ee20310e86', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4748', 'zzusalmeamgjzkhGP', 'Garminzpin', 'info@woodmenders.com', '$2y$10$GnO437UPOpmcRRgHkRPjsuP1aMnCjD0NIAzDjgbM0tuuG9KPgl49e', '1', '0', '2019-03-09 17:16:58', '0000-00-00 00:00:00', '99086979b5830f68be23d1122f7a1a3b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4749', 'xvusafmeymqxzmfGP', 'Squierhtd', 'shellster1961@yahoo.com', '$2y$10$ZqXC1zutKQSFMgJVCxp5P.wTeidnMnPoejmcWp/SBw/x9QH7dzzRC', '1', '0', '2019-03-09 21:47:38', '0000-00-00 00:00:00', '14b7b96128256495f1f8fcc6fcd01d28', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4750', 'EldonWoMZX', 'EldonWoM', 'glicge@dertul.xyz', '$2y$10$zIFoRAUsu4tPzfSfIqrHsesLvKK5keWdTQuSrW2/5F88QALdJWNKe', '0', '0', '2019-03-09 23:24:57', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4751', 'MarikukovaZV', 'marikukova', 'marikukova@yandex.ru', '$2y$10$40gcyx53MLHuBJfyenG9YeTh7fnxAWrsacdjnjYaAUYAZ42eLbLvS', '1', '0', '2019-03-10 00:24:28', '0000-00-00 00:00:00', '8a409f3eed52c8085a12e76e9d9c9a97', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4752', 'svusafmegmflx3bGP', 'Drywallabh', 'indyinterp@gmail.com', '$2y$10$aKBuhxZDCNwdGdVAaKmGRORClWC7Smh7662rqlDRyGyLYw6NCNRWm', '1', '0', '2019-03-10 20:31:51', '0000-00-00 00:00:00', '3be411a202184cdbcfe1adf1162d3732', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4753', 'zzusalmestxszkmGP', 'EOTechlrf', 'angela00mcdonald@sbcglobal.net', '$2y$10$rj3yvZ8.0ihN/LjTwD.O5./7idXQCF0Hzp4sZPAorz1hbMZx4VGlW', '1', '0', '2019-03-10 22:57:13', '0000-00-00 00:00:00', '955918e65b4e1b58809e8b3b211b4600', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4754', 'RoberthusZG', 'Roberthus', 'lelya_shcherbakova_83@mail.ru', '$2y$10$VqHH3OGrNNLBAIlPfwI8x.8KlVDIDVudT4eW6fTjfArDTiwK58RlS', '1', '0', '2019-03-10 23:44:51', '0000-00-00 00:00:00', '64d66261ae03b4251855a42ab73e985b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4755', 'szusalmejnjldnkGP', 'Documentcwt', 'olasceploy@yahoo.co', '$2y$10$ephxt2A3GQez3BZ36LDfauSbBP8IXrhITPPu7v.F5rFSSpTb90eym', '1', '0', '2019-03-10 23:46:10', '0000-00-00 00:00:00', 'edef1ae798f704192d54e8e40d67c866', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4756', 'svusaymedmzvcqmGP', 'Stanmorepew', 'chudson@indy.rr.com', '$2y$10$T9rhS5mX5wn74SZdL9/ePO6q8OcLiPZrDYkL8MuDQ2ZgorYgIOWxy', '1', '0', '2019-03-11 06:07:01', '0000-00-00 00:00:00', 'd8c154fc761024b94578c24f70fb0fe2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4757', 'CharlisBenHM', 'CharlisBen', 'aleksandrbtgm0@rambler.ru', '$2y$10$fFvhZUpxreDj0RchFUWY.eZXOK2qAyG3n9FLBlBbNjfq/I1mWGQpC', '0', '0', '2019-03-11 10:26:20', '2019-03-11 10:30:18', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4758', 'kpushkinetsWD', 'kpushkinets', 'kpushkinets@yandex.ru', '$2y$10$.YKq0D04YO9fFTthinmKluPnTRjRGEBWdEUKceXkf4ldGdzSUJdUG', '1', '0', '2019-03-11 10:35:13', '0000-00-00 00:00:00', '2cf4cc99fee194606e70dcc08afe670a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4759', 'MerrillPneuhTY', 'MerrillPneuh', 'alla.anisimova.1987@mail.ru', '$2y$10$mzMxLOvfG99mpKVEgN7PTuv6PXjkt7e8ra7MZ6.bS11ipTzhIGABK', '1', '0', '2019-03-11 11:04:47', '0000-00-00 00:00:00', '5961ded3c32a15758704c35725911114', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4760', 'zzusaymepmeicdrGP', 'Rigidijc', 'clari3@sbcglobal.net', '$2y$10$rayDSbKp1IfxVif/oow46uWoZNn48MFK9zFSPKYoodyzQBwao/i3y', '1', '0', '2019-03-11 12:07:13', '0000-00-00 00:00:00', 'a9480d9bfedce16901f44e6b09fc522f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4761', 'xvusalme2tcxxflGP', 'Beaterntd', 'ebessette@abog.org', '$2y$10$4agpz6O.pgkSAzP3CF0evOsXn0mTaJ/NKRr5TH9JaSIDSl2wvfBTq', '1', '0', '2019-03-11 20:42:51', '0000-00-00 00:00:00', 'f95ec51023ce7e69c6c308a3a96ca95e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4762', 'swusaymewmdkxdxGP', 'Bluetoothtvv', 'mjkim0926@gmail.com', '$2y$10$F6IdfmJs0Y5XnxIc2YDdiO4c0wHXN8TFQ.2HCLkqLK2vLVwDoRDgO', '1', '0', '2019-03-11 22:53:55', '0000-00-00 00:00:00', '095cb2b5573731e6a6b4a053b254e8a9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4763', 'zvusafmeznoscsxGP', 'Avalancheugj', 'ekmjr@windstream.net', '$2y$10$HjFXCFvUm8Z/qb3pAqGA3uI9gkJY2i5yvKBxK80K5NUrBpwbXWBpG', '1', '0', '2019-03-12 01:18:45', '0000-00-00 00:00:00', '758c43089e26871aa362ba0072e4a0ef', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4764', 'swusaymefmiacgyGP', 'Holographicsib', 'jimd@randoco.com', '$2y$10$iqdPiV5lH1wegPlWjt8FfOH5sJ1bgSw5jE7LRKOviF/aq0TrMPC.u', '1', '0', '2019-03-12 01:54:35', '0000-00-00 00:00:00', '45458af0edf9be6542aeaddabd10e318', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4765', 'xvusalmeqtelxfuGP', 'Milwaukeevvk', 'andreafallon83@gmail.com', '$2y$10$1mjgxSCKU3d/kBqGthRmM.4DX7sTwDSq6fELdlUnMn2vI63Mu0sVy', '1', '0', '2019-03-12 09:23:58', '0000-00-00 00:00:00', '933913f96f2d5494aa206b3f4e2842ea', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4766', 'xwusafmemttqzobGP', 'Sightnkp', 'sruzkowski@gmail.com', '$2y$10$CCXz.GASDDAwQeU9fpwZJ.q0GGfw.KcAHDMZT0nFkcpm7jre2d0NG', '1', '0', '2019-03-12 19:58:12', '0000-00-00 00:00:00', 'c5ff2648b87898405dfde41f727066dd', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4767', 'AcharlesEmamyVG', 'AcharlesEmamy', 'majowkanadmorzemm201999@mojxpocztar.poczta.lolekemail.net', '$2y$10$.fKwQsHo95RL3w9Y5bWUt.2gCICN4sgrNPHHiBQ9m7lybOeQL6Y3u', '0', '0', '2019-03-12 21:01:39', '2019-03-18 11:49:13', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4768', 'AdavidPewRE', 'AdavidPew', 'majowkanadmorzemw201999@mojxpocztar.poczta.lolekemail.net', '$2y$10$x9MfsPmjwb7ueGVPmyLll.CfR88HYdmqIemTNWdQlghEcHTzrzCVW', '0', '0', '2019-03-12 21:54:18', '2019-03-12 21:58:19', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4769', 'xwusaymentkvcdkGP', 'Infraredrvn', 'kara5234@hotmail.com', '$2y$10$n0H.7FfVqdb.O1hYUwmHZ.NpEUSpcgRJsn2xAQuojTI05sVdHk9q.', '1', '0', '2019-03-13 02:36:20', '0000-00-00 00:00:00', 'cd3673d0f41f62d4b22db42644668bbf', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4770', 'xzusaymennaedbsGP', 'Rigidfcm', 'kzundel@hotmail.com', '$2y$10$cy9fSd.z6b0LuH0801B6yu.WVgEVCCsQajkOm83sPRG.2d86KHk2i', '1', '0', '2019-03-13 05:26:51', '0000-00-00 00:00:00', '671305c87914eab9d27f77b7077dfcfe', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4771', 'zwusaymeztmedaiGP', 'Securitybae', 'kaitlynthompson536@gmail.com', '$2y$10$WJHgtBD/a/THuvkBBuU92enKOjUHD7STSWL.RRI8uTyiBPsopG9D2', '1', '0', '2019-03-13 05:47:49', '0000-00-00 00:00:00', '3bbc7bb07edc78134d1888dbdefc6481', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4772', 'svusafmeemmjdhxGP', 'Arnotttai', 'nextgenerationtowing@gmail.com', '$2y$10$nv2rEO83k/YCb77PxFrRkeMwA4ErE/KSgYvNtl9/d3ooCvSaHXO2a', '1', '0', '2019-03-13 06:09:45', '0000-00-00 00:00:00', '2327702add22228421620d71dec6811c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4773', 'swusafmehtaaxgxGP', 'Broncosuk', 'michael.brent@comcast.net', '$2y$10$NF5HEvorv8YpkKkgE0XdS.U28qWK8eWjvi4c2j6zY/PVW7TO9bZcC', '1', '0', '2019-03-13 06:47:36', '0000-00-00 00:00:00', '786479c6d2f6bab2030684782562bc9b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4774', 'xvusaymeqtiidqsGP', 'Furrionrrb', 'steffen.hintze@heimundbad.de', '$2y$10$hByzER1V9LxsVVFJ9FhMbOI.USbIJ4ZGqS.RIbrf6r/tVcWWEipwq', '1', '0', '2019-03-13 09:18:59', '0000-00-00 00:00:00', 'f0ef9d3a762b362cef9daca6c53bb367', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4775', 'xwusafmexnficfoGP', 'Batterylby', 'sbennett15@stny.rr.com', '$2y$10$cG9H1/MgB/8jo6jfTrbrYuSqcC6.H9YQ5ubd8cn9qV5OIKxChs9ca', '1', '0', '2019-03-13 09:20:19', '0000-00-00 00:00:00', '07e875283902febf166762d98688867a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4776', 'xzusafmennxndmeGP', 'Foamspn', 'aivethc@yahoo.com', '$2y$10$919bgM4mgnZmn2oAZJCase2FC9UDTCRc/1l5dyY/eDfLskYnR1T2y', '1', '0', '2019-03-13 14:09:53', '0000-00-00 00:00:00', '31b21cb412050fa647e4c1fb1d451c8c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4777', 'zvusayme2nhdceoGP', 'Wirelessjej', 'braithwaitebyrle@yahoo.com', '$2y$10$lSLR95eau.hyV5kaq2QYaOJhaDwgW1oxsmM/OAGlH1m9jjCWDe7DC', '1', '0', '2019-03-13 14:32:49', '0000-00-00 00:00:00', '5a67fc6b3bf52e938a68c5f9d7349c26', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4778', 'zwusalmectetchjGP', 'Pouringycj', 'ryan.d.mcclay@gmail.com', '$2y$10$9iBWyricGShboaF2AvPsPeNo7CV5KvDL2TLxODrgp9Zp6JXUklFWq', '1', '0', '2019-03-13 18:56:55', '0000-00-00 00:00:00', '338f935ef6a3e209a0712ad2d91840f3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4779', 'szusalmeinxpzqqGP', 'KitchenAidhkz', 'mwilson@deimports.com', '$2y$10$owbom9jGHWUzzxubYGfHveobJGOQtSQBIAL63.RmG6vhphiCOBg32', '1', '0', '2019-03-13 20:57:12', '0000-00-00 00:00:00', '19076371035b4907c863acb30df83ae9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4780', 'zvusalmeytkwxorGP', 'Mojavebsa', 'dianelquinn@gmail.com', '$2y$10$HaluoIf8REHUoJ0X6VTFoOKigZR1Xt.8t8HXP5syempusqjfqCasa', '1', '0', '2019-03-13 22:17:58', '0000-00-00 00:00:00', 'b3f7e68afb142b8d8caad0a3f71f6c5f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4781', 'LarrytsefVC', 'Larrytsef', 'vladislav64bo@rambler.ru', '$2y$10$q1urrlRI5Uje5sHKP3ShOuJmLfOYWjSzHvLduCUv3HEUuiMZA/N/a', '0', '0', '2019-03-14 00:01:44', '2019-03-14 00:14:14', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4782', 'zwusalmectmgxhmGP', 'Juiceribw', 'michael.ciriello1@gmail.com', '$2y$10$b1NgehmOjINmwWC2o9OkY.JUWTYbt.s6Tvpqlw.1GUNsYANK0tGmm', '1', '0', '2019-03-14 03:24:10', '0000-00-00 00:00:00', 'bb76d7e9aab56aae39738658a027a5bb', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4783', 'JameszepIB', 'Jameszep', 'itqdlk@dertul.xyz', '$2y$10$3/KPa3C3wPvA2TRsaowEPOAYbXsfZO8VyGUHZQV4L8iph4T3uESIW', '0', '0', '2019-03-14 07:56:28', '2019-03-14 07:56:48', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4784', 'zvusafmewmbkdroGP', 'Generationylq', 'bobandsue@bendcable.com', '$2y$10$ouNeDEn8piLvvZXn85WWMeuQMLvdoJUAstlQkmvcE6BrmihCk3Wp6', '1', '0', '2019-03-14 08:18:35', '0000-00-00 00:00:00', '58debab82113f8132156cf0ea0074573', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4785', 'SharonfaiftGE', 'Sharonfaift', 'alinaastakhova91561@gmail.com', '$2y$10$A0J7MIq84Yhh03t06I7zu.08obLCV0GU6jtAmuwsx1XFZqJCwbDt6', '0', '0', '2019-03-14 11:21:35', '2019-03-14 18:52:40', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4786', 'xvusalmeanfdxyfGP', 'Dormanyoc', 'jablair517@gmail.com', '$2y$10$0Wbgjug8bhVW83QQv/fxmuYBfTRZpN61QnmT4EdA9314J2JUr9ajC', '1', '0', '2019-03-14 12:52:58', '0000-00-00 00:00:00', '8525c138bc8819262c713327d7d376e7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4787', 'szusaymelmtvdbdGP', 'Holographicvob', 'louise.vanbutselaar@web.de', '$2y$10$.lwUAYw5OkTke9xvWWcspOc9hU9ALUL/ym9UdINsfgz9/sdLL/b/6', '1', '0', '2019-03-14 16:31:08', '0000-00-00 00:00:00', '9cfe5aa84244169b13119ca9b90b2573', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4788', 'zvusaymejtbmxsxGP', 'Flexibledxo', 'moonycharmgirl@icloud.com', '$2y$10$2ieUQhlIA6wB2CLNmImaZ.tnhBZ.2g1yF/jmtfHyR2A4aIuTEfO5i', '1', '0', '2019-03-14 21:58:02', '0000-00-00 00:00:00', 'e18ae0149e1a76b4f4725a4984ad035e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4789', 'zzusaymeftehdbrGP', 'Professionalnqo', 'nunziapasqua@tiscali.it', '$2y$10$qCuR4gC/HEGOZ6Kbo3VjReTBb96IcyZGCs/Qj.NlBtD.4bZsVZlQ2', '1', '0', '2019-03-15 05:10:05', '0000-00-00 00:00:00', '28c357a6e258eb7a71657762eda2a893', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4790', 'JakesHixKQ', 'JakesHix', 'vasiliymuc6@rambler.ru', '$2y$10$iAtDT1cK2Ap4w2o88j61/.gdfWKp7FXZFkHyM/2vCAsNfbxmr6FSi', '0', '0', '2019-03-15 06:19:03', '2019-03-15 06:21:31', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4791', 'swusalme3tmax3oGP', 'Haywardyqv', 'd-k-wilson@verizon.net', '$2y$10$VBZCdq9wwBCETy1L0SyyzuwR2hPFuJAGhtHRyh.kfySq6RmsY3YOa', '1', '0', '2019-03-15 13:39:39', '0000-00-00 00:00:00', '5df0fd811b5393233279cf19330eb29c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4792', 'svusaymednwhc2pGP', 'Speakerqqm', 'efbizgages@yahoo.com', '$2y$10$ioxvXLY.cGvIY3ugHzECdOl2FrfegDgix0RGwng7FXb9g7ZyQobMa', '1', '0', '2019-03-15 16:56:38', '0000-00-00 00:00:00', '16f22f0a6b7be6ec4e375521e6e848d7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4793', 'ArlenaNepayTX', 'ArlenaNepay', 'zen341@taidar.ru', '$2y$10$FKnp.7ULYmuh/LmaKUvnEe4.HKpF6N1wzL6WYWZErtcAlm7s6MGTS', '0', '0', '2019-03-16 01:42:33', '2019-03-16 02:12:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4794', 'xzusalme2mikzxnGP', 'Annotationsbpg', 'mc54ever@aol.com', '$2y$10$xwftw25NtA/r6b4VewgDM..SzyPupCSNbaRTkEdYMh0IvSKN6UPle', '1', '0', '2019-03-16 06:52:07', '0000-00-00 00:00:00', '681e7ec44d2fe9d9214fdf7a8086d885', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4795', 'KolyatrutenPI', 'kolyatruten', 'kolyatruten@yandex.ru', '$2y$10$r1TuDMwoHaBbW.eP9GS9tOl978DdfX61/z2vy.6CqteZG5ZgRvxoG', '1', '0', '2019-03-16 16:48:49', '0000-00-00 00:00:00', '2c98e6c88a90b011e81652db3b9c274d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4796', 'szusalmezngsdfeGP', 'Squierrmx', 'indonneumau@mail.com', '$2y$10$Tupn9fygF/cXMcAPUS68FOqSc/tZIHMO/IirVBXWqDV/Ach9vXByu', '1', '0', '2019-03-16 21:47:01', '0000-00-00 00:00:00', '07097a9ae91ecd3b3ce9653161cdde8a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4797', 'hheenniiaaaSW', 'hheenniiaaa', 'rtyui.rtyu.2019@mail.ru', '$2y$10$iRrJ8HHD2ia1i4.wVTcnwOBcjVVbN.4JjxJnktz/gXAWvK07O2p/i', '0', '0', '2019-03-16 22:24:34', '2019-03-16 22:30:47', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4798', 'milanahvostova', 'milanahvosto', 'milanahvostova@yandex.ru', '$2y$10$1bzaqNx1mnv8s7GOA8QLwuETLW8ADfRuB5pgUa5ubTMjp9OV1nneW', '1', '0', '2019-03-17 01:25:01', '0000-00-00 00:00:00', '72d5c55b91cc8aeac6bb67e4f8b8026a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4799', 'xwusaymestxsxboGP', 'RainMachinefcn', 'svshestova@gmail.com', '$2y$10$bOv5GdGEIqqJMDRMrznifuXJS1Vl7sQPcpmosYRZ02ePhyRdNAW3O', '1', '0', '2019-03-17 01:25:05', '0000-00-00 00:00:00', '5a7015201baca88c39a66f0181eb34f8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4800', 'RuschckinaiGQ', 'truschckinai', 'truschckinai@yandex.ru', '$2y$10$OOmNPe3syo4uaLs7dZeCkOkpo1qrk1wmVhM9Q1arKRGz1i2M1aoyC', '1', '0', '2019-03-17 04:36:33', '0000-00-00 00:00:00', 'f4648c78b83ac06406b0cfb939dffea0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4801', 'WillianvefOP', 'Willianvef', 'nikolayma44a3@rambler.ru', '$2y$10$KudEnwg3w0nfXg3UcXOx9eZztzoeC9ouX6lXfI2sjdSqJ0DWXP1h.', '0', '0', '2019-03-17 08:35:01', '2019-03-17 08:36:20', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4802', 'svusafmecnhfddiGP', 'Beatershi', 'rjatmplacementgroup@gmail.com', '$2y$10$.DrffZ/xAMK8fQ5fDHPhhOSLAUynDZEJfgNqGwlX/.KxsQ5obQnjW', '1', '0', '2019-03-17 17:32:47', '0000-00-00 00:00:00', '3854516cdc15957af8a2977c3ed58255', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4803', 'GadkovskayaRC', 'gadkovskaya', 'gadkovskaya@yandex.ru', '$2y$10$jsFtSZM/BiN3Wzx2HdNj3OBV6PJqA0GuyI2nVtI577uZIkYL1H97q', '1', '0', '2019-03-17 17:36:47', '0000-00-00 00:00:00', 'a64233aaa898955b468dac7b5da38a2c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4804', 'xvusalmejnyjdfnGP', 'Visionrjw', 'freakusehar@mail.com', '$2y$10$TeYDMSJMyxTdrthWTRO7duGFt36c0JcSUHP9t9mNtbh5iGFSZjI9.', '1', '0', '2019-03-17 18:20:37', '0000-00-00 00:00:00', '22826aad63aa595d3ceb0ddcc276efe5', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4805', 'xwusaymeintqztlGP', 'Boschlhu', 'sbergdoll@mhec.com', '$2y$10$WizGQlz/WQ6igOx8iBd5K.vsa0vqUscXQHEe3X.1TQMLhcD/tAgke', '1', '0', '2019-03-17 19:23:08', '0000-00-00 00:00:00', 'd8159af611164b68b2289c373aa50e93', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4806', 'zvusalmeonzycivGP', 'Dormaneed', 'sterzenbach.c@gmail.com', '$2y$10$yxV/Ns9alIVDtXSHOFbjsekwbCkjai02XRUtyaa/YXjZWygq1UIOq', '1', '0', '2019-03-17 20:53:49', '0000-00-00 00:00:00', '3adbb6aa393e72600865baa7d0f7e364', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4807', 'xzusalmeptygccfGP', 'Arnottqde', 'clarkem2@gmail.com', '$2y$10$PsSgE.H5f2HJOZ8NHwjeHez9u0cFMWSc87Y61WdOJwmjXDDHnbCPm', '1', '0', '2019-03-17 23:12:32', '0000-00-00 00:00:00', '0fd7b0a93dc9d964a256ce1bde195bd7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4808', 'xvusaymeptoszjiGP', 'Furrionqfa', 'kmullins@hoffmann-usa.com', '$2y$10$0rvyxvlj1KkxMy.wrFFs0uepUg5YycBcQp3Ty7d/XIeqk/TSlFHG.', '1', '0', '2019-03-18 01:59:39', '0000-00-00 00:00:00', 'e5fb13207b9e08eda61420a023af4ce6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4809', 'swusaymecnfecdpGP', 'Bluetoothwqx', 'nsupnet@easthillsinstruments.com', '$2y$10$.lxtCIcNw1Kh3wnMaRvZRuFgJe.n6Ifz3LN0zqggvCy6JF8VlZXQ.', '1', '0', '2019-03-18 02:30:02', '0000-00-00 00:00:00', '49a2c400eeeaa0778267160580ad3c32', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4810', 'xvusalmelmgaxvuGP', 'Candyfxp', 'vaj.nary@gmail.com', '$2y$10$4kZB7E6vhbdBBDc3UQBW/Op6occhRQybiiZMrLtUtxqTSWzUXhcxO', '1', '0', '2019-03-18 10:11:22', '0000-00-00 00:00:00', 'f588a5afc02c2dabff40b7b91dd9378a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4811', 'xvusalmeunebzqcGP', 'Holographicugc', 'bethanyroosa@gmail.com', '$2y$10$5EPFBiaHBX7g6IM4tTNCm.4r1eo7x0XdvP/hhiA/QZ7suEtpPL8EW', '1', '0', '2019-03-18 10:24:55', '0000-00-00 00:00:00', '9302002967d9b8e912d5630538d69492', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4812', 'xvusaymegtpszmdGP', 'Ascentzws', 'larry@keroseco.com', '$2y$10$T43cUWUzdT5FukwjeYbY6.EirdET.WWJVXEnh0731cwAqN3kMaqOW', '1', '0', '2019-03-18 15:45:57', '0000-00-00 00:00:00', 'd15a31d6f15b0578097002f9fe99a11a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4813', 'zzusalmebnewxkeGP', 'Furrionrmb', 'nette@sim4kids.com', '$2y$10$v3iinENITzpq/AhltvL0EuCxTsNOrxuUiNfXcdGs7908bRwjhFOjG', '1', '0', '2019-03-18 15:58:21', '0000-00-00 00:00:00', 'e3975794ffa7bf6fff4f9bd57e5db6c7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4814', 'swusafmeytcgzrwGP', 'Blenderzdp', 'louis_bisceglie@neimanmarcus.com', '$2y$10$7hSAoSqgu/IWg6hNrIYzsuU2UIeYU02EcdPo8k.VUg/BR3o4ADg.W', '1', '0', '2019-03-18 17:12:01', '0000-00-00 00:00:00', '311f16825089e2d48c37016675eaf193', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4815', 'szusalmeftyhxmrGP', 'Zodiacayx', 'dlf@landdynamics.com', '$2y$10$5kkxX4pIzLa0v6FHhWkIl.OlmI7Z.Fig6XstZcZKTPxr.8qQebATC', '1', '0', '2019-03-18 18:51:42', '0000-00-00 00:00:00', '424352389f3b1c4ec79acfc9638a18c4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4816', 'xwusafmeatuudrcGP', 'Beaterqbm', 'ssandoval@jecofsb.com', '$2y$10$ekLS2EeffgQGHtpsjcD85e37R0VfLYB7sZY9yUO1/Rp3JynC55EQ.', '1', '0', '2019-03-18 19:48:43', '0000-00-00 00:00:00', '03a8c084dc5d934a686315e7ac70e87c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4817', 'svusaymertqxdxaGP', 'Holographicsxb', 'bpreston2@cougarmail.collin.edu', '$2y$10$0uL2EU2m.fZhSe1Fz5hife4j0dVbLq8SvG7oVJ6lybWW3/7xDYLue', '1', '0', '2019-03-19 00:42:26', '0000-00-00 00:00:00', '5a54968444ec5fbaad8d817f6f5163b3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4818', 'Vtroense4', 'Vtroense4', 'maratmelnikov2018@mail.ru', '$2y$10$qaZJtSy1qAhc9FzRVkSxWuKGD7ycqQCtiI.9Oex3AnSaOxgwzqPdy', '0', '0', '2019-03-19 02:34:09', '2019-03-19 12:22:20', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4819', 'zvusafmektyvdpwGP', 'Dormancov', 'jerry@hotleathers.com', '$2y$10$8ZEbeb4mhm4ogMcjpyHky.4XrTkJ1lrg/CJLcUztuilw29RNfjHGW', '1', '0', '2019-03-19 03:32:03', '0000-00-00 00:00:00', '91cf3b7bc5d0418ae8359a55b6ce2943', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4820', 'xzusalmehthgxamGP', 'Dysonokq', 'lylemcv@gmail.com', '$2y$10$po6Sx9wk8rKj93mDf94xr.mPifZtv2zJG13pyD9r6j67mAKJEHtr2', '1', '0', '2019-03-19 08:18:12', '0000-00-00 00:00:00', 'e36ab7e3d729815d72d7bff2805d8218', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4821', 'zzusalmeymcwzjuGP', 'Airbladezra', 'jrolsen24@yahoo.com', '$2y$10$T3ee9XeUUB5KWwF0ISs3KuFqtTtCT1rrr.GmXClFK3tm9RKl2C3t2', '1', '0', '2019-03-19 08:35:06', '0000-00-00 00:00:00', '55b65227a0ac0e2ba18d9f974fefd32a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4822', 'xzusalmektrdxcpGP', 'Incipiodin', 'megan691@hotmail.com', '$2y$10$hFe8yQbRlJnpz3T3pzHbKuROO8utyFMYHp8xxvrTPEv41xRsCm1fy', '1', '0', '2019-03-19 15:58:51', '0000-00-00 00:00:00', 'e0f322ea100d18efad7b268a4904b473', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4823', 'svusaymelmhvzjeGP', 'Yamahafnr', 'ara@karkazian.com', '$2y$10$17I77CzP6SlFfKsdAEMwB.88.Oa6E8Y9FjlKutOWVW1fWekU2wWqy', '1', '0', '2019-03-19 16:57:44', '0000-00-00 00:00:00', '367b625640ce9a33dd717f403892fb22', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4824', 'svusaymevmsicxfGP', 'iAquaLinkufs', 'bjbergman@comcast.net', '$2y$10$tjMuBdi6KiKlAjAsHIwrBuq/1sLsHAUKt2hCgCIXx95SHFH0lIr9O', '1', '0', '2019-03-19 19:15:15', '0000-00-00 00:00:00', '807b4fc03d35bf1caa04f5b1159958b9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4825', 'swusalmeamcldihGP', 'Rachiotkm', 'mat.uk@yahoo.com', '$2y$10$1wOBBH5NmciLC9BFd8zTnerAowOl4.6B96giH2Vt5R2Ta0GrsADcC', '1', '0', '2019-03-19 23:04:19', '0000-00-00 00:00:00', '310da0258b78bcb4d6573cdd3f79d578', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4826', 'dtelizKT', 'dteliz', 'vers@cryptotokens.me', '$2y$10$sDs4P3O9QUaBapoV2EB.a.lCoTcbZaSrtUE25o4bF9rmDOm/oTHmC', '1', '0', '2019-03-20 01:05:55', '0000-00-00 00:00:00', '00e280dc5fe5d1eeda1f5483786d19ed', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4827', 'szusafmesnfuzkmGP', 'Rigidygt', 'benthemute@gmail.com', '$2y$10$h5jL9GCpPtaQsKicrSNgCetBEBYQ7qTOhqbq/DQUp9cEQOQHFQqRO', '1', '0', '2019-03-20 01:47:22', '0000-00-00 00:00:00', '5c002aae32f9cdf692230b5e929adcd9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4828', 'Виталий', 'viadwelvia@inbox.ru', 'viadwelvia@inbox.ru', '$2y$10$4YNH1AuOrYFHHd/Qy1ed1uzIr.45RPGVkwwVlym7FHJoD6fzUA6cO', '1', '0', '2019-03-20 06:42:17', '0000-00-00 00:00:00', '7b7632679bd2034172b591928d305694', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4829', 'zvusalmepmfgzgcGP', 'Clamcasetps', 'ruovomuddsigh@gmail.com', '$2y$10$C3W0jjjSDHt2RyDfhaEW6uID2DxG9q4GbokAuIgSHVqUNgiKMM.HC', '1', '0', '2019-03-20 10:14:37', '0000-00-00 00:00:00', '3fc84e0a4ef3093d1c458faa90e5c43c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4830', 'zzusalmeomgixblGP', 'Rigidljr', 'lumbeequeen06@yahoo.com', '$2y$10$Mzn3YfnyXt0efZaQzsmxlOuoRIOyFny35fVoQ7nO0LbPx321L9trS', '1', '0', '2019-03-20 17:18:20', '0000-00-00 00:00:00', 'cbd2a24028759d826caa050b1ed104a0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4831', 'zwusalmednhmx2nGP', 'Generationpwg', 'davenet20@gmail.com', '$2y$10$niC2NpkwkMOQZvW.fmHHN..KzFVRAX5GsUU.CNQOhtP3X1uop1hhe', '1', '0', '2019-03-20 17:24:29', '0000-00-00 00:00:00', 'd08204f6c6faa35e5807746f2066d4ca', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4832', 'xzusaymehngwxjlGP', 'Infraredrkv', 'jgonderman@me.com', '$2y$10$2Mgv4iZQM7F.MILiOapq/OYfWofEz7ZchH5MnU.VlYht.5uYPt7/2', '1', '0', '2019-03-20 21:43:40', '0000-00-00 00:00:00', '592873e73df6c02aaaf2ecf1925ecc60', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4833', 'zvusafmectwbzdeGP', 'RainMachinegng', 'serg679@yandex.ru', '$2y$10$2iqWQZjbLqA89K2E4Db2WOz.scaKO9HeaZ52XfhaLz9N0JBYNqG9a', '1', '0', '2019-03-20 23:26:26', '0000-00-00 00:00:00', '7e328bfcc2793f7630f4e9809e944f3e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4834', 'szusalmeqnotxtyGP', 'Incipioqap', 'wolffak60@aol.com', '$2y$10$wWgYuJpY/s9dYRTQkzSUkun8j6snFTJWkMQeDGG6HZ1puonbWisue', '1', '0', '2019-03-21 00:17:14', '0000-00-00 00:00:00', '2ce4b31c72ab556f65cf9a7b2420d5d0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4835', 'szusaymewnscxwzGP', 'Edelbrockelm', 'admin@ewmgroup.com.au', '$2y$10$OxT5g2o8gTc27qbeBwwsoeZhR7DYrEWOmziO9Vy4oKCIp5xxo3Rie', '1', '0', '2019-03-21 06:43:47', '0000-00-00 00:00:00', 'd46bd5ba7082a1b30b53c2f3d295ae47', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4836', 'PaulafuhLA', 'Paulafuh', 'zen342@taidar.ru', '$2y$10$e1x.m/eN6iI/36g0lCJmg.iZW2x4DL10GXTf/vMUbis3sFjd0hMyG', '0', '0', '2019-03-21 06:52:55', '2019-03-21 07:26:53', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4837', 'swusaymegnxcxmtGP', 'Vitamixdnl', 'babyjayden809@gmail.com', '$2y$10$sLfSi8XMzOL6pPmHmz0KTepp9KpF2EORoHSV7ca/0TVpSGddzapyu', '1', '0', '2019-03-21 14:17:00', '0000-00-00 00:00:00', 'b8552f1351b6fe7f5c67444b8736d694', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4838', 'zvusaymejminzilGP', 'Batteryjcx', 'khemmila@mkstores.net', '$2y$10$8DCVdjpQrrtvCEHBsv0GtOgSG6t8SGwSq5mpfPAv/y.W6ixHu3p.K', '1', '0', '2019-03-21 16:09:58', '0000-00-00 00:00:00', '4523f67d2d13cda7b5ab8b4993740806', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4839', 'xwusalmeznjedumGP', 'Ascentshc', 'debbie.daniell@douglas.k12.ga.us', '$2y$10$3P9CS8use9iGtRFNIgdpEuXDEZ5lRNkqj15o8fmBV5gdRWxJmuAsy', '1', '0', '2019-03-21 18:06:51', '0000-00-00 00:00:00', 'd82e789ee33cbce6beea2636e2143549', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4840', 'szusaymepmhhd2sGP', 'Beaterwrg', 'naomirarmen@yahoo.com', '$2y$10$7CH28Q2eAmbky7Kz6AEEE.u1CRd4.TpCsmHPsjWJeTzwuDASnbQFS', '1', '0', '2019-03-21 21:54:30', '0000-00-00 00:00:00', '2ea4ab253db1004f1a8478ee3fb07601', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4841', 'PetersaifyXQ', 'Petersaify', 'zinaida.kozlova.1967@mail.ru', '$2y$10$4kV55eUzWIjU9yaoDZPwnOuT9Nhb8JJc4U2ktU81P7xp6jhjMGdIC', '1', '0', '2019-03-22 01:57:55', '0000-00-00 00:00:00', '206dc55ebb16929773d993805a0d4625', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4842', 'szusaymehnmjxdrGP', 'Testercpa', 'turtleisland@tid4u.com', '$2y$10$Nm5geD.HqX8AGczpbJEgUeEkcFOedy9S5fNU1Be8PGdobG5nXs1ri', '1', '0', '2019-03-22 03:56:41', '0000-00-00 00:00:00', '1184842cfa8ee827bb3f01f2bfe48910', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4843', 'xwusalmektlczwkGP', 'Vortexnhs', 'dawnetta.winters@gmail.com', '$2y$10$rpHzWmDEB38MybomyX7M0.wTwDnknpoV7OlJ8wrAqMtkvl0N7bNu.', '1', '0', '2019-03-22 10:31:11', '0000-00-00 00:00:00', '570b57008c98478ee25e148024f0df74', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4844', 'AndreaLabJA', 'AndreaLab', 'adriammy8@gmail.com', '$2y$10$u2kByAEOu4aHLhKDZRPI2etuComjQr/w6DKU4k.d2NR4LD/jjzpT2', '0', '0', '2019-03-22 12:43:43', '2019-03-26 11:55:30', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4845', 'xzusaymeetdbcblGP', 'Feedermem', 'noetahester@sbcglobal.net', '$2y$10$41OaJCZd/ydsJHfM8j3x7ee4cNUGYKWQ4/TqjxZHsnyEDJRJjhZnK', '1', '0', '2019-03-22 16:19:42', '0000-00-00 00:00:00', '0511300c7cc41ccabc0959ddf36002ba', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4846', 'zavorotnyucknCD', 'zavorotnyuckn', 'zavorotnyuckn@yandex.ru', '$2y$10$huyyGgMBeM3Q9C0tg5g7auaPtvnFllXNl77qyoDZdzc.5yImTSxTu', '1', '0', '2019-03-22 17:45:54', '0000-00-00 00:00:00', '973c8d8f7f24cde081e386c32f86176f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4847', 'zzusalmevtrexilGP', 'Artisanxyu', 'tammi.jones@npisorters.com', '$2y$10$A9c4kV6UAaAYpsSCms/mvuk8vje2X41gjUoZVSP/S.YJYlurauKqi', '1', '0', '2019-03-22 21:03:00', '0000-00-00 00:00:00', '203f4630a69123f87d338656e0dbbd65', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4848', 'StevensetRR', 'Stevenset', 'pavelre0ryabov@rambler.ru', '$2y$10$nfdKA5MGkHI2kFhFPS998eRg9sTTt.IOH88odPHuANQ.ptr91MnZa', '0', '0', '2019-03-22 21:37:42', '2019-03-22 21:38:05', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4849', 'xwusafmekmbxzbtGP', 'Professionaltve', 'jprehm@gmail.com', '$2y$10$oEWJsSCZDdodARW4vnJY7eww0m5oX52w5nvnJVQ/1py7wrE7DrNNq', '1', '0', '2019-03-23 00:00:19', '0000-00-00 00:00:00', '8e035f7986e06feb916b2f8c4ae4b68c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4850', 'xzusaymehttdcdsGP', 'Ascentwgp', 'atridtuolu@yahoo.com', '$2y$10$.tVBQ5nwj4mBiFzrQ/fpj.nQFlHxc18w/R0gZ0/2KckD188VFctR2', '1', '0', '2019-03-23 02:11:56', '0000-00-00 00:00:00', '61a86a5d4aa8176db974a4f055255c75', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4851', 'rybkinaelenokJE', 'rybkinaelenok', 'rybkinaelenok@yandex.ru', '$2y$10$OZMp4Ch8bkw2nYZDwcGLd.7HpO9WGaXYgPqvGsJfVDLJ.lSaU1qvW', '1', '0', '2019-03-23 04:55:27', '0000-00-00 00:00:00', '811594e6b85fdc29e4e82ed65c700bf9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4852', 'xzusafmeztsmcgaGP', 'Garminzbqh', 'ian_macgregor@lobsterplace.com', '$2y$10$aMH66pOrKO/IHasZ1bemUO3Ms5O60jCM671dxseJovroWX6aS.iOG', '1', '0', '2019-03-23 07:02:03', '0000-00-00 00:00:00', 'ba05b07c1d7c34c0144be366c998ee1e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4853', 'szusaymeemljxpgGP', 'Drywallwbg', 'brianl@techcontrolgroup.net', '$2y$10$1FIhwOU/bjyVGBVKBqvZMeiPx27RMzRwxYdischCqYxPdo.V4tpI.', '1', '0', '2019-03-23 17:49:20', '0000-00-00 00:00:00', 'b3be68918ccf28c2ce3a0a4f81523364', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4854', 'MichaeliMambCT', 'MichaeliMamb', 'temptest562853434@gmail.com', '$2y$10$4f1LNAe40cLg2yze.xKkBO69JpVi46vvfA9c1F7XZkp9oG7YN2QsK', '1', '0', '2019-03-23 18:52:11', '0000-00-00 00:00:00', 'c25720e0015e583bd0b82c4576f19e2b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4855', 'swusafmegnhiz3vGP', 'CHIRPdbj', 's.mensert@wanadoo.nl', '$2y$10$OJ7DhFHvh8BHDR0FRfMMre3eQ17oXjBYEG08dMhLVbNA1JHFYK6KC', '1', '0', '2019-03-24 03:44:24', '0000-00-00 00:00:00', '97c55c7209f00f3ec36e02b088ae08d2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4856', 'xvusalmeomdicruGP', 'Sightanw', 'osmgeak2@hotmail.com', '$2y$10$0CIIZz6KZP2FQ6owu5pyDOIm4pqUq/ENxx7Ky7ztPqX6mYxGXgVle', '1', '0', '2019-03-24 04:09:48', '0000-00-00 00:00:00', '9c5534cbd452d1b0f7355d4720700c54', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4857', 'xvusafme2midcolGP', 'Beatervhv', 'elcealepers@yahoo.com', '$2y$10$NBhLEyI72PxUiXsPNfYI/e0HAUF6xLFGdsrJlgeRqkZyEyOlO83bm', '1', '0', '2019-03-24 05:25:35', '0000-00-00 00:00:00', 'e01eeaa65551e4c2e59b71468f73ce4e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4858', 'zzusalmeznduckiGP', 'Garminzbjy', 'randyf@paulbunyan.net', '$2y$10$Dqo6y8ppy8HTHeW0dVrvY.6tGPecztTXq0D63Z2vOquyxA0FEJvkm', '1', '0', '2019-03-24 10:43:26', '0000-00-00 00:00:00', 'e84f1f5f6cf810f2aa7a40908fd9b389', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4859', 'svusalmeankdzqqGP', 'Garminzrfo', 'smlykat@gmail.com', '$2y$10$fGp.PQ/zNyLCyZBqA.JmhOWKIBNPS5zQ70cPBBZDCujZXPwWh6z6q', '1', '0', '2019-03-24 12:13:35', '0000-00-00 00:00:00', '627c13347e6c0c338ac91b73a6769bfe', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4860', 'swusafmeunfrdwjGP', 'RainMachinefhu', 'miker@slammerlogistics.com', '$2y$10$3d2fPux3xyjVwQQsLY4pWO3fk3fVOVg6iKYj5KDLpcuWsAN4rt05O', '1', '0', '2019-03-24 18:46:24', '0000-00-00 00:00:00', '8acf0ac6a939776cbae1a5798e59f848', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4861', 'svusaymestuuzecGP', 'Sanderibu', 'rvschaijk9@hotmail.com', '$2y$10$dVAf.zHhN5lOD3J30uZHSuZJu9EReluPoHUwsHE18vyo2R5E2hknm', '1', '0', '2019-03-25 08:07:18', '0000-00-00 00:00:00', 'e714a9a99edbc71f44b64fa03ba2a711', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4862', 'zzusalmeatdtcviGP', 'Irrigationcjp', 'unamalas@mail.com', '$2y$10$.2UEVyDW89DCsyNmy42IQeCEYQBEHSkLBkNZiJg05Fb3ykglBEtZm', '1', '0', '2019-03-25 12:34:37', '0000-00-00 00:00:00', '5906d1131090d5d32287f0612714debb', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4863', 'swusaymesmdqc2wGP', 'Beaconehg', 'thadeus12@cox.net', '$2y$10$T1gfVw7VloP00FQmX49bVOb9SlRkxCGN5he3h.SaJ7pv57uaGW4XG', '1', '0', '2019-03-25 17:01:41', '0000-00-00 00:00:00', '108a4cf6e07fe4f8c76f65017c07449e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4864', 'zzusalmefnercjdGP', 'Rubberynn', 'ashdw@nemont.net', '$2y$10$P4CjYcTQmda/msbH.eJcB.JrMctyoKP9yf1G10ekAx/xB.HHHEIOS', '1', '0', '2019-03-25 22:22:37', '0000-00-00 00:00:00', 'ac9629b26995b933823ad36562b65758', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4865', 'svusaymeatjrzblGP', 'Beaterpap', 'lklaren@henekfps.com', '$2y$10$dnAGPvubIPvI4jFlZWJebefp1sZonrF9V1KNzStVXrYPn/vupxrCm', '1', '0', '2019-03-25 23:13:01', '0000-00-00 00:00:00', '1703dee8948a7e1ada06589d378c1283', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4866', 'swusaymetthrcskGP', 'Edelbrockmhi', 'evrusalazar@gmail.com', '$2y$10$eqlsmQ9z2GcrryRgJcTfoOgGgXDT3lJMNg8Vn1Y541MpxFMP4Cfq6', '1', '0', '2019-03-26 10:44:23', '0000-00-00 00:00:00', 'c777e40061707b6d538b1e0989d0abe3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4867', 'swusaymettgpdbhGP', 'Interfacedln', 'tbatty752@yahoo.com', '$2y$10$gqWhWEVPARUIL0T3n4yxp.7SQ8WymA3RpNUFJNkgsZT0V9dzbuNCK', '1', '0', '2019-03-26 12:03:41', '0000-00-00 00:00:00', '3edfa36d0ea64f159fa8a6a831f8025b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4868', 'xzusafmeltpodeoGP', 'Garminzkhu', 'wucci209@gmail.com', '$2y$10$SUQ82Q8I1inxJzMccoOhEeIUHKN56NQbBTz8v2xDLOuXAjFFG2JKC', '1', '0', '2019-03-26 13:45:20', '0000-00-00 00:00:00', '01432e0c48da42df0fba8fa1104aca1b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4869', 'zzusafmeanzid3aGP', 'RainMachinerki', 'tdredfoot@gmail.com', '$2y$10$ktPWcPBXlAxCpIjo8rpoieIcelQv6E7Ep9Lmm9xRkYlBjG6.NTPK2', '1', '0', '2019-03-26 14:44:54', '0000-00-00 00:00:00', '50d3771e7e382b7e60d007f49ef9292c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4870', 'RichardDaxGU', 'RichardDax', 'zen343@taidar.ru', '$2y$10$2jhnQbVbf9wEL0f8IMfQV.t5jnNoxwWl1.Qx9ejObnXsAB3aM48zu', '0', '0', '2019-03-26 16:20:54', '2019-03-26 17:14:45', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4871', 'xzusaymextyydfpGP', 'Avalanchewsi', 'aaronsorense@gmail.com', '$2y$10$eYIg9.BI8rgx/2fuSMO6BuVxEpL2pwJQQgbMZ./UQFtHWG.1/W7ZS', '1', '0', '2019-03-26 18:29:19', '0000-00-00 00:00:00', '09c46c0844bd3174b1aa95f38f12027f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4872', 'swusaymevtzudloGP', 'Broncotrv', 'tim@williamstransport.com', '$2y$10$tW3q03XuWbMS4SJ1No.Py.2JeAN3DMntzBVvV/cOUKDRzaZ8ohdBC', '1', '0', '2019-03-26 21:42:06', '0000-00-00 00:00:00', 'c91064c4ac92a173f26e7414361b8d79', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4873', 'zwusaymeatzrdrdGP', 'Fenderias', 'orders@nei.net', '$2y$10$qzDZ/ZkRYeAbYYkQsWNqzuVVg7a4opoWAEHcnw9aSYe.Cz91pzIt.', '1', '0', '2019-03-26 21:54:48', '0000-00-00 00:00:00', 'f22b252490bcf42c7b8f06ef12e94815', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4874', 'xwusaymenmbzxciGP', 'Vitamixziy', 'throwthegrillinthepool@yahoo.com', '$2y$10$EcwfemYpXIMb56M//MYtKuAeK4Mj2cgLSutQVMYwkbmKcaNtshv.6', '1', '0', '2019-03-27 01:35:55', '0000-00-00 00:00:00', 'e3322136433b73afc21c71c1449f7779', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4875', 'DevjatninCZMJ', 'VavilinJX', 'm4gers.j@yandex.com', '$2y$10$eADI9hVvIVNQTWzggk6/QuviTGQ6wTvYJahu5Y.7bKAbjWP4d8L8m', '0', '0', '2019-03-27 05:52:14', '2019-03-27 07:06:53', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4876', 'svusafmewnrwxavGP', 'Rubbergad', 'tim.sanchez@gmail.com', '$2y$10$WoESNsbod.skl2fC6LMTluhZPajfl6mqW1t8HwlO6m/fAMjQCIBnq', '1', '0', '2019-03-27 11:37:52', '0000-00-00 00:00:00', 'e47c8ad5d55680c80426df9ac948c4ba', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4877', 'WewEarneraXN', 'WewEarnera', 'eqer43yu@dtdns.us', '$2y$10$ozV8Ra6Db8zr15DLjA9baebq/sqHdV4CyJ5cDEaVPPXasKVHtIjxC', '0', '0', '2019-03-27 11:47:47', '2019-03-27 11:55:47', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4878', 'AkimychevPRQL', 'BelolaptikovYJ', 'd1versp@yandex.com', '$2y$10$A.BwCApgyaFU2lK4RIL7wu7.YRxx3sKxG0AF3giR0IT1Sxcfwtx3K', '0', '0', '2019-03-27 12:19:08', '2019-03-27 13:38:45', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4879', 'MoschinakWA', 'moschinak', 'moschinak@yandex.ru', '$2y$10$bMDnhXJnNvfrW9KO6oAg5OMWbR81gKUix3NIKkoYz2.2oq0tA2OgO', '1', '0', '2019-03-27 15:06:13', '0000-00-00 00:00:00', '8807c93fb7a92076851e2c8f8c6270b4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4880', 'lushinalolaUE', 'lushinalola', 'lushinalola@yandex.ru', '$2y$10$RPAZsAof0EPTorUc645JGOnM/vskqSl/7J6amczYhn5pmR34bWyDW', '1', '0', '2019-03-27 15:53:19', '0000-00-00 00:00:00', '90c6cc84b5ea9547ed4da0c0f7eefb64', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4881', 'xzusaymeenohxrvGP', 'Securityery', 'arnoldbe@yahoo.com', '$2y$10$12kTVewmpZtF052RpsR9UOp2AFH9Cas4GOix2GObzbq4UAzZahqHO', '1', '0', '2019-03-27 15:56:14', '0000-00-00 00:00:00', '04256ca8d21b043bcc62f48cd15b7f7f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4882', 'NikitenkoCGOB', 'AvtajkinXB', 'leohnardgersen@yandex.com', '$2y$10$EW9F.GGwoKd7wPxJGfwoee/4KAPKsC/9qgxI159soOiVqLC6w9lHa', '0', '0', '2019-03-27 18:17:44', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4883', 'solizXO', 'soliz', 'so@serviflora.com', '$2y$10$juzVMmGgLMZxDF39Yd6Ty.SSqMqqeaEf34sDU4y5yv1/v1O37DzvG', '0', '0', '2019-03-28 00:27:19', '2019-03-28 00:33:53', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4884', 'PansyAporiMB', 'PansyApori', 'stepanakx1d5@rambler.ru', '$2y$10$0FqCpnTAzGPKTIFiRcE.vO2RP7BQGPv6hAu5MQKZmqo6EnrIzY2l2', '0', '0', '2019-03-28 02:01:30', '2019-03-28 02:04:45', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4885', 'EvtehovRRMW', 'HenkinRM', 'telamsl@yandex.com', '$2y$10$1.9TYH9NbLFUYQus4TlGNOZ/DtEPd4X4d9oEBiXbqCr4KXStkbcE.', '0', '0', '2019-03-28 03:41:14', '2019-03-28 04:21:55', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4886', 'VanjushinGEMW', 'HarchenkoER', 'dason.vik@yandex.com', '$2y$10$SGD.pI4ztdXUYowtQGsrVuRzXj8heN3Hx/gNY3sL5tyjV1DWC0k5e', '0', '0', '2019-03-28 09:41:54', '2019-08-29 18:54:59', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4887', 'TingaevYDQL', 'NogotkovyBU', 'golers.k@yandex.com', '$2y$10$GHbIOi26H0QMu./yG8tWdeKAp1sEGXcpF0fX8INDO2MWFQkJ9gcUS', '0', '0', '2019-03-28 15:38:01', '2019-09-07 22:05:27', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4888', 'xzusafmehtprd3zGP', 'Clamcasetpu', 'rmgoldstine1@gmail.com', '$2y$10$fUeXDURyHT4C0RkFhsGIo.1EuhIRBi/iT5Ya.crTIwwOIcpJ0OHxi', '1', '0', '2019-03-29 02:57:36', '0000-00-00 00:00:00', 'a131c5fdd6868c191352c6e1535e7e0d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4889', 'PersidskijNCQL', 'BezborodyjFK', 'henselden@yandex.com', '$2y$10$r0WVnXEB37en9Z8ZLh1kmeLoWPiw1si1jiraGu6D9oHTtIhPbqsdq', '1', '0', '2019-03-29 04:10:09', '0000-00-00 00:00:00', '395a59c8b861e11eeaa91480a0cef33f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4890', 'InalazarevskDL', 'inalazarevsk', 'inalazarevsk@yandex.ru', '$2y$10$87AeqS814dNaAvV57giNo.ZK05WLakftlEB.qT/3hM2JIyJiJ/3Q6', '1', '0', '2019-03-29 06:21:14', '0000-00-00 00:00:00', '768134e19908e1d1cf3b9856c998db25', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4891', 'svusalmeynxncyeGP', 'Feederkov', 'kschroeder@seielect.com', '$2y$10$dX9u2ennGU/PCURDnYK8cuxkEAKnGBAULF3ItAwmYklz8KGnu9COq', '1', '0', '2019-03-29 08:04:23', '0000-00-00 00:00:00', 'bf7b671f9e77666af3753529efe30e8e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4892', 'zvusafmeztuwx2nGP', 'Serieslwu', 'andrewsullivan82@gmail.com', '$2y$10$OnN2hl4gRQgRv/y4LX8zNuYi3M5Qc89e1ebwq7eZs8MjfOSM7W2Ue', '1', '0', '2019-03-29 19:44:32', '0000-00-00 00:00:00', '9f47091b381f9ec51f55e90fe4993da5', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4893', 'szusalmemndydyhGP', 'Beaterbkm', 'deanc1966@gmail.com', '$2y$10$raCSIQTxf8QPsdo9gIxZmuHTKVl0hO33N5v3K3NLO1DPC4TDT3zR2', '1', '0', '2019-03-29 19:49:46', '0000-00-00 00:00:00', '932be0af6cbaa47cdc227b49d03be4e7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4894', 'xzusalmeontsc3cGP', 'Blenderquy', 'smithcreek2@yahoo.com', '$2y$10$.Ghci7tdOg2iCQ1Y6UpAgeHvJVX2Ndsk8UHRc334u3Ibquc93dPb.', '1', '0', '2019-03-29 21:10:11', '0000-00-00 00:00:00', '4145ed613213a8b6e2b9f5e01b2f048f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4895', 'zwusayme2msdcpuGP', 'Generationdrb', 'boboace25@gmail.com', '$2y$10$B/qRw4AvmsLKy82IPyq5UOz4u0ERKA1D/Ap6himhXMY4/cW6NMYs2', '1', '0', '2019-03-29 21:26:27', '0000-00-00 00:00:00', '6dcd21c78a11ed22d21ac03bfdf3aa02', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4896', 'zvusalmeetntxxzGP', 'Fenderahz', 'tjohnson7977@gmail.com', '$2y$10$dB3Ye8Wd5ex3WwOHpif1BulEQ80jU5j6v52vuRnkKH4Mzyk/fu2PO', '1', '0', '2019-03-29 22:46:00', '0000-00-00 00:00:00', '986bdc56ad8846d3450cdc82a775a64a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4897', 'xwusalmeittrczxGP', 'Minelabmng', 'dclark@controlplus.com', '$2y$10$wNPunJSHQb578lqNVXGeJ.YxV3EIc4re29naJ0gdhIo8hSBA65rmq', '1', '0', '2019-03-30 01:08:22', '0000-00-00 00:00:00', '2e5ca54f9eef0fb90ff00ae413ae22e9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4898', 'zwusafmeutftdihGP', 'Nespressotop', 'jmd@dixler.net', '$2y$10$67rl76jnQh5KSK53i6XVteAyxxwQEmKIriwNpLqJ5zsmIADwaYoRW', '1', '0', '2019-03-30 02:15:49', '0000-00-00 00:00:00', '2a8b31292357eaa4ac4704f69f7e5133', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4899', 'RomapeikinJV', 'romapeikin', 'romapeikin@yandex.ru', '$2y$10$t23wIQoV6OanJiIkKZaxh.7.qkblc9HT1WWj47IY0N.MNdJED86wW', '1', '0', '2019-03-30 02:18:06', '0000-00-00 00:00:00', 'f0ab824b4b4e3625e00256d01f6aca6b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4900', 'xvusaymejnxycxbGP', 'Amazonnnjbp', 'keith@purehondaminot.com', '$2y$10$ZFlml/A4gClpHRLDeyNvVutyDuglWi0UKAiZ9corkXbpCVTw2wI4S', '1', '0', '2019-03-30 02:45:57', '0000-00-00 00:00:00', '80e6868533685eff5eff97ca81c76ab2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4901', 'swusalmevmpfdoiGP', 'Drywallnpl', 'sarabaron44@gmail.com', '$2y$10$Hn5PPASFJUJBDA/uFFhcZOWLxXwED0xj/cYqVtTyy4V0wa9Ka57OO', '1', '0', '2019-03-30 03:35:05', '0000-00-00 00:00:00', 'b686d57e5238aa8b65420bb99ad6d1cb', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4902', 'zwusalme3nwbdylGP', 'Generationxer', 'gwall6@verizon.net', '$2y$10$t/Rl1UuiH65QqkNqlQc9rexk1hvuXRY4VicyE2Bm4HrOG59ZurpmS', '1', '0', '2019-03-30 04:26:45', '0000-00-00 00:00:00', 'd6285ae40b098271d2699f9f096c1ce8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4903', 'xwusaymeznapdcvGP', 'Rachiozdn', 'services@ayssales.com', '$2y$10$wlLho.J.YzxqZqbxxoStH.8H9yUp5nAVnEe0QImmFhQjUnoRiUD5a', '1', '0', '2019-03-30 04:27:37', '0000-00-00 00:00:00', '5e4de4fce7d4c34be3c72bed86442ec7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4904', 'BennieVopFL', 'BennieVop', 'temptest657429585@gmail.com', '$2y$10$zCq4EK3pdRit8pGxbTdsWe6.cyDl5969cs3wsJ1YoajL4WWnhHw9K', '1', '0', '2019-03-30 23:12:35', '0000-00-00 00:00:00', '2957c747103fb4e0d30a3e29346ac608', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4905', 'zzusalmertfgzshGP', 'Sightisq', 'zubysworld@yahoo.com', '$2y$10$elMuInXFzMwgSgsGBK5e8Ojb/RkAHmzQWwhBLdKrNuyhlF9PzZWwW', '1', '0', '2019-03-30 23:33:06', '0000-00-00 00:00:00', '10670a153e0297e710ad9dab938a4981', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4906', 'RtchubukovaHL', 'rtchubukova', 'rtchubukova@yandex.ru', '$2y$10$KUroaILCUH24M1WvIqCRG.kuAmCb5a181WkM5klLuZzp.2YkXeERq', '1', '0', '2019-03-31 08:23:34', '0000-00-00 00:00:00', 'e74f9c4be8e71fe3dd0872a6d8aedaa8', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4907', 'xwusaymeutnmdrhGP', 'Feederbml', 'accountspayable@tindley.org', '$2y$10$9lbAxkatYJpj3LBVB6yhOeM/RO0kF8yiNPY2xANTaEDuTda6G1Cq6', '1', '0', '2019-03-31 11:24:52', '0000-00-00 00:00:00', 'c1054aa340932f186d99a726507e727c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4908', 'zwusalmeinjpcmjGP', 'Linksyslsa', 'yycho@thechos.com', '$2y$10$Xm1LuBPxxhs/ZDaU/7FsOuH0Hx3ObaB1L4eUgcKJmPHmJplPtUKgm', '1', '0', '2019-03-31 12:58:28', '0000-00-00 00:00:00', '252b4428b9dfa95ef1a45a41cae555b4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4909', 'JrystalMorQE', 'JrystalMor', 'anlapinoh3@rambler.ru', '$2y$10$PnfANwjHepvXXuwNFitTMOHIwIlpy5EhTn2mVXGlAp52IRQFCTw4y', '0', '0', '2019-03-31 13:18:47', '2019-03-31 13:20:04', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4910', 'xwusalmelteocezGP', 'Glasssma', 'support@vdsina.ru', '$2y$10$khhOpK0tGa1rXheIUE5oSuXNrrb0gEyBBuX4E6mdLHC2Zhc9Vn6dy', '1', '0', '2019-03-31 17:12:14', '0000-00-00 00:00:00', '43bae63778e202c9cd2b74fcc9b3538d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4911', 'RzelenenkayaOD', 'rzelenenkaya', 'rzelenenkaya@yandex.ru', '$2y$10$98ulFI3SoPED0d3p6sSJVOd12vm6RlAXQ9KhkrOWGeyEai2.VYEmi', '1', '0', '2019-04-01 04:34:52', '0000-00-00 00:00:00', 'c90325dac3eb4cb14f8ccf26824539ea', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4912', 'MakarushkinBAMJ', 'VologzhaninZO', 'hensel.ven@yandex.com', '$2y$10$Wioj6wqTERalANeLVu.XneY4L2BUMzjFkWeskIYUz9bZ0EcpPtitS', '1', '0', '2019-04-01 10:56:25', '0000-00-00 00:00:00', 'c76f5162d4f9020971845a13bc09956f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4913', 'Julian', 'zaregolapeb42', 'gotaur23@grandloved.ru', '$2y$10$uDB6Gt7P3RVOGOOa0GNNT.zQI2hl6QUDVe0SvWqZPGBVD/RaADetS', '0', '0', '2019-04-03 14:53:23', '2019-04-03 14:55:25', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4914', 'GenevagorKI', 'Genevagor', 'vlaosipovgby@rambler.ru', '$2y$10$uEBBgMmGmZnUykrwGQP0.ezoMR45tXrTbAznSndhT3cfcaBNMsAKK', '0', '0', '2019-04-13 08:12:55', '2019-04-13 08:23:03', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4915', 'swusaymeymnbxrfGP', 'Seriesrxj', 'dm74kane@gmail.com', '$2y$10$s4vHXsKvecnoCGXnNxH0DOElL0wiEbIxam1Q.0zUMfxttY3e33B/y', '1', '0', '2019-04-13 13:49:52', '0000-00-00 00:00:00', '474c1a90ce7f35049a372322795bd427', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4916', 'DavidendokUX', 'Davidendok', 'mihailportnev@gmail.com', '$2y$10$fCbPv.PimVgqG3Lvz3KWA./AGs64olpQLJCzrQ4s/IVfaSDL1cfl.', '1', '0', '2019-04-14 04:57:10', '0000-00-00 00:00:00', '85b8eb0d52727cb655cda3247b814ebf', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4917', 'Renato Horstman', 'renatohorstman09', '27632bonner@enlerama.eu', '$2y$10$PwigWY7/jn853ifSGlNp9.CGTizdgdkKjzsySoUlt4txAUDMyoCEG', '1', '0', '2019-04-14 08:52:21', '0000-00-00 00:00:00', '7e571b985a60430134b04fcd448159c5', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4918', 'svusaymewniydawGP', 'Artisanwzh', 'alyssaang82@gmail.com', '$2y$10$kpvdlgoJF7Uih3qimBOa5O8Mw3TYDSw3Ei6pME.ymP4ewAwdTdDnS', '1', '0', '2019-04-14 11:26:39', '0000-00-00 00:00:00', '54b200e6a2101b6dc6e5c218d474114c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4919', 'xzusafmeqmepdniGP', 'Mojavesfy', 'jenny@grandappliance.com', '$2y$10$gNEddjuC8zKsqQaNBrrewOteQn6VfxBXVl4JaFRvMn1hlvh23QCH6', '1', '0', '2019-04-14 12:35:05', '0000-00-00 00:00:00', 'e4cfaec90ffff5e400eb59d7b8f2917d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4920', 'swusalmeamtfdlrGP', 'Independentzco', 'shodges7175@gmail.com', '$2y$10$m/qQeNTuM8tNP0xVnktkeemISxObCsakQeN9IC/mMa3HH.kE0QvP2', '1', '0', '2019-04-14 18:58:45', '0000-00-00 00:00:00', '73c61c2fe52d47c9071d6220d5d31592', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4921', 'zwusayme3mzfzkjGP', 'Juicerqnu', 'dmarzbarz@hotmail.com', '$2y$10$D4DjfkDkdr7bIHQnsqtoUuubU4owLgTb5bn5cQl8JBjdpKvwSTUDK', '1', '0', '2019-04-15 06:06:51', '0000-00-00 00:00:00', 'fda7ac9eb987fee0a0f056db79b20a03', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4922', 'zvusalmeunzrzjxGP', 'Rubberqxd', 'archuletaem@gmail.com', '$2y$10$elUMkkz5cUuD6JYwJAQGguVuxCvZyJwjNG9bIS6kI4XBxjHWpa5ge', '1', '0', '2019-04-16 16:06:57', '0000-00-00 00:00:00', '430e43c983e813c643a78a2281926b43', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4923', 'zzusafmejmpmzxpGP', 'Batterieszvz', 'sharon@humes-berg.com', '$2y$10$JJRU3Li4Ciwf0aediJi3xeUvdxvCMSBoL2Y4kG9b41nxarKLU40JK', '1', '0', '2019-04-16 19:45:36', '0000-00-00 00:00:00', '6a4884333ae9462cf681a84ac013f22f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4924', 'szusaymeqtumzdfGP', 'Annotationsjdz', 'bill@vdsina.ru', '$2y$10$czvYCDB9KUvUdOWz16lWz.u7B3Cl/8FCz44PPYwzKAaO4Kuf/iF1u', '1', '0', '2019-04-17 00:31:34', '0000-00-00 00:00:00', '975734fb7d37b75a1e4dc952e1190e5d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4925', 'zvusaymeltpfcqgGP', 'Dysonvwa', 'tbates508@gmail.com', '$2y$10$5vXRB2a2Sdqsllx7F3GVTefSd87LAVatYRp.CcMmFpK4h3guWRc6C', '1', '0', '2019-04-17 05:51:48', '0000-00-00 00:00:00', 'd9f0252b4d37e8af631d3a339bb002c7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4926', 'szusafmegnrrdebGP', 'EOTechftv', 'jacqueline.e.doyle1@gmail.com', '$2y$10$pDgxsHBGiJfUlcyZL/WAxubGd2O179Qkqt3RfpvibrTokEg1yUkfG', '1', '0', '2019-04-17 10:16:14', '0000-00-00 00:00:00', '3d2c70843f142b82050f92129e829909', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4927', 'svusafmebmjhzvlGP', 'Minelabmzw', 'bartho0812@gmail.com', '$2y$10$Rs6RyO1XDi1x48kPkwSxV.vpz.Tr0xlAFLqNu83fo9kSxTL3s1kNG', '1', '0', '2019-04-17 11:02:15', '0000-00-00 00:00:00', '6a77b66c2533d4050691dddf3b19f402', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4928', 'zvusaymeingxcxrGP', 'Holographicurk', 'kim@eloquenceinc.com', '$2y$10$BhCFux4veudh54xGvmvOnOVHnYt8o3CNK92SmI7bjt0r16AJ1TZeG', '1', '0', '2019-04-17 12:13:34', '0000-00-00 00:00:00', '4e325ce39c3c0b8af1b87e8955eaaeae', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4929', 'xzusalmepmqrdlnGP', 'CHIRPxlw', 'drmaldonado@d33design.com', '$2y$10$7zo2fy7Y/dVfnKbxUzm1fOTCAM1URYO2atzWTCxlCqi0hEZ/gNKRG', '1', '0', '2019-04-17 19:04:18', '0000-00-00 00:00:00', '0fb81f85d4734ec833231517a2fb4e1d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4930', 'svusayme3nvszeuGP', 'Blendercmy', 'kthickel@aol.com', '$2y$10$sp6pJ4i1fyt.U0N8QPMnI.nsGe5JKp4JpuJ7uqqv3v8iiyCFWjfnG', '1', '0', '2019-04-17 22:59:49', '0000-00-00 00:00:00', '137d2ed46be5ae65f6dc980296ccc661', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4931', 'EdogarDabHS', 'EdogarDab', 'pavel92oal@rambler.ru', '$2y$10$alSULLz5E7Cr/4eqmUhbF.t910QjY9WxQeB.N3TZ7wHA7uVKnAlG.', '1', '0', '2019-04-17 23:26:13', '0000-00-00 00:00:00', '0539c4a3ccd221ff06d442d9e49e4bfc', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4932', 'ClintonjapMT', 'Clintonjap', 'ai8686692@gmail.com', '$2y$10$H5Zy//5x.YsSnekGG7BAgOkoRijgZH/EmYB7I07/CzHYevglr13qy', '0', '0', '2019-04-18 04:15:33', '2019-04-21 21:02:03', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4933', 'swusafme2msndcjGP', 'Sanderxvp', 'kolivito@gmail.com', '$2y$10$otMjqiwhr7I/40mwD.onMOBxkEsHTj2wBb28k/VH7W.048J5eieCq', '1', '0', '2019-04-18 06:26:46', '0000-00-00 00:00:00', '3260599339e387e0b72db706f4680539', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4934', 'WilliamdicTA', 'Williamdic', 'fpachkin@gmail.com', '$2y$10$k2phhZo.VNk4iD.i4kx7auXx9zrD7ZX7Qjb4GbNvL6CJKyr6nSfJ2', '1', '0', '2019-04-18 08:23:21', '0000-00-00 00:00:00', '115504d842c81da70242da4574ea05e9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4935', 'svusaymektqgxsfGP', 'Carpetjln', 'jimmylane127@yahoo.com', '$2y$10$kRK/v61ig6YS/uPWtWBQN.vwS9.zTH5nFOgTwweW3GRA4b.cqjY.C', '1', '0', '2019-04-18 10:32:24', '0000-00-00 00:00:00', 'c2140e4d9aa40438c9fd93a7183e4950', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4936', 'BriceDaymnHD', 'BriceDaymn', 'ekbcargo67@gmail.com', '$2y$10$iIHJdNi4HZmxk7COb/iT6eDIx.aDIAnxaI4HnXlWMRUl.RVmK9Puu', '1', '0', '2019-04-18 16:58:17', '0000-00-00 00:00:00', '1f8573ee26a96cac42f92727dfcd7d4e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4937', 'TanjianuMEQ', 'TanjianuM', 'egor25pblo@rambler.ru', '$2y$10$RtF/9K.EQyA0GejJPSfJk..9K2sERaYQak8oHdX6xY6ik43S7QZOi', '0', '0', '2019-04-19 02:28:44', '2019-04-19 02:31:05', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4938', 'zwusafmednjjzshGP', 'Universalvhj', 'cindy_t4wellnessgroup@live.com', '$2y$10$FusJPb65nDW1ElffC/SrLu4pcKhEIGb6X6jMSd.tanNLBuVN7tMi2', '1', '0', '2019-04-19 05:27:47', '0000-00-00 00:00:00', 'a1bbad40b950e365b37a8d4338d6861e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4939', 'szusaymeenmtzkvGP', 'Squiernen', 'kjj222@hotmail.com', '$2y$10$zihK/nf8paVMNFX45.zJhOljzrWHCpSgTD8wYtgHSrVccJDRwcAju', '1', '0', '2019-04-19 18:08:24', '0000-00-00 00:00:00', '3288b92537dbb480a1e17b0da9d76bf4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4940', 'zwusalmeotqwdacGP', 'Broncozqi', 'kdby4630@gmail.com', '$2y$10$EWDp9e3YEfaayEbpx5Xyx.4Tcrx4u4eh9KbS/U/RzlLcm7/y.V1Ze', '1', '0', '2019-04-19 18:26:21', '0000-00-00 00:00:00', '0e5c106ab14fa2727b48366871dba1c4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4941', 'zwusaymernkhzhbGP', 'Blenderxod', 'sbellia@bellandwilliams.com', '$2y$10$UYo2zxWt.jpGS0e3cE/mkO9YH2dsWNkxKjz5HlJueO72ALF84MSiu', '1', '0', '2019-04-19 19:21:06', '0000-00-00 00:00:00', '3da72166652084db9be3670253566f06', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4942', 'xzusafmenmofdwdGP', 'Portableuxm', 'm14ark@hotmail.com', '$2y$10$0UupFWgZvsid1dGlWceVKe5sVo3keZ1RZIYHpgWOpoIoOv3IjlUte', '1', '0', '2019-04-20 00:25:09', '0000-00-00 00:00:00', '6db99cf38084f6700636379c2e4461fe', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4943', 'xwusafmeymvizawGP', 'Irrigationstx', 'larastewart68@gmail.com', '$2y$10$uVX5JICn/OqewpHga9KdD.nXTF/EdxNh9IGM69tGNONfSfHsjAgwK', '1', '0', '2019-04-20 01:10:07', '0000-00-00 00:00:00', '4b0b3ccfbc7562c8ae64e0d21a72ba2d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4944', 'alexalexZU', 'alexalex', 'fasdwerr@bk.ru', '$2y$10$SUIkYrfEYBE77r6a2fCyMOlzBXTYZzGCsVcwuzDDpuLydcCojHIT6', '1', '0', '2019-04-20 01:58:17', '0000-00-00 00:00:00', '3b36447bce1522fe7eab15deca26017e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4945', 'remontatmorlereJB', 'remontatmorlere', 'arturnikonenko81@gmail.com', '$2y$10$5x6fqKUL8LmdC5bzx7H19.nshQFErSXKgcubFVbDJU75TQbPQEV7W', '1', '0', '2019-04-20 03:04:35', '0000-00-00 00:00:00', '6bb6066de343101165157ab16834c76d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4946', 'svusafmeftmmdopGP', 'Flashpaqxfl', 'john@phalenjohn.com', '$2y$10$RRWT8crU84I2o/a0dQQM5uepJAbV2FYuPRKlHipv7i.Qw0srlyZfe', '1', '0', '2019-04-20 06:11:44', '0000-00-00 00:00:00', 'f13d0e281897e6bd2d0085e2a9a5ccf0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4947', 'xvusafmefnaez3pGP', 'Batteryqsm', 'administrator@shafter.com', '$2y$10$8Zr1OU.6XMj8sc8JyxzR.OL7DZt.0Ch5EhUsdHXpM0yJLCJc91IR6', '1', '0', '2019-04-20 07:03:11', '0000-00-00 00:00:00', '17230bb8dcb05516b67685c043ae8a01', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4948', 'xzusafmeinusxvvGP', 'Milwaukeeeig', 'missylehto2@gmail.com', '$2y$10$CGFi41C7sFg1lzmUL5/8DeJCyMWfGjmk7bRpLnpSrQy3FpiGmwkU2', '1', '0', '2019-04-20 08:08:23', '0000-00-00 00:00:00', '588b8b47d79e9e368e0a1f6fd47b4b50', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4949', 'svusalmeftkhdvvGP', 'Focusxld', 'david.s.kwon@gmail.com', '$2y$10$QLTiB7OdK8GLp165Ba5/HuuFHzOVvqp9wyCu5PwOmVQndj4DKo6gK', '1', '0', '2019-04-20 10:11:41', '0000-00-00 00:00:00', '7e7c8a446599bd03ea4609add9fb4e50', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4950', 'swusafmeztbdzvaGP', 'Stanmorevmd', 'monkey118906@hotmail.com', '$2y$10$QefIQ3CwXt59KlGOtV17Iu3RuMOLYyRFyL5rxH9fl/MSSn.KpzNo2', '1', '0', '2019-04-20 15:20:17', '0000-00-00 00:00:00', '2650c420c9d3a15c0160a3ddf3cad09f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4951', 'Edgardo Bellinger', 'edgardo37g44100', '36242mackesy@poppellsimsdsaon.eu', '$2y$10$aQNMkpk0g4aIcQX7UVg7CeqqivsVWkeNI8NtMR63c4nUcfcz4ztWu', '0', '0', '2019-04-20 15:35:46', '2019-04-20 22:02:12', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4952', 'Jovita Daves', 'jovitadaves95021', '42306whillock@tarcuttgige.eu', '$2y$10$jSKi3rQ7p8zwTuBy2wp5UuNtIwNlSH3bpojaL3kA51fRcl0ztOxNy', '1', '0', '2019-04-21 01:49:34', '0000-00-00 00:00:00', 'af59c7eee44686060e00fafb548c1d0f', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4953', 'StethenevaliUC', 'Stethenevali', 'ivan12u5n@rambler.ru', '$2y$10$oFeRBqVHJ8KyNsIyrUGHpepTOaIh1dhgplmKNP4YLi1soaPfkBEba', '0', '0', '2019-04-21 03:24:37', '2019-04-21 03:27:06', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4954', 'InessaLempordermEQ', 'InessaLemporderm', 'inessapak86@gmail.com', '$2y$10$OOdLgalGPRK0llVt1tr9vuvRYWHvS.eVVR4SJupRJaUJEbwsVhKma', '1', '0', '2019-04-21 04:31:20', '0000-00-00 00:00:00', 'f1cf6d112e48594cbfddd3f86250e06c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4955', 'zzusafmehmzncpyGP', 'Focusqfb', 'morpheusmin@gmail.com', '$2y$10$i3yZ73soVxgkoQqTI1aOouw9c6sbMBL9QGH/pPl.dSnhFzj840tIO', '1', '0', '2019-04-21 05:55:21', '0000-00-00 00:00:00', 'ded940837caf16d33019f11ff0e34c0a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4956', 'xvusalmehnswznlGP', 'Edelbrockbuo', 'brunotmise@yahoo.com', '$2y$10$QmuTpR6eR8QEzHSnt1u4XeSbmWPkjbGKP.evjU1WNzDtcMY2WgWxS', '1', '0', '2019-04-21 12:40:55', '0000-00-00 00:00:00', '4c0aabbfcc72120519343d671da587a9', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4957', 'xvusaymepmptxecGP', 'Boschzha', 'jstass@pandlfoods.com', '$2y$10$qOWrh7Rf.J/HKscJ.JLKYeQSGdDRa2Sn2NCe81yHu4R02Euat3Gf.', '1', '0', '2019-04-21 14:13:11', '0000-00-00 00:00:00', '24907db2b9537204e47e77f5d8a8233a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4958', 'xvusaymexmqhzosGP', 'Flexiblewmm', 'mahlthatenfi@yahoo.com', '$2y$10$XYzPwJ0MZmeYGsKJlNQZJOEApFveWQzwPFHqQkSksBW1PyymLA9qG', '1', '0', '2019-04-21 18:28:01', '0000-00-00 00:00:00', '48dfe9694939f68e09b2e2669a61e0aa', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4959', 'szusalmedmoqzylGP', 'Milwaukeeqrd', 'jd.doyle@scisd.net', '$2y$10$zeA1FkGHren4YbayXB5bq.tUqYdVlplF394kpgfskYDuBj5fKRSJa', '1', '0', '2019-04-21 19:15:40', '0000-00-00 00:00:00', '93b81d3c371430698f5090ad08fd78eb', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4960', 'svusafmedngfxicGP', 'Generationvzy', 'trucovycin@gmail.com', '$2y$10$uMrO8BDB.891EVpoTkVNBOI.Axrc4ATqOGvi5mZf0nOEuG8Jh07l6', '1', '0', '2019-04-21 19:35:32', '0000-00-00 00:00:00', '073dac18894643b440e931490f17895d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4961', 'LindaKetBJ', 'LindaKet', 'stepangqkov@rambler.ru', '$2y$10$yzUrHPVNo01Ba.WUUzblLu/Q1mVmdcVtqtJzb5s8cY1dxqqmZI2D2', '0', '0', '2019-04-22 01:21:38', '2019-04-22 01:26:05', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4962', 'svusafmedmdzczbGP', 'Batteriesfcw', 'danieo1981@gmail.com', '$2y$10$HIlDI/FcXr1SFkEpwvpW.uUpjHf9Mi2rwrFqsmvavgZRQa2ab3jMi', '1', '0', '2019-04-22 05:48:19', '0000-00-00 00:00:00', '653e753c4a2d40fa12c1a50c2cda4b2a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4963', 'zwusalmeatapd3eGP', 'Foamxeb', 'director@vdsina.ru', '$2y$10$dJGfpPwyCADWPgy4N2ZBtOkmDDujkCNB3ufQ5V4upsguvRq3iuFAy', '1', '0', '2019-04-22 12:19:40', '0000-00-00 00:00:00', '3ccd2520879364bbac66c2d7b051b55e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4964', 'zzusalmejmygzawGP', 'Telecasterkac', 'madetime@hotmail.com', '$2y$10$6Mbd61SlQDjKXaegS88/GubiX/HxqaFzYfoKIeCfkiDHUFj00W1OG', '1', '0', '2019-04-22 12:40:55', '0000-00-00 00:00:00', '005dbb49e89bdafab9ba4ef8eba30129', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4965', 'zwusalmedmzyzjaGP', 'Superchipsdah', 'lewis.sundquist@bigfoot.com', '$2y$10$xrmQKRSZTHonAsSjNfQonuXVTYJEVmnY.vglElatYD/AJiwAjNRiO', '1', '0', '2019-04-22 13:08:36', '0000-00-00 00:00:00', 'd5c5d19acb73ddfdf293aad52845d4b3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4966', 'IsrealPekAS', 'IsrealPek', 'ru.huiya@bk.ru', '$2y$10$JhDT2XvApR1UQVUMOvANl.URHCnM0W/Kc.I8p5aR/cK/Z1JPqAZFG', '1', '0', '2019-04-22 15:02:43', '0000-00-00 00:00:00', 'c24e2d327a185f941f79a0fc72bbcec0', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4967', 'swusalmevntyd2gGP', 'Securitynfs', 'sueoverdorf@aol.com', '$2y$10$pyz8qOqbN7xpIONUR7zIZuUZS25SAUVOa5K5GoTHQwRDeHoSAptzO', '1', '0', '2019-04-22 16:57:26', '0000-00-00 00:00:00', '5c3851de22f2fa621a59953d2d7d0b86', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4968', 'svusafmeemvyxrnGP', 'Wirelessdvy', 'joshuadeese3@gmail.com', '$2y$10$DiWnefOJHaNTrwtfFrS3wuGFGdMm/SHBW/7iIIVtW.0487W.YVAY2', '1', '0', '2019-04-23 05:49:15', '0000-00-00 00:00:00', 'fbf9ff5c4b6bcdf3619e28e686a23542', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4969', 'xvusalmetmhux3pGP', 'Weaponzrm', 'jonathan.lee@aabacoplastics.com', '$2y$10$9owhkTRafhFLPgBYjgv8pu2OvKOu04oiJF6V/EG/pkYxaJX6PbLs.', '1', '0', '2019-04-23 15:41:50', '0000-00-00 00:00:00', 'c35d691ea3ec14408538fcd482b65a47', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4970', 'swusafmeqtarxeuGP', 'Batteriesksy', 'djc4388@yahoo.com', '$2y$10$O9R1.9nSDfPI2Ml7JQr7gewfgtRHLAoX.IqBTf4.jh8UqBNgVzdra', '1', '0', '2019-04-23 15:46:44', '0000-00-00 00:00:00', 'e2f624e8affd48933be092068ddf4f39', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4971', 'xwusafmeotgdcdtGP', 'Blenderjhz', 'rayallenweeksjr@gmail.com', '$2y$10$J9cTh25VOiBqzPNi26aIJ.mjwHKTejiFH.uNNrOk/uqpF9y1amngy', '1', '0', '2019-04-23 19:03:34', '0000-00-00 00:00:00', '9655e28c342384f06e43c74a12856a96', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4972', 'szusafmeetulzybGP', 'Keypadaqpi', 'bobfranks0907@gmail.com', '$2y$10$kRa.NtGTh.FjMnDMhMN2Ve5iHA3xMLX2ucdQE3HyJcq1LqQNq713e', '1', '0', '2019-04-23 20:29:17', '0000-00-00 00:00:00', 'd047d859f94f0439c0cab9ec8533bed6', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4973', 'zvusafmentovzcoGP', 'Epiphonexcl', 'purcoulptehear@hotmail.com', '$2y$10$b5TWfdsVfzMcU5cr80RxL.iMvnnn5DjUhNzjVFAmHxXT9v0wzhEjK', '1', '0', '2019-04-24 07:05:45', '0000-00-00 00:00:00', '656135f257a4f04144c35f8e21cd486b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4974', 'RohondaCausyZU', 'RohondaCausy', 'ilya02nvbobrov@rambler.ru', '$2y$10$H1CAGitV7cO/oPvGhl/ah.bGbQ140qXZwpX41u1tdICzB1olhbFdO', '0', '0', '2019-04-24 07:48:21', '2019-04-24 07:58:38', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4975', 'xzusafmefmdnxdjGP', 'Blendervis', 'aharberson@spiratex.com', '$2y$10$P2SVFGdXeTHr1r.mXM0Ml.AALpENGzjINYMlfhPmwSP8YWBYogP4.', '1', '0', '2019-04-24 08:45:51', '0000-00-00 00:00:00', '441cc2cbf98275f7baf9d59f717016dd', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4976', 'zwusalmepmelceiGP', 'Holographicnrx', 'rvinci@netlook.com', '$2y$10$eTPI2MQdehn8OsrSaJCHQODCVIW036jDgTsDBHFfm9la8Y4Bf.GMW', '1', '0', '2019-04-24 13:45:04', '0000-00-00 00:00:00', 'aee9b5a6023ceb0b2b051aa714cec051', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4977', 'szusafmentpbxbfGP', 'Keypadatau', 'itsahmia@yahoo.com', '$2y$10$rDOO5HRS5OAOdlc9UuExN..Uk/Lw0jN14v8m1WpKLDabrrijTBqq2', '1', '0', '2019-04-24 16:53:18', '0000-00-00 00:00:00', 'c3b7912afe58bf051b68f07b770a2c7a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4978', 'WilliememalsXN', 'Williememals', 'sawateew.vladlen@mail.ru', '$2y$10$c7uUWMDHmeL/izx4YOkJdOqeeMW/QngSPotDhzKo9KF3y4ovG7ULW', '1', '0', '2019-04-24 17:27:18', '0000-00-00 00:00:00', '7e871c48ea036b111a4feee062da1dc1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4979', 'xwusalmectiqdyzGP', 'iAquaLinklse', 'vaskonesevski@gmail.com', '$2y$10$iOlvANaOa.jxGWwBZ3EkD.BRdJd/NQeOCe7/.ssCGB7qwqxnr3.Ya', '1', '0', '2019-04-24 21:38:35', '0000-00-00 00:00:00', '8a796425f490677843270d086a12ffe7', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4980', 'xzusafmettorcgsGP', 'Fenderosl', 'info@dentalartsofbedford.com', '$2y$10$Dz94IQkfkocF0VfF4z6YguUBEKRdqbB3x2ihUAVr7Nst1My3lHdR6', '1', '0', '2019-04-25 15:41:52', '0000-00-00 00:00:00', '3b211edd5e2a447cdf22aba3fd65b284', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4981', 'zzusalmeanatxnvGP', 'Minelabrgl', 'helenehs2@gmail.com', '$2y$10$/Ikupv95sNhlE6MjievGNuqxi1dBsPNT63jtIXKLM2VL4O9rtD7se', '1', '0', '2019-04-25 22:38:22', '0000-00-00 00:00:00', '213a89b051585b49964dac446572067e', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4982', 'zwusafmeotysdqhGP', 'Scannerdoy', 'eric@controltechonline.com', '$2y$10$SIWbvcDPcRkJKjwHfutfHORCPQvbDOTULxa.gNT/CLQAninfE2Thu', '1', '0', '2019-04-26 00:45:40', '0000-00-00 00:00:00', '0dbe77b13c1deb6193e198b4d3e0a423', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4983', 'xwusafmetmoczriGP', 'Securityljc', 'joel@activemktg.com', '$2y$10$jkpjgyBvBH1Fq4owcSV5p.3Xer5HuOJEEnv.fCOksUB9xeR6ZP34u', '1', '0', '2019-04-26 01:23:41', '0000-00-00 00:00:00', '674738043a2a02fe3485a1efff956862', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4984', 'zzusaymejmxzzsrGP', 'Feederbid', 'vsteed@unisonbh.com', '$2y$10$5I2HmYpNcPwXtjUigrMGkukh4SodxMvV//Uv3Mo4UdJnxNmsGjXo.', '1', '0', '2019-04-26 02:04:24', '0000-00-00 00:00:00', '5f9a653f9a2436cfb47a7f604487dc51', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4985', 'You Want Histology?', 'ddmfhey', 'wlyksponh@judpharmacy.org', '$2y$10$reYMcwB/ovDQyjOiKd/h0OPRqr6bAkgp8gSmKUir..BmsDPHLp4T2', '0', '0', '2019-04-26 03:14:45', '2019-04-26 03:15:57', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4986', 'zzusaymeutykzjrGP', 'Clamcasewbc', 'j.moskowitz@dsmarttech.com', '$2y$10$rF72llVU.DUS886l8oOSPedp0slp8Qdhpv66uDEoLz3oNBb9wphR2', '1', '0', '2019-04-26 04:41:39', '0000-00-00 00:00:00', '5c17c535f8bb96f17215a035705bba0b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4987', 'xzusaymesmifzhiGP', 'Yamahavws', 'jnert1@netzero.net', '$2y$10$KMCPohVcuSYcZ8C9ZuspcuqS6YptaZFYbn0duBXLYsVy2hDK5zOka', '1', '0', '2019-04-26 11:08:29', '0000-00-00 00:00:00', 'b63f4fe12c005d9b8b4c1427c9dc03c5', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4988', 'KellyvowDP', 'Kellyvow', 'ira187654@gmail.com', '$2y$10$.VYN0Q2NLtVqu1CWHbBI4uNt8y14zF3PDLzakrtyOPqxH0OTUuDnG', '1', '0', '2019-04-26 12:50:28', '0000-00-00 00:00:00', '6e99fe8abd70b42348d8d934377fae87', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4989', 'swusalmebnkidzwGP', 'Rachiovzd', 'dwaterman@new.rr.com', '$2y$10$dVdD2ygw9dJNmStVClIFiuJlMYK/LcQot2P6n/REG8PryrEHQxEn6', '1', '0', '2019-04-26 14:54:56', '0000-00-00 00:00:00', 'dbc050a35afc60df466fc61186b11e41', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4990', 'DavydZeXRQ', 'DavydZeX', 'kirillsw9iu@rambler.ru', '$2y$10$zBh9JW8TQWcF4ALTYN7rpuzvgNFUluq1FcdeELFu0s1ER9Im7mqgK', '0', '0', '2019-04-26 18:22:27', '2019-04-26 18:25:09', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4991', 'HubbadioloHL', 'Hubbadiolo', 'hubbardrosalind@gmx.com', '$2y$10$6.YdyGLg5Nq7CGB4oo.TguyUn6o1xBHe4gyMCScdhS3l1KjkkLtrm', '1', '0', '2019-04-26 19:35:23', '0000-00-00 00:00:00', '76bae5a19448b866263d2f69616371ea', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4992', 'xvusafmeitzlzipGP', 'Weaponndl', 'christopher.g.stearns@gmail.com', '$2y$10$L.7G1TrClujcwz9U8ggNYeqkiG2mfgK.hixIohfPnqlUEKJCqJ1eS', '1', '0', '2019-04-26 23:02:38', '0000-00-00 00:00:00', '489e16666381412eed76ab3acd28c96c', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4993', 'svusaymeamqocmfGP', 'Businesszfp', 'josbourn34@gmail.com', '$2y$10$fY/u7vreaGdDiLRmlIIByOTnRzyr3ZgY8yHwX4uk/TQ2QKdOy0CAq', '1', '0', '2019-04-27 00:15:21', '0000-00-00 00:00:00', '7fd092231801fbc58b4e6288d7905847', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4994', 'xwusafmecmqxxcfGP', 'Scannergjl', 'cssl@cssabq.com', '$2y$10$QTTV43dTfYJp1ZadYoeteeP4puZAC0PEBddBQHoys/VAf77iXiUGq', '1', '0', '2019-04-28 08:40:58', '0000-00-00 00:00:00', '0c94f48efdd67047ac8ba7a2282b2c86', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4995', 'szusafmewmqlcxfGP', 'Drywallcsx', 'hustonemma@yahoo.com.au', '$2y$10$gHzjZfqTsslLdRgHOQ8BoOqsh3fHzIkEzVtlLWozpJ4jfj0XE8ANC', '1', '0', '2019-04-28 13:28:29', '0000-00-00 00:00:00', '905f7e3a6f6269eee41121f2b623e4a3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4996', 'JamesTiniaFF', 'JamesTinia', 'xhamster@andronov.us', '$2y$10$ciiLsJ2MlqVfYWHRJPBEEOSYyiR5TGrWYQrz/tPTgLADbes6c7Juu', '0', '0', '2019-04-28 16:19:39', '2019-04-28 16:25:25', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4997', 'How Does Nephrology Work?', 'ovjevt', 'igkitbrmi@judpharmacy.org', '$2y$10$eE1.tLK4BFZttldhlUa0IulYzgb179iNyYWA3qrmiK.7EDsqrWLt.', '0', '0', '2019-04-28 18:24:23', '2019-05-08 10:30:23', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4998', 'bRobertDTC', 'bRobertD', 'sochixxxinf.o@gmail.com', '$2y$10$PuuhZ1IKwfa8KLXDWHjta.kcTs0H9bY97J.Gj1PnnvPGqMcj54aaO', '0', '0', '2019-04-30 19:58:53', '2019-04-30 20:13:08', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('4999', 'zwusaymeimhczrrGP', 'Beateriuf', 'leckeypferer@mail.com', '$2y$10$24BV5YUckRWZLDJy2.ZrcOU3kBQLlHXHS/Qj710gPMBDdGx3FdNua', '1', '0', '2019-05-01 10:32:24', '0000-00-00 00:00:00', '317567d3f676e5a4e16e1f3bd9b3caa2', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5000', 'zvusafmermmvdjcGP', 'Humminbirdfpa', 'highlaneehi@hotmail.com', '$2y$10$xNfD2ruhD0xIdXYXjETH3OP21GlxQlh.TLLlOO8c.Dol6tjgZjtWu', '1', '0', '2019-05-01 22:14:17', '0000-00-00 00:00:00', '361da91cc748c8f0446751e632e4da2b', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5001', 'AlichePedUY', 'AlichePed', 'leonidorxy9@rambler.ru', '$2y$10$mBvetElglV30LIQBt2tFm.u/NYJc1ZPTF2CRlO2GN76ES5vxtclUa', '0', '0', '2019-05-04 05:58:02', '2019-05-04 06:00:52', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5002', 'MonicalinkolAU', 'Monicalinkol', 'inessaermakova72@gmail.com', '$2y$10$6odoAcMqM2zIoTgburVYfeQ9.XiixfT1mUk1fDcO2TLNmJSsw2TU2', '0', '0', '2019-05-04 07:58:13', '2019-05-04 11:56:30', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5003', 'WallaceElodaWB', 'wallaceNok', 'allal1k8we@bigmir.net', '$2y$10$UoDzzw0e6QKML/76VEm6mOBV..PvqVFrBQxER8qaotDUFFXpYvD9O', '0', '0', '2019-05-04 23:57:20', '2019-05-05 00:38:25', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5004', 'swusayme2twqzinGP', 'Superchipsdfb', 'bozonightmare40@gmail.com', '$2y$10$jOOc09yeTgGlu1GZPZL3jODYm53rODjNB5r2bgtZIuq/obtI13evi', '1', '0', '2019-05-06 11:51:59', '0000-00-00 00:00:00', 'd6f9ca5c9bf442913a96752d75e0562a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5005', 'xwusaymeinplxssGP', 'Humminbirdhwk', 'zoe6293@gmail.com', '$2y$10$fYzd/TPl9pDuH2QpRA7Ue.c7EWmDAoCybyJN1qgTI.l6umZXgAgaS', '1', '0', '2019-05-06 13:55:16', '0000-00-00 00:00:00', '233d2c18b2332a3243dea24b09514495', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5006', 'MerleignonRX', 'Merleignon', 'mingatarilaso@gmail.com', '$2y$10$72A5A34WU8fza9HPCyU1fOZFE.9eAtJ5gENsBmRHnI4iKUoJoKZW2', '1', '0', '2019-05-07 06:00:31', '0000-00-00 00:00:00', '91d33321c5cecbe8659c05dcba115b22', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5007', 'zwusalmetmtsxotGP', 'Mojavetct', 'kellyks@netscape.net', '$2y$10$Tuin2g./HJOrCkHezOl7kuNkdB9ilQptUeV9TgUgzewoFPjW45C5C', '1', '0', '2019-05-07 14:24:36', '0000-00-00 00:00:00', 'a240a8c10fee0e3e8e666f95417352f3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5008', 'zvusafmepntsxohGP', 'Premiumlns', 'beatriz@sibco.com', '$2y$10$rTFBIRH2H4KRNqHinhtA2eRA9QY6V6cSbISFfX9h11LShSgIUAMrC', '1', '0', '2019-05-07 22:22:10', '0000-00-00 00:00:00', 'dfbf2dc5688d165c33ebd198347021e1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5009', 'xwusafmeltmwduzGP', 'Flukeciu', 'sbmg45@gmx.com', '$2y$10$s.ImpZAidKrkuqMavNwGQOCsP9Dn5GvYW66pDOlqxeX8T94yT0Wj2', '1', '0', '2019-05-07 23:47:32', '0000-00-00 00:00:00', '8449d915bd6f980ea8e82a114a14c3e3', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5010', 'TendyBakRG', 'TendyBak', 'stepan1i1ku@rambler.ru', '$2y$10$j932Ls5yLoTSgRfBn47DjeaILOvoZ521w8nas.Fu8T4vSwWX7Wzqu', '0', '0', '2019-05-08 00:40:10', '2019-05-08 00:44:54', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5011', 'xzusafme2mkgdneGP', 'Backlitowb', 'rhonda@compressorelements.com', '$2y$10$besiAPTnkHDXToe6YfeQMuok/5zFyH0BmmTlr1ygey/Z3htNnRb3u', '1', '0', '2019-05-08 00:52:40', '0000-00-00 00:00:00', '8eeab90f2d06e8f9d10f77f62ebee3e4', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5012', 'xwusafmewnrdxqeGP', 'Independentdzh', 'svernava@glenn-leetrucking.com', '$2y$10$/2DbIXoCSBn3sZW.tpm3qemdHh2TDdRb1dacUkwihT1n.Pqvb/oqi', '1', '0', '2019-05-08 14:40:32', '0000-00-00 00:00:00', 'c94473791c0543ac7fd16145ba137d57', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5013', 'xvusafmegncyzynGP', 'Airbladeaic', 'rafaels@tech-center.com', '$2y$10$4tnh2lVKJwYlmM0vs6VMc.agcT1Wxq9YeTui6A/604g5Q70l75ym2', '1', '0', '2019-05-08 17:57:26', '0000-00-00 00:00:00', '943d8400f104b9a4ab3f4afd9fe11cfe', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5014', 'xvusaymeotfjzmfGP', 'WILDKATjlp', 'rccilona@gmail.com', '$2y$10$fiTBMM0RR6iszmca6wCgWeccYrb81/17VcU1lSuC2cBElt7m5.9F2', '1', '0', '2019-05-08 22:09:59', '0000-00-00 00:00:00', 'f46346d3bd46f06ad6dc133067fc9602', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5015', 'xvusafmevtcwdjoGP', 'Independentbls', 'emott1@austin.rr.com', '$2y$10$Wz6WDIoOMZHyoHQklzSZ/OqFyVxd1nlwGvmh0A6eDBs4L466wF58u', '1', '0', '2019-05-09 12:21:59', '0000-00-00 00:00:00', 'fb78edd04cc9107c178f501d7670e41a', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5016', 'xzusaymeqnerzxeGP', 'Rachioscd', 'mfindura@beveragedist.com', '$2y$10$NiY5gEFRbd6bj76rYSrk9.yrnIBDhLaasxWN0BfS6Ii7PNPTXY0W2', '1', '0', '2019-05-09 14:02:11', '0000-00-00 00:00:00', '289e718ab4c47eec9a6dff9a00d5d321', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5017', 'szusaymektaydymGP', 'Extractiondtx', 'dancatalanello@gmail.com', '$2y$10$i39HJZakwvtSXf2UR5G3V.BLgcfPKNCdotMnQxtBTOcbj2olGcdL2', '1', '0', '2019-05-09 18:36:14', '0000-00-00 00:00:00', '0e15f2f31e96529988139c5cdb0ce4b1', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5018', 'xwusafmetmcfderGP', 'Batteriesanu', 'ggrisham@ahmgt.com', '$2y$10$N6Q6MuQPNUr03UtPQ3GnfuSBYFRoywLyPIEIC4Bc8k1zf8xnIV1e.', '0', '0', '2019-05-10 09:49:19', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5019', 'zvusalmebnugcupGP', 'iAquaLinkkjz', 'karbie05@yahoo.com', '$2y$10$D83J9ooZbV2yXEuUlMy.hedD7pjyFnYKqmXASbgMLa/HX0QNRYZ/G', '1', '0', '2019-05-10 16:12:46', '0000-00-00 00:00:00', 'ecec12153e35b648112c222b1b232f2d', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5020', 'szusaymeztbhzevGP', 'Squierkjd', 'metzger@suddenlink.net', '$2y$10$c2nR/cb7M1TBu62yZyI13egQnVbNsa2V4heQ7gvGSeMqCaOzUgn4.', '1', '0', '2019-05-10 19:16:58', '0000-00-00 00:00:00', '8a5c3142f86bfe03e442d421c4d233ab', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5021', 'Here\'s What I Know About Cardiology', 'vvmzgt', 'tqauslysb@judpharmacy.org', '$2y$10$cvsgHy.1qWlNL9OR7UAJ9u4IHTBUXSYC6aZ1OuZ9VCAEhcElGq262', '0', '0', '2019-05-10 21:16:48', '2019-05-26 02:18:01', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5022', 'xvusafmepmyedlxGP', 'Carpetfuy', 'dmeek@hc-inc.com', '$2y$10$nIhNlVRHFO1tBWdgnPDOLu0DSRA4uydj7YELGP/V8ze9gEb/ExVxS', '1', '0', '2019-05-11 02:16:52', '0000-00-00 00:00:00', '4c2b26cacbf5912bf78f46d678f8f1ea', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5023', 'swusafmevtfexnjGP', 'Fenderuom', 'randtrice@netzero.com', '$2y$10$DCiFh8cwsZBmulYdps2kyOhyqE5djIG6v0faCCDDlQSLi6J8.mDWi', '1', '0', '2019-05-12 13:04:04', '0000-00-00 00:00:00', 'dd66ac536b3a2df5255d4fdcc583bfdd', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5024', 'zwusafmedtihzjzGP', 'Cutterxms', 'prob4444@gmail.com', '$2y$10$0FDcF1nv3Jg3Ka8gDR4mzeORHlDm9K318HTu3NKWBcKvPe6jJEWH6', '1', '0', '2019-05-12 14:48:03', '0000-00-00 00:00:00', '491aa3c9876d13a3e2b945b2e559b949', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5025', 'zvusafmectmpctrGP', 'Vortexpxt', 'amy.garcia@live.com', '$2y$10$Z5.FyLxkJl8MXuoAB7/fgO3WiufEGgLwf1zZ7.W3maYv1XKAdXpjW', '1', '0', '2019-05-12 17:24:24', '0000-00-00 00:00:00', '3d349d2358bd4f53f50e825dd57ffb29', '{}', '0000-00-00 00:00:00', '0', '', '', '0', ''),
('5026', 'zwusaymettjixxeGP', 'Arnottoyf', 'patricia.coates@durhamnc.gov', '$2y$10$asb8YmcIbQSjF/9fZ4zPm.19qaf9uJsrWE90lC87y/gNTkpqAqmWy', '0', '0', '2019-05-12 18:50:22', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', '0', '', '', '0', '');/**ABDB**/
